/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.hila;

import eu.unicore.hila.ImplementationProvider;
import eu.unicore.hila.Location;
import eu.unicore.hila.LocationPattern;
import eu.unicore.hila.PackageUtil;
import eu.unicore.hila.Resource;
import eu.unicore.hila.annotations.ResourceType;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import org.apache.log4j.Logger;

public class ResourceTypeRegistry {
    private static volatile ResourceTypeRegistry theInstance = null;
    private static final Logger log = Logger.getLogger(ResourceTypeRegistry.class);
    private Map<LocationPattern, Class<Resource>> locationTypeMap;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ResourceTypeRegistry getInstance() {
        if (theInstance != null) return theInstance;
        Class<ResourceTypeRegistry> clazz = ResourceTypeRegistry.class;
        synchronized (ResourceTypeRegistry.class) {
            if (theInstance != null) return theInstance;
            theInstance = new ResourceTypeRegistry();
            // ** MonitorExit[var0] (shouldn't be in output)
            return theInstance;
        }
    }

    public Class<Resource> determineResourceType(Location location) {
        LocationPattern lp = this.determineLocationPattern(location);
        if (lp != null) {
            return this.locationTypeMap.get(lp);
        }
        return null;
    }

    public LocationPattern determineLocationPattern(Location location) {
        for (LocationPattern lp : this.locationTypeMap.keySet()) {
            if (!lp.match(location)) continue;
            return lp;
        }
        return null;
    }

    private ResourceTypeRegistry() {
        this.initialize();
    }

    private void initialize() {
        ArrayList<Class<Resource>> resourceTypes = new ArrayList<Class<Resource>>();
        ServiceLoader<ImplementationProvider> sl = ServiceLoader.load(ImplementationProvider.class);
        Iterator<ImplementationProvider> iter = sl.iterator();
        while (iter.hasNext()) {
            List<Package> packages = iter.next().getPackages();
            resourceTypes.addAll(this.findResourceTypes(packages));
        }
        this.locationTypeMap = this.buildLocationTypeMap(resourceTypes);
    }

    private Map<LocationPattern, Class<Resource>> buildLocationTypeMap(List<Class<Resource>> resourceTypes) {
        LinkedHashMap<LocationPattern, Class<Resource>> locationTypeMap = new LinkedHashMap<LocationPattern, Class<Resource>>(resourceTypes.size());
        for (Class<Resource> class1 : resourceTypes) {
            String[] stringLocationPatterns;
            for (String string : stringLocationPatterns = class1.getAnnotation(ResourceType.class).locationStructure()) {
                LocationPattern lp = new LocationPattern(string);
                locationTypeMap.put(lp, class1);
            }
        }
        return locationTypeMap;
    }

    private List<Class<Resource>> findResourceTypes(List<Package> packages) {
        ArrayList<Class<Resource>> resourceTypes = new ArrayList<Class<Resource>>();
        for (Package package1 : packages) {
            resourceTypes.addAll(this.findResourceTypes(package1));
        }
        return resourceTypes;
    }

    private List<Class<Resource>> findResourceTypes(Package package1) {
        return this.findResourceTypes3(package1);
    }

    private List<Class<Resource>> findResourceTypes3(Package package1) {
        ArrayList<Class<Resource>> resourceTypes = new ArrayList<Class<Resource>>();
        try {
            Set<Class<?>> classes = PackageUtil.getClasses(package1.getName());
            for (Class<?> class1 : classes) {
                if (!class1.isAnnotationPresent(ResourceType.class)) continue;
                resourceTypes.add(class1);
            }
        }
        catch (Exception e) {
            log.error((Object)"Unable to get set of classes from package.", (Throwable)e);
        }
        return resourceTypes;
    }
}

