/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.hila.shell.completors;

import eu.unicore.hila.Location;
import eu.unicore.hila.Resource;
import eu.unicore.hila.exceptions.HiLAException;
import eu.unicore.hila.exceptions.HiLALocationSyntaxException;
import eu.unicore.hila.shell.ShellContext;
import java.util.List;
import jline.Completor;
import org.apache.log4j.Logger;

public class LocationCompletor
implements Completor {
    private static final Logger log = Logger.getLogger(LocationCompletor.class);
    private ShellContext shellContext;

    public LocationCompletor(ShellContext _context) {
        this.shellContext = _context;
    }

    public int complete(String buffer, int cursor, List candidates) {
        Location partLoc;
        if (buffer == null) {
            try {
                Resource res = this.shellContext.getCurrentLocation().locate(new Object[0]);
                List children = res.getChildren();
                for (Resource resource : children) {
                    candidates.add(resource.getName());
                }
                return cursor;
            }
            catch (HiLAException e) {
                return 0;
            }
        }
        String partLocString = buffer.substring(buffer.lastIndexOf(32, cursor) + 1, cursor);
        if (log.isDebugEnabled()) {
            log.debug((Object)("partLocString: " + partLocString));
        }
        try {
            partLoc = new Location(partLocString);
        }
        catch (HiLALocationSyntaxException e1) {
            return 0;
        }
        if (partLocString.endsWith("/") || partLocString.isEmpty()) {
            try {
                Resource res = partLoc.locate(new Object[0]);
                List children = res.getChildren();
                for (Resource resource : children) {
                    candidates.add(resource.getName());
                }
                return cursor;
            }
            catch (HiLAException e) {}
        } else {
            if (!partLoc.isAbsolute()) {
                try {
                    partLoc = this.shellContext.getCurrentLocation().getChildLocation(partLocString);
                }
                catch (HiLALocationSyntaxException e) {
                    return 0;
                }
            }
            Location parentLoc = partLoc.getParentLocation();
            if (log.isDebugEnabled()) {
                log.debug((Object)("partLoc  : " + partLoc));
                log.debug((Object)("parentLoc: " + parentLoc));
            }
            String partName = partLoc.getName();
            try {
                Resource res = parentLoc.locate(new Object[0]);
                if (res == null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Trying absolute location: " + this.shellContext.getCurrentLocation().getChildLocation(partLocString)));
                    }
                    res = this.shellContext.getCurrentLocation().getChildLocation(partLocString).locate(new Object[0]);
                }
                if (res != null) {
                    List children = res.getChildren();
                    for (Resource resource : children) {
                        if (!resource.getName().startsWith(partName)) continue;
                        candidates.add(resource.getName());
                    }
                    return cursor - partName.length();
                }
            }
            catch (HiLAException e) {
                log.warn((Object)"Resource not locatable.", (Throwable)e);
            }
        }
        return 0;
    }
}

