/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.hila.shell.commands;

import eu.unicore.hila.exceptions.HiLAException;
import eu.unicore.hila.shell.ShellContext;
import eu.unicore.hila.shell.commands.ShellCommandBase;
import java.util.List;
import java.util.Map;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.ParseException;
import org.apache.log4j.Logger;

public class Unalias
extends ShellCommandBase {
    private static final Logger log = Logger.getLogger(Unalias.class);

    public Unalias() {
        this.initializeOptions();
    }

    private void initializeOptions() {
        OptionBuilder.withArgName((String)"a");
        OptionBuilder.withDescription((String)"Delete all aliases");
        OptionBuilder.withLongOpt((String)"all");
        this.options.addOption(OptionBuilder.create((String)"a"));
    }

    @Override
    public void execute(String[] cmdArgs, ShellContext ctx) throws HiLAException {
        try {
            Map<String, String> aliases = ctx.getAliases();
            CommandLine cmdLine = this.parser.parse(this.options, cmdArgs);
            if (cmdLine.hasOption("a")) {
                aliases.clear();
                return;
            }
            List argList = cmdLine.getArgList();
            argList.remove(0);
            for (String alias : argList) {
                aliases.remove(alias);
            }
        }
        catch (ParseException e) {
            log.error((Object)"Unable to parse command.", (Throwable)e);
        }
    }
}

