/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.hila.shell.commands;

import eu.unicore.hila.Location;
import eu.unicore.hila.exceptions.HiLAException;
import eu.unicore.hila.grid.File;
import eu.unicore.hila.shell.ShellContext;
import eu.unicore.hila.shell.commands.OptionConstants;
import eu.unicore.hila.shell.commands.ShellCommand;
import eu.unicore.hila.shell.commands.ShellCommandBase;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.ParseException;
import org.apache.log4j.Logger;

public class Rm
extends ShellCommandBase
implements ShellCommand {
    private static final Logger log = Logger.getLogger(Rm.class);

    public Rm() {
        this.initializeOptions();
    }

    private void initializeOptions() {
        this.options.addOption(OptionConstants.RECURSIVE);
        this.options.addOption(OptionConstants.HELP);
    }

    @Override
    public void execute(String[] cmdArgs, ShellContext ctx) throws HiLAException {
        CommandLine cmdLine;
        try {
            cmdLine = this.parser.parse(this.options, cmdArgs);
        }
        catch (ParseException e) {
            throw new HiLAException("Unable to parse command line.");
        }
        if (cmdLine.hasOption(OptionConstants.HELP.getArgName())) {
            this.printHelp(ctx);
            return;
        }
        List argList = cmdLine.getArgList();
        argList.remove(0);
        for (String fileStr : argList) {
            String fileLocStr = fileStr;
            Location fileLoc = new Location(fileLocStr);
            if (!fileLoc.isLocationOfType(File.class)) {
                fileLoc = ctx.getCurrentLocation().getChildLocation(fileLocStr);
            }
            if (!fileLoc.isLocationOfType(File.class)) {
                log.error((Object)(fileLocStr + " is not a valid relative or absolute File location."));
                continue;
            }
            File file = (File)fileLoc.locate(new Object[0]);
            file.delete(cmdLine.hasOption(OptionConstants.RECURSIVE.getArgName()));
        }
    }
}

