/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.hila.shell;

import eu.unicore.hila.exceptions.HiLAException;
import eu.unicore.hila.exceptions.HiLALocationSyntaxException;
import eu.unicore.hila.shell.ShellContext;
import eu.unicore.hila.shell.commands.Abort;
import eu.unicore.hila.shell.commands.Alias;
import eu.unicore.hila.shell.commands.Cat;
import eu.unicore.hila.shell.commands.Cd;
import eu.unicore.hila.shell.commands.ChMod;
import eu.unicore.hila.shell.commands.Cleanup;
import eu.unicore.hila.shell.commands.Cp;
import eu.unicore.hila.shell.commands.Exit;
import eu.unicore.hila.shell.commands.Export;
import eu.unicore.hila.shell.commands.GetMetadata;
import eu.unicore.hila.shell.commands.Help;
import eu.unicore.hila.shell.commands.Import;
import eu.unicore.hila.shell.commands.LCd;
import eu.unicore.hila.shell.commands.LLs;
import eu.unicore.hila.shell.commands.LPwd;
import eu.unicore.hila.shell.commands.Ls;
import eu.unicore.hila.shell.commands.MkDir;
import eu.unicore.hila.shell.commands.Monitor;
import eu.unicore.hila.shell.commands.Mv;
import eu.unicore.hila.shell.commands.Pwd;
import eu.unicore.hila.shell.commands.Rm;
import eu.unicore.hila.shell.commands.Run;
import eu.unicore.hila.shell.commands.ShellCommand;
import eu.unicore.hila.shell.commands.Start;
import eu.unicore.hila.shell.commands.Status;
import eu.unicore.hila.shell.commands.Submit;
import eu.unicore.hila.shell.commands.Time;
import eu.unicore.hila.shell.commands.Transfer;
import eu.unicore.hila.shell.commands.Unalias;
import eu.unicore.hila.shell.commands.Version;
import eu.unicore.hila.shell.completors.CommandMultiplexedCompletor;
import eu.unicore.hila.shell.completors.LocationCompletor;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jline.Completor;
import jline.ConsoleReader;
import jline.FileNameCompletor;
import jline.MultiCompletor;
import jline.SimpleCompletor;
import org.apache.log4j.Logger;

public class HiLAShell {
    private static final Logger log = Logger.getLogger(HiLAShell.class);

    public static void main(String[] args) throws HiLALocationSyntaxException {
        ConsoleReader cs = null;
        try {
            cs = new ConsoleReader();
            File hila2 = new File(System.getProperty("user.home") + File.separator + ".hila2");
            if (!hila2.exists()) {
                hila2.mkdirs();
            } else if (!hila2.isDirectory()) {
                log.warn((Object)"Won't be able to store history, as ~/.hila2 exists, but is an ordinary file.");
            } else {
                File history = new File(hila2, "shell-history");
                cs.getHistory().setHistoryFile(history);
            }
        }
        catch (IOException e) {
            log.error((Object)"Unable to open console. Cannot use HiLA Shell.", (Throwable)e);
            return;
        }
        ShellContext sc = new ShellContext(cs);
        Ls ls = new Ls();
        sc.registerCommand(ls.getName(), ls);
        Exit exit = new Exit();
        sc.registerCommand(exit.getName(), exit);
        sc.registerCommand("quit", exit);
        Cd cd = new Cd();
        sc.registerCommand(cd.getName(), cd);
        sc.registerCommand("chdir", cd);
        Cleanup _cleanup = new Cleanup();
        sc.registerCommand(_cleanup);
        MkDir _mkdir = new MkDir();
        sc.registerCommand(_mkdir);
        Pwd pwd = new Pwd();
        sc.registerCommand(pwd);
        Submit submit = new Submit();
        sc.registerCommand(submit);
        Help help = new Help();
        sc.registerCommand(help);
        Export _export = new Export();
        sc.registerCommand(_export);
        Import _import = new Import();
        sc.registerCommand(_import);
        Rm _rm = new Rm();
        sc.registerCommand(_rm.getName(), _rm);
        LPwd _lpwd = new LPwd();
        sc.registerCommand(_lpwd);
        LCd _lcd = new LCd();
        sc.registerCommand(_lcd);
        LLs _lls = new LLs();
        sc.registerCommand(_lls);
        ChMod _chmod = new ChMod();
        sc.registerCommand(_chmod);
        Start _start = new Start();
        sc.registerCommand(_start);
        Time _time = new Time();
        sc.registerCommand(_time);
        Transfer _transfer = new Transfer();
        sc.registerCommand(_transfer);
        Mv _move = new Mv();
        sc.registerCommand(_move);
        sc.registerCommand("move", _move);
        Cp _copy = new Cp();
        sc.registerCommand(_copy);
        sc.registerCommand("copy", _copy);
        Abort _abort = new Abort();
        sc.registerCommand(_abort);
        sc.registerCommand("cancel", _abort);
        Monitor _monitor = new Monitor();
        sc.registerCommand(_monitor);
        Run _run = new Run();
        sc.registerCommand(_run);
        Status _status = new Status();
        sc.registerCommand(_status);
        Version _version = new Version();
        sc.registerCommand(_version);
        Cat _cat = new Cat();
        sc.registerCommand(_cat);
        GetMetadata _getMetadata = new GetMetadata();
        sc.registerCommand(_getMetadata);
        Alias _alias = new Alias();
        sc.registerCommand(_alias);
        Unalias _unalias = new Unalias();
        sc.registerCommand(_unalias);
        MultiCompletor argCmpl = new MultiCompletor(new Completor[]{new SimpleCompletor(sc.getCommands().toArray(new String[sc.getCommands().size()])), new MultiCompletor(new Completor[]{new CommandMultiplexedCompletor(sc), new LocationCompletor(sc), new FileNameCompletor()})});
        cs.addCompletor((Completor)argCmpl);
        int ioErrorCount = 0;
        while (!sc.isDone()) {
            try {
                String cmd = null;
                cmd = sc.getCurrentLocation() != null ? cs.readLine(sc.getCurrentLocation().getName().toString() + " :> ") : cs.readLine("hila > ");
                if (cmd == null) {
                    cs.printNewline();
                    cs.getHistory().flushBuffer();
                    System.exit(0);
                    return;
                }
                ioErrorCount = 0;
                String[] cmdArgs = HiLAShell.splitArguments(cmd = cmd.trim());
                if (cmdArgs.length <= 0) continue;
                if (sc.isAlias(cmdArgs[0])) {
                    String aliasCommand = sc.getAlias(cmdArgs[0]);
                    StringBuilder sb = new StringBuilder(aliasCommand);
                    for (int i = 1; i < cmdArgs.length; ++i) {
                        sb.append(' ' + cmdArgs[i]);
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Rewritten, aliased command: " + sb.toString()));
                    }
                    cmdArgs = HiLAShell.splitArguments(sb.toString());
                }
                if (cmdArgs.length <= 0) continue;
                ShellCommand exCmd = sc.getCommand(cmdArgs[0]);
                if (exCmd != null) {
                    try {
                        exCmd.execute(cmdArgs, sc);
                    }
                    catch (HiLAException e) {
                        log.error((Object)e);
                    }
                    continue;
                }
                log.warn((Object)("Unknown command: " + cmdArgs[0]));
            }
            catch (IOException e) {
                log.error((Object)"Cannot read from or write to console.", (Throwable)e);
                if (++ioErrorCount <= 3) continue;
                log.error((Object)"Too many IOExceptions. Exiting.");
                return;
            }
        }
    }

    private static String[] splitArguments(String cmd) {
        ArrayList<String> arguments = new ArrayList<String>();
        Pattern p = Pattern.compile("[^\\s\"']+|\"([^\"]*)\"|'([^']*)'");
        Matcher m = p.matcher(cmd);
        while (m.find()) {
            if (m.group(1) != null) {
                arguments.add(m.group(1));
                continue;
            }
            if (m.group(2) != null) {
                arguments.add(m.group(2));
                continue;
            }
            arguments.add(m.group());
        }
        return arguments.toArray(new String[arguments.size()]);
    }
}

