/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.hila.job.jsdl;

import eu.unicore.hila.job.model.JobModel;
import eu.unicore.hila.job.model.StageIn;
import eu.unicore.hila.job.model.StageOut;
import eu.unicore.hila.job.spi.NativeToModel;
import org.apache.log4j.Logger;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.CreationFlagEnumeration;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.DataStagingType;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.JobDefinitionDocument;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.JobDescriptionType;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.JobIdentificationType;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.ResourcesType;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.SourceTargetType;
import org.ggf.schemas.jsdl.x2005.x11.jsdlPosix.ArgumentType;
import org.ggf.schemas.jsdl.x2005.x11.jsdlPosix.EnvironmentType;
import org.ggf.schemas.jsdl.x2005.x11.jsdlPosix.POSIXApplicationDocument;
import org.ggf.schemas.jsdl.x2005.x11.jsdlPosix.POSIXApplicationType;

public class JSDLtoModel
implements NativeToModel {
    private static final Logger log = Logger.getLogger(JSDLtoModel.class);
    private JobDefinitionDocument jsdl = null;
    private JobModel model;

    public JSDLtoModel(Object _jsdl) {
        this.jsdl = (JobDefinitionDocument)_jsdl;
    }

    public JobModel getModel() {
        if (this.model == null) {
            this.transform();
        }
        return this.model;
    }

    /*
     * WARNING - void declaration
     */
    private void transform() {
        DataStagingType[] dataStagings;
        int len$;
        String[] arr$;
        this.model = new JobModel();
        JobDescriptionType jDescr = this.jsdl.getJobDefinition().getJobDescription();
        POSIXApplicationType posixApp = null;
        if (jDescr.getApplication().selectChildren(POSIXApplicationType.type.getDocumentElementName()).length > 0) {
            XmlObject[] posixNodes = jDescr.getApplication().selectChildren(POSIXApplicationDocument.type.getDocumentElementName());
            try {
                if (posixNodes.length > 0) {
                    posixApp = POSIXApplicationType.Factory.parse((String)posixNodes[0].xmlText());
                }
            }
            catch (XmlException e) {
                log.error((Object)"Unable to parse POSIXApplication element", (Throwable)e);
            }
        }
        if (jDescr.isSetApplication()) {
            if (jDescr.getApplication().isSetApplicationName()) {
                this.model.setApplicationName(jDescr.getApplication().getApplicationName());
                if (jDescr.getApplication().isSetApplicationVersion()) {
                    this.model.setApplicationVersion(jDescr.getApplication().getApplicationVersion());
                }
            } else if (posixApp != null) {
                this.model.setExecutable(posixApp.getExecutable().getStringValue());
            }
            if (jDescr.getApplication().isSetDescription()) {
                this.model.setApplicationDescription(jDescr.getApplication().getDescription());
            }
        }
        if (posixApp != null) {
            void var7_14;
            ArgumentType[] arguments;
            for (ArgumentType argumentType : arguments = posixApp.getArgumentArray()) {
                this.model.addArgument(argumentType.getStringValue());
            }
            EnvironmentType[] environment = posixApp.getEnvironmentArray();
            arr$ = environment;
            len$ = arr$.length;
            boolean bl = false;
            while (var7_14 < len$) {
                String string = arr$[var7_14];
                this.model.addEnvironment(string.getName(), string.getStringValue());
                ++var7_14;
            }
            if (posixApp.isSetInput()) {
                this.model.setStdin(posixApp.getInput().getStringValue());
            }
            if (posixApp.isSetOutput()) {
                this.model.setStdout(posixApp.getOutput().getStringValue());
            }
            if (posixApp.isSetError()) {
                this.model.setStderr(posixApp.getError().getStringValue());
            }
        }
        if (jDescr.isSetJobIdentification()) {
            String[] projects;
            String[] annotations;
            JobIdentificationType jobId = jDescr.getJobIdentification();
            if (jobId.isSetJobName()) {
                this.model.setTaskName(jobId.getJobName());
            }
            if ((annotations = jobId.getJobAnnotationArray()) != null) {
                void var7_16;
                arr$ = annotations;
                len$ = arr$.length;
                boolean bl = false;
                while (var7_16 < len$) {
                    String string = arr$[var7_16];
                    this.model.addJobAnnotation(string);
                    ++var7_16;
                }
            }
            if (jobId.isSetDescription()) {
                this.model.setJobDescription(jobId.getDescription());
            }
            if ((projects = jobId.getJobProjectArray()) != null) {
                void var8_23;
                String[] arr$2 = projects;
                int n = arr$2.length;
                boolean bl = false;
                while (var8_23 < n) {
                    String project = arr$2[var8_23];
                    this.model.addJobProject(project);
                    ++var8_23;
                }
            }
        }
        if (jDescr.isSetResources()) {
            this.model.setResources((ResourcesType)jDescr.getResources().copy());
        }
        if ((dataStagings = jDescr.getDataStagingArray()) != null) {
            for (ArgumentType argumentType : dataStagings) {
                SourceTargetType target;
                SourceTargetType source;
                String string = argumentType.getFileName();
                String fileSystemName = null;
                if (argumentType.isSetFilesystemName()) {
                    fileSystemName = argumentType.getFilesystemName();
                }
                CreationFlagEnumeration.Enum creationFlag = argumentType.getCreationFlag();
                boolean deleteOnTermination = argumentType.getDeleteOnTermination();
                String sourceURI = null;
                if (argumentType.isSetSource() && (source = argumentType.getSource()).isSetURI()) {
                    sourceURI = source.getURI();
                }
                String targetURI = null;
                if (argumentType.isSetTarget() && (target = argumentType.getTarget()).isSetURI()) {
                    targetURI = target.getURI();
                }
                if (targetURI != null) {
                    StageOut stageout = new StageOut(string, targetURI, fileSystemName, creationFlag, deleteOnTermination);
                    this.model.addStageOut(stageout);
                }
                if (sourceURI == null) continue;
                StageIn stageIn = new StageIn(string, sourceURI, fileSystemName, creationFlag, deleteOnTermination);
                this.model.addStageIn(stageIn);
            }
        }
    }
}

