/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.util;

import com.sun.grizzly.util.ConnectionCloseHandler;
import com.sun.grizzly.util.SelectorFactory;
import com.sun.grizzly.util.WorkerThread;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.nio.channels.WritableByteChannel;

public class OutputWriter {
    private static int defaultWriteTimeout = 30000;

    public static long flushChannel(SelectableChannel channel, ByteBuffer bb) throws IOException {
        return OutputWriter.flushChannel(channel, bb, (long)defaultWriteTimeout);
    }

    public static long flushChannel(SelectableChannel channel, ByteBuffer bb, long writeTimeout) throws IOException {
        if (bb == null) {
            throw new IllegalStateException("Invalid Response State. ByteBuffer cannot be null.");
        }
        if (channel == null) {
            throw new IllegalStateException("Invalid Response State. SocketChannel cannot be null.");
        }
        SelectionKey key = null;
        Selector writeSelector = null;
        int attempts = 0;
        int nWrite = 0;
        int len = -1;
        try {
            WritableByteChannel writableChannel = (WritableByteChannel)((Object)channel);
            while (bb.hasRemaining()) {
                len = writableChannel.write(bb);
                if (len > 0) {
                    attempts = 0;
                    nWrite += len;
                    continue;
                }
                ++attempts;
                if (writeSelector == null) {
                    writeSelector = SelectorFactory.getSelector();
                    if (writeSelector == null) continue;
                    key = channel.register(writeSelector, 4);
                }
                if (writeSelector.select(writeTimeout) != 0 || attempts <= 2) continue;
                throw new IOException("Client disconnected");
            }
        }
        catch (IOException ex) {
            len = -1;
            throw ex;
        }
        finally {
            ConnectionCloseHandler cch;
            if (key != null) {
                key.cancel();
                key = null;
            }
            if (writeSelector != null) {
                SelectorFactory.selectNowAndReturnSelector(writeSelector);
            }
            if (len == -1 && Thread.currentThread() instanceof WorkerThread && (cch = (ConnectionCloseHandler)((WorkerThread)Thread.currentThread()).getAttachment().getAttribute("ConnectionCloseHandler")) != null) {
                cch.remotlyClosed(key);
            }
        }
        return nWrite;
    }

    public static long flushChannel(SocketChannel socketChannel, ByteBuffer[] bb) throws IOException {
        return OutputWriter.flushChannel(socketChannel, bb, (long)defaultWriteTimeout);
    }

    public static long flushChannel(SocketChannel socketChannel, ByteBuffer[] bb, long writeTimeout) throws IOException {
        if (bb == null) {
            throw new IllegalStateException("Invalid Response State. ByteBuffer cannot be null.");
        }
        if (socketChannel == null) {
            throw new IllegalStateException("Invalid Response State. SocketChannel cannot be null.");
        }
        SelectionKey key = null;
        Selector writeSelector = null;
        int attempts = 0;
        long totalBytes = 0L;
        for (int i = 0; i < bb.length; ++i) {
            totalBytes += (long)bb[i].remaining();
        }
        long nWrite = 0L;
        long len = -1L;
        try {
            while (nWrite < totalBytes) {
                len = socketChannel.write(bb);
                if (len > 0L) {
                    attempts = 0;
                    nWrite += len;
                    continue;
                }
                if (writeSelector == null && (writeSelector = SelectorFactory.getSelector()) == null) continue;
                key = socketChannel.register(writeSelector, 4);
                if (writeSelector.select(writeTimeout) != 0 || attempts <= 2) continue;
                throw new IOException("Client disconnected");
            }
        }
        catch (IOException ex) {
            len = -1L;
            throw ex;
        }
        finally {
            ConnectionCloseHandler cch;
            if (key != null) {
                key.cancel();
                key = null;
            }
            if (writeSelector != null) {
                SelectorFactory.selectNowAndReturnSelector(writeSelector);
            }
            if (len == -1L && Thread.currentThread() instanceof WorkerThread && (cch = (ConnectionCloseHandler)((WorkerThread)Thread.currentThread()).getAttachment().getAttribute("ConnectionCloseHandler")) != null) {
                cch.remotlyClosed(key);
            }
        }
        return nWrite;
    }

    public static long flushChannel(DatagramChannel datagramChannel, SocketAddress socketAddress, ByteBuffer bb) throws IOException {
        return OutputWriter.flushChannel(datagramChannel, socketAddress, bb, defaultWriteTimeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long flushChannel(DatagramChannel datagramChannel, SocketAddress socketAddress, ByteBuffer bb, long writeTimeout) throws IOException {
        if (bb == null) {
            throw new IllegalStateException("Invalid Response State. ByteBuffer cannot be null.");
        }
        if (datagramChannel == null) {
            throw new IllegalStateException("Invalid Response State. DatagramChannel cannot be null.");
        }
        if (socketAddress == null) {
            throw new IllegalStateException("Invalid Response State. SocketAddress cannot be null.");
        }
        SelectionKey key = null;
        Selector writeSelector = null;
        int attempts = 0;
        int nWrite = 0;
        try {
            while (bb.hasRemaining()) {
                int len = datagramChannel.send(bb, socketAddress);
                if (len > 0) {
                    attempts = 0;
                    nWrite += len;
                    continue;
                }
                if (writeSelector == null && (writeSelector = SelectorFactory.getSelector()) == null) continue;
                key = datagramChannel.register(writeSelector, 4);
                if (writeSelector.select(writeTimeout) == 0) {
                    if (attempts <= 2) continue;
                    throw new IOException("Client disconnected");
                }
                --attempts;
            }
        }
        finally {
            if (key != null) {
                key.cancel();
                key = null;
            }
            if (writeSelector != null) {
                SelectorFactory.selectNowAndReturnSelector(writeSelector);
            }
        }
        return nWrite;
    }

    public static int getDefaultWriteTimeout() {
        return defaultWriteTimeout;
    }

    public static void setDefaultWriteTimeout(int aDefaultWriteTimeout) {
        defaultWriteTimeout = aDefaultWriteTimeout;
    }
}

