/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.portunif;

import com.sun.grizzly.Context;
import com.sun.grizzly.Controller;
import com.sun.grizzly.SSLConfig;
import com.sun.grizzly.portunif.PUPreProcessor;
import com.sun.grizzly.portunif.PUProtocolRequest;
import com.sun.grizzly.util.SSLUtils;
import com.sun.grizzly.util.SelectionKeyAttachment;
import com.sun.grizzly.util.ThreadAttachment;
import com.sun.grizzly.util.WorkerThread;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;

public class TLSPUPreProcessor
implements PUPreProcessor {
    public static final String ID = "TLS";
    private static final String TMP_DECODED_BUFFER = "TMP_DECODED_BUFFER";
    private SSLContext sslContext;
    private boolean needClientAuth = false;
    private boolean wantClientAuth = false;
    private static Logger logger = Controller.logger();

    public TLSPUPreProcessor() {
    }

    public TLSPUPreProcessor(SSLConfig sslConfig) {
        this.configure(sslConfig);
    }

    public TLSPUPreProcessor(SSLContext sslContext) {
        this.sslContext = sslContext;
    }

    public String getId() {
        return ID;
    }

    public boolean process(Context context, PUProtocolRequest protocolRequest) throws IOException {
        if (this.sslContext == null) {
            if (logger.isLoggable(Level.WARNING)) {
                logger.log(Level.WARNING, "Grizzly Port unification warning. TLSPreProcessor will be skept. SSLContext in NULL!");
            }
            return false;
        }
        SelectionKey key = context.getSelectionKey();
        SelectableChannel channel = key.channel();
        SSLEngine sslEngine = null;
        Object attachment = SelectionKeyAttachment.getAttachment(key);
        boolean isloglevelfine = logger.isLoggable(Level.FINE);
        if (isloglevelfine) {
            logger.log(Level.FINE, "SelectionKeyAttachment: " + key);
        }
        if (attachment != null && attachment instanceof ThreadAttachment) {
            sslEngine = ((ThreadAttachment)attachment).getSSLEngine();
        }
        if (sslEngine == null) {
            sslEngine = this.sslContext.createSSLEngine();
            sslEngine.setUseClientMode(false);
            sslEngine.setNeedClientAuth(this.needClientAuth);
            sslEngine.setWantClientAuth(this.wantClientAuth);
        }
        if (isloglevelfine) {
            logger.log(Level.FINE, "sslEngine: " + sslEngine);
        }
        ByteBuffer inputBB = protocolRequest.getSecuredInputByteBuffer();
        ByteBuffer outputBB = protocolRequest.getSecuredOutputByteBuffer();
        ByteBuffer byteBuffer = protocolRequest.getByteBuffer();
        int securedBBSize = sslEngine.getSession().getPacketBufferSize();
        if (inputBB == null || inputBB != null && securedBBSize > inputBB.capacity()) {
            inputBB = ByteBuffer.allocate(securedBBSize * 2);
            protocolRequest.setSecuredInputByteBuffer(inputBB);
        }
        if (outputBB == null || outputBB != null && securedBBSize > outputBB.capacity()) {
            outputBB = ByteBuffer.allocate(securedBBSize * 2);
            protocolRequest.setSecuredOutputByteBuffer(outputBB);
        }
        int applicationBBSize = sslEngine.getSession().getApplicationBufferSize();
        if (byteBuffer == null || applicationBBSize > byteBuffer.capacity()) {
            ByteBuffer newBB = ByteBuffer.allocate(securedBBSize);
            byteBuffer.flip();
            newBB.put(byteBuffer);
            byteBuffer = newBB;
            protocolRequest.setByteBuffer(byteBuffer);
        }
        inputBB.clear();
        outputBB.position(0);
        outputBB.limit(0);
        inputBB.put((ByteBuffer)byteBuffer.flip());
        byteBuffer.clear();
        boolean OK = sslEngine.getSession().isValid();
        if (isloglevelfine) {
            logger.log(Level.FINE, "Is session valid: " + OK);
        }
        if (!OK) {
            SSLEngineResult.HandshakeStatus handshakeStatus = SSLEngineResult.HandshakeStatus.NEED_UNWRAP;
            try {
                byteBuffer = SSLUtils.doHandshake(channel, byteBuffer, inputBB, outputBB, sslEngine, handshakeStatus, SSLUtils.getReadTimeout(), inputBB.position() > 0);
                if (isloglevelfine) {
                    logger.log(Level.FINE, "handshake is done");
                }
                WorkerThread workerThread = (WorkerThread)Thread.currentThread();
                attachment = workerThread.updateAttachment(ThreadAttachment.Mode.SSL_ENGINE);
                key.attach(attachment);
                protocolRequest.setSSLEngine(sslEngine);
                outputBB.limit(outputBB.position());
                OK = true;
            }
            catch (EOFException ex) {
                if (isloglevelfine) {
                    logger.log(Level.FINE, "handshake failed", ex);
                }
            }
            catch (Exception ex) {
                if (isloglevelfine) {
                    logger.log(Level.FINE, "handshake failed", ex);
                }
                byteBuffer.put(inputBB);
            }
        } else {
            ByteBuffer tmpBuffer = (ByteBuffer)context.removeAttribute(TMP_DECODED_BUFFER);
            if (tmpBuffer != null) {
                byteBuffer.put(tmpBuffer);
            }
        }
        if (isloglevelfine) {
            logger.log(Level.FINE, "after handshake. isComplete: " + OK);
        }
        if (OK) {
            int byteRead = -1;
            if (isloglevelfine) {
                logger.log(Level.FINE, "secured bytebuffer: " + inputBB);
            }
            byteRead = inputBB.position() == 0 ? SSLUtils.doRead((SelectableChannel)channel, (ByteBuffer)inputBB, (SSLEngine)sslEngine, (int)SSLUtils.getReadTimeout()).bytesRead : inputBB.position();
            if (isloglevelfine) {
                logger.log(Level.FINE, "secured bytebuffer additional read: " + byteRead);
            }
            if (byteRead > -1) {
                byteBuffer = SSLUtils.unwrapAll(byteBuffer, inputBB, sslEngine);
                protocolRequest.setByteBuffer(byteBuffer);
            } else {
                throw new EOFException();
            }
        }
        return OK;
    }

    public void postProcess(Context context, PUProtocolRequest protocolRequest) {
        ByteBuffer srcBuffer = protocolRequest.getByteBuffer();
        srcBuffer.flip();
        if (srcBuffer.hasRemaining()) {
            ByteBuffer tmpBuffer = ByteBuffer.allocate(srcBuffer.remaining());
            tmpBuffer.put(srcBuffer);
            tmpBuffer.flip();
            context.setAttribute(TMP_DECODED_BUFFER, tmpBuffer);
        }
        ByteBuffer inputBB = protocolRequest.getSecuredInputByteBuffer();
        inputBB.flip();
        srcBuffer.clear();
        srcBuffer.put(inputBB);
        inputBB.clear();
    }

    public void setSSLContext(SSLContext sslContext) {
        this.sslContext = sslContext;
    }

    public void configure(SSLConfig sslConfig) {
        this.sslContext = sslConfig.createSSLContext();
        this.wantClientAuth = sslConfig.isWantClientAuth();
        this.needClientAuth = sslConfig.isNeedClientAuth();
    }

    public SSLContext getSSLContext() {
        return this.sslContext;
    }

    public boolean isNeedClientAuth() {
        return this.needClientAuth;
    }

    public void setNeedClientAuth(boolean needClientAuth) {
        this.needClientAuth = needClientAuth;
    }

    public boolean isWantClientAuth() {
        return this.wantClientAuth;
    }

    public void setWantClientAuth(boolean wantClientAuth) {
        this.wantClientAuth = wantClientAuth;
    }
}

