/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.messagesbus;

import com.sun.grizzly.comet.CometContext;
import com.sun.grizzly.comet.CometEvent;
import com.sun.grizzly.comet.CometHandler;
import com.sun.grizzly.messagesbus.MessagesBus;
import java.io.IOException;
import javax.servlet.http.HttpServletResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessagesBusCometHandler
implements CometHandler<HttpServletResponse> {
    private HttpServletResponse response;
    private CometContext cometContext;
    private MessagesBus.CometType cometType = MessagesBus.CometType.LONG_POLLING;

    protected MessagesBusCometHandler(CometContext cometContext) {
        this.cometContext = cometContext;
    }

    protected MessagesBusCometHandler(CometContext cometContext, MessagesBus.CometType cometType) {
        this.cometContext = cometContext;
        this.cometType = cometType;
    }

    @Override
    public void attach(HttpServletResponse response) {
        this.response = response;
    }

    @Override
    public void onEvent(CometEvent event) throws IOException {
        if (event.getType() == 1) {
            String output = (String)event.attachment();
            this.response.getWriter().println(output);
            this.response.getWriter().flush();
            if (this.cometType == MessagesBus.CometType.LONG_POLLING) {
                this.cometContext.resumeCometHandler(this);
            }
        }
    }

    @Override
    public void onInitialize(CometEvent event) throws IOException {
    }

    @Override
    public void onInterrupt(CometEvent event) throws IOException {
        this.removeThisFromContext();
    }

    @Override
    public void onTerminate(CometEvent event) throws IOException {
        this.removeThisFromContext();
    }

    private void removeThisFromContext() throws IOException {
        this.cometContext.removeCometHandler(this);
    }
}

