/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.filter;

import com.sun.grizzly.Context;
import com.sun.grizzly.Controller;
import com.sun.grizzly.ProtocolFilter;
import com.sun.grizzly.SSLConfig;
import com.sun.grizzly.util.InputReader;
import com.sun.grizzly.util.SSLUtils;
import com.sun.grizzly.util.ThreadAttachment;
import com.sun.grizzly.util.WorkerThread;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;

public class SSLReadFilter
implements ProtocolFilter {
    protected SSLContext sslContext;
    private String[] enabledCipherSuites = null;
    private String[] enabledProtocols = null;
    private boolean clientMode = false;
    private boolean needClientAuth = false;
    private boolean wantClientAuth = false;
    private boolean isProtocolConfigured = false;
    private boolean isCipherConfigured = false;
    protected int inputBBSize = 20480;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean execute(Context ctx) throws IOException {
        WorkerThread workerThread;
        Logger logger = Controller.logger();
        boolean result = true;
        int count = 0;
        Object var5_5 = null;
        SelectionKey key = ctx.getSelectionKey();
        try {
            workerThread = (WorkerThread)Thread.currentThread();
        }
        catch (ClassCastException ex) {
            throw new IllegalStateException(ex.getMessage());
        }
        SSLEngine sslEngine = workerThread.getSSLEngine();
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Thread associated sslEngine: " + sslEngine);
        }
        if (sslEngine == null) {
            sslEngine = this.obtainSSLEngine(key);
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Obtained sslEngine: " + sslEngine);
            }
            workerThread.setSSLEngine(sslEngine);
            ThreadAttachment attachment = workerThread.updateAttachment(ThreadAttachment.Mode.SSL_ENGINE);
            key.attach(attachment);
        }
        boolean hasHandshake = sslEngine.getSession().isValid();
        try {
            block17: {
                try {
                    SSLUtils.allocateThreadBuffers(this.inputBBSize);
                    if (hasHandshake) {
                        count = SSLReadFilter.doRead(key);
                        break block17;
                    }
                    if (SSLReadFilter.doHandshake(key, SSLUtils.getReadTimeout())) {
                        hasHandshake = true;
                        ByteBuffer outputBB = workerThread.getOutputBB();
                        outputBB.limit(outputBB.position());
                    } else {
                        count = -1;
                    }
                }
                catch (IOException ex) {
                    IOException iOException = ex;
                    SSLReadFilter.log("SSLReadFilter.execute", ex);
                    Object var12_18 = null;
                    if (iOException == null) {
                        if (count != -1) return result;
                    }
                    ctx.setAttribute("throwable", iOException);
                    ctx.setKeyRegistrationState(Context.KeyRegistrationState.CANCEL);
                    return false;
                }
                catch (Throwable ex) {
                    Throwable throwable = ex;
                    SSLReadFilter.log("SSLReadFilter.execute", ex);
                    Object var12_19 = null;
                    if (throwable == null) {
                        if (count != -1) return result;
                    }
                    ctx.setAttribute("throwable", throwable);
                    ctx.setKeyRegistrationState(Context.KeyRegistrationState.CANCEL);
                    return false;
                }
            }
            Object var12_17 = null;
            if (var5_5 == null) {
                if (count != -1) return result;
            }
        }
        catch (Throwable throwable) {
            Object var12_20 = null;
            if (var5_5 == null) {
                if (count != -1) throw throwable;
            }
            ctx.setAttribute("throwable", var5_5);
            ctx.setKeyRegistrationState(Context.KeyRegistrationState.CANCEL);
            result = false;
            throw throwable;
        }
        ctx.setAttribute("throwable", var5_5);
        ctx.setKeyRegistrationState(Context.KeyRegistrationState.CANCEL);
        return false;
    }

    public boolean postExecute(Context ctx) throws IOException {
        if (ctx.getKeyRegistrationState() == Context.KeyRegistrationState.CANCEL) {
            ctx.getSelectorHandler().getSelectionKeyHandler().cancel(ctx.getSelectionKey());
        } else if (ctx.getKeyRegistrationState() == Context.KeyRegistrationState.REGISTER) {
            this.saveSecuredBufferRemainders(ctx.getSelectionKey());
            ctx.getSelectorHandler().register(ctx.getSelectionKey(), 1);
            ctx.setKeyRegistrationState(Context.KeyRegistrationState.NONE);
        }
        return true;
    }

    private static boolean doHandshake(SelectionKey key, int timeout) throws IOException {
        WorkerThread workerThread = (WorkerThread)Thread.currentThread();
        ByteBuffer byteBuffer = workerThread.getByteBuffer();
        ByteBuffer outputBB = workerThread.getOutputBB();
        ByteBuffer inputBB = workerThread.getInputBB();
        SSLEngine sslEngine = workerThread.getSSLEngine();
        SSLEngineResult.HandshakeStatus handshakeStatus = SSLEngineResult.HandshakeStatus.NEED_UNWRAP;
        boolean OK = true;
        try {
            byteBuffer = SSLUtils.doHandshake((SocketChannel)key.channel(), byteBuffer, inputBB, outputBB, sslEngine, handshakeStatus, timeout);
            if (SSLReadFilter.doRead(key) == -1) {
                throw new EOFException();
            }
        }
        catch (IOException ex) {
            SSLReadFilter.log("doHandshake", ex);
            OK = false;
        }
        return OK;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static int doRead(SelectionKey key) {
        int n;
        int count;
        SSLEngine sslEngine;
        block15: {
            block13: {
                int n2;
                block14: {
                    WorkerThread workerThread = (WorkerThread)Thread.currentThread();
                    ByteBuffer byteBuffer = workerThread.getByteBuffer();
                    ByteBuffer outputBB = workerThread.getOutputBB();
                    ByteBuffer inputBB = workerThread.getInputBB();
                    sslEngine = workerThread.getSSLEngine();
                    count = -1;
                    int initialBufferPosition = byteBuffer.position();
                    try {
                        count = ((SocketChannel)key.channel()).read(inputBB);
                    }
                    catch (IOException e) {
                        SSLReadFilter.log("Exception during SSL read.", e);
                        count = -1;
                    }
                    if (count <= -1 && inputBB.position() <= 0) break block13;
                    Logger logger = Controller.logger();
                    if (logger.isLoggable(Level.FINE)) {
                        logger.log(Level.FINE, "SSLReadFilter. Read: " + count + " Calling unwrapAll. InputBB: " + inputBB + " byteBuffer: " + byteBuffer);
                    }
                    int initialInputBBPosition = inputBB.position();
                    byteBuffer = SSLUtils.unwrapAll(byteBuffer, inputBB, sslEngine);
                    workerThread.setInputBB(inputBB);
                    workerThread.setOutputBB(outputBB);
                    workerThread.setByteBuffer(byteBuffer);
                    if (count != -1 || byteBuffer.position() == initialBufferPosition) break block13;
                    n2 = initialInputBBPosition;
                    Object var12_15 = null;
                    if (count != -1) break block14;
                    try {
                        sslEngine.closeInbound();
                    }
                    catch (SSLException ex2) {
                        // empty catch block
                    }
                }
                return n2;
            }
            n = count;
            Object var12_16 = null;
            if (count != -1) break block15;
            try {
                sslEngine.closeInbound();
            }
            catch (SSLException ex2) {
                // empty catch block
            }
        }
        return n;
        catch (IOException ex) {
            int n3;
            block16: {
                try {
                    SSLReadFilter.log("Exception during SSL read.", ex);
                    n3 = -1;
                    Object var12_17 = null;
                    if (count != -1) break block16;
                }
                catch (Throwable throwable) {
                    block17: {
                        Object var12_18 = null;
                        if (count != -1) break block17;
                        try {
                            sslEngine.closeInbound();
                        }
                        catch (SSLException ex2) {}
                    }
                    throw throwable;
                }
                try {
                    sslEngine.closeInbound();
                }
                catch (SSLException ex2) {
                    // empty catch block
                }
            }
            return n3;
        }
    }

    public static Object[] doPeerCertificateChain(SelectionKey key, boolean needClientAuth) throws IOException {
        WorkerThread workerThread = (WorkerThread)Thread.currentThread();
        ByteBuffer byteBuffer = workerThread.getByteBuffer();
        ByteBuffer inputBB = workerThread.getInputBB();
        ByteBuffer outputBB = workerThread.getOutputBB();
        SSLEngine sslEngine = workerThread.getSSLEngine();
        return SSLUtils.doPeerCertificateChain((SocketChannel)key.channel(), byteBuffer, inputBB, outputBB, sslEngine, needClientAuth, InputReader.getDefaultReadTimeout());
    }

    protected SSLEngine newSSLEngine() {
        Logger logger = Controller.logger();
        SSLEngine sslEngine = this.sslContext.createSSLEngine();
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "newSSLEngine: " + sslEngine);
        }
        if (this.enabledCipherSuites != null) {
            if (!this.isCipherConfigured) {
                this.enabledCipherSuites = SSLReadFilter.configureEnabledCiphers(sslEngine, this.enabledCipherSuites);
                this.isCipherConfigured = true;
            }
            sslEngine.setEnabledCipherSuites(this.enabledCipherSuites);
        }
        if (this.enabledProtocols != null) {
            if (!this.isProtocolConfigured) {
                this.enabledProtocols = SSLReadFilter.configureEnabledProtocols(sslEngine, this.enabledProtocols);
                this.isProtocolConfigured = true;
            }
            sslEngine.setEnabledProtocols(this.enabledProtocols);
        }
        sslEngine.setUseClientMode(this.clientMode);
        return sslEngine;
    }

    protected SSLEngine obtainSSLEngine(SelectionKey key) {
        Logger logger = Controller.logger();
        SSLEngine sslEngine = null;
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Obtaining sslEngine. Key attachment: " + key.attachment());
        }
        if (key.attachment() instanceof ThreadAttachment) {
            sslEngine = ((WorkerThread)Thread.currentThread()).getSSLEngine();
        }
        if (sslEngine == null) {
            sslEngine = this.newSSLEngine();
        }
        sslEngine.setWantClientAuth(this.wantClientAuth);
        sslEngine.setNeedClientAuth(this.needClientAuth);
        return sslEngine;
    }

    public void configure(SSLConfig sslConfig) {
        this.sslContext = sslConfig.createSSLContext();
        this.wantClientAuth = sslConfig.isWantClientAuth();
        this.needClientAuth = sslConfig.isNeedClientAuth();
        this.clientMode = sslConfig.isClientMode();
    }

    public void setSSLContext(SSLContext sslContext) {
        this.sslContext = sslContext;
    }

    public SSLContext getSSLContext() {
        return this.sslContext;
    }

    public String[] getEnabledCipherSuites() {
        return this.enabledCipherSuites;
    }

    public void setEnabledCipherSuites(String[] enabledCipherSuites) {
        this.enabledCipherSuites = enabledCipherSuites;
    }

    public String[] getEnabledProtocols() {
        return this.enabledProtocols;
    }

    public void setEnabledProtocols(String[] enabledProtocols) {
        this.enabledProtocols = enabledProtocols;
    }

    public boolean isClientMode() {
        return this.clientMode;
    }

    public void setClientMode(boolean clientMode) {
        this.clientMode = clientMode;
    }

    public boolean isNeedClientAuth() {
        return this.needClientAuth;
    }

    public void setNeedClientAuth(boolean needClientAuth) {
        this.needClientAuth = needClientAuth;
    }

    public boolean isWantClientAuth() {
        return this.wantClientAuth;
    }

    public void setWantClientAuth(boolean wantClientAuth) {
        this.wantClientAuth = wantClientAuth;
    }

    private static final String[] configureEnabledProtocols(SSLEngine sslEngine, String[] requestedProtocols) {
        String[] supportedProtocols = sslEngine.getSupportedProtocols();
        String[] protocols = null;
        ArrayList<String> list = null;
        block0: for (String supportedProtocol : supportedProtocols) {
            for (String protocol : requestedProtocols) {
                if (!supportedProtocol.equals(protocol = protocol.trim())) continue;
                if (list == null) {
                    list = new ArrayList<String>();
                }
                list.add(protocol);
                continue block0;
            }
        }
        if (list != null) {
            protocols = list.toArray(new String[list.size()]);
        }
        return protocols;
    }

    private static final String[] configureEnabledCiphers(SSLEngine sslEngine, String[] requestedCiphers) {
        String[] supportedCiphers = sslEngine.getSupportedCipherSuites();
        String[] ciphers = null;
        ArrayList<String> list = null;
        block0: for (String supportedCipher : supportedCiphers) {
            for (String cipher : requestedCiphers) {
                if (!supportedCipher.equals(cipher = cipher.trim())) continue;
                if (list == null) {
                    list = new ArrayList<String>();
                }
                list.add(cipher);
                continue block0;
            }
        }
        if (list != null) {
            ciphers = list.toArray(new String[list.size()]);
        }
        return ciphers;
    }

    private void saveSecuredBufferRemainders(SelectionKey selectionKey) {
        ByteBuffer inputBB;
        Logger logger = Controller.logger();
        ThreadAttachment attachment = (ThreadAttachment)selectionKey.attachment();
        WorkerThread workerThread = (WorkerThread)Thread.currentThread();
        if (attachment == null || workerThread.getAttachment() != attachment) {
            logger.log(Level.FINE, "SelectionKey ThreadAttachment is NULL or doesn't correspond to the current thread, when saving buffers");
            return;
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "saveSecuredBufferRemainders inputBB: " + workerThread.getInputBB() + " outputBB: " + workerThread.getOutputBB() + " attach: " + attachment);
        }
        if ((inputBB = workerThread.getInputBB()) != null && inputBB.position() > 0) {
            workerThread.updateAttachment(attachment.getMode() | ThreadAttachment.Mode.INPUT_BB);
        } else {
            workerThread.updateAttachment(attachment.getMode() & (Integer.MAX_VALUE ^ ThreadAttachment.Mode.INPUT_BB));
        }
        ByteBuffer outputBB = workerThread.getOutputBB();
        if (outputBB != null && outputBB.hasRemaining()) {
            workerThread.updateAttachment(attachment.getMode() | ThreadAttachment.Mode.OUTPUT_BB);
        } else {
            workerThread.updateAttachment(attachment.getMode() & (Integer.MAX_VALUE ^ ThreadAttachment.Mode.OUTPUT_BB));
        }
    }

    protected static void log(String msg, Throwable t) {
        if (Controller.logger().isLoggable(Level.FINE)) {
            Controller.logger().log(Level.FINE, msg, t);
        }
    }
}

