/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.comet;

import com.sun.grizzly.Controller;
import com.sun.grizzly.NIOContext;
import com.sun.grizzly.ProtocolChain;
import com.sun.grizzly.arp.AsyncProcessorTask;
import com.sun.grizzly.comet.CometContext;
import com.sun.grizzly.comet.CometEngine;
import com.sun.grizzly.comet.CometEvent;
import com.sun.grizzly.comet.CometHandler;
import com.sun.grizzly.comet.CometReader;
import com.sun.grizzly.comet.CometWriter;
import com.sun.grizzly.http.SelectorThread;
import com.sun.grizzly.util.SelectedKeyAttachmentLogic;
import com.sun.grizzly.util.WorkerThread;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CometTask
extends SelectedKeyAttachmentLogic
implements Runnable {
    private static final Logger logger = SelectorThread.logger();
    protected final CometContext cometContext;
    protected final CometHandler cometHandler;
    protected AsyncProcessorTask asyncProcessorTask;
    protected volatile boolean cometHandlerIsAsyncRegistered;
    protected boolean upcoming_op_isread;
    protected boolean callInterrupt;

    public CometTask() {
        this(null, null);
    }

    public CometTask(CometContext cometContext, CometHandler cometHandler) {
        this.cometContext = cometContext;
        this.cometHandler = cometHandler;
    }

    public void run() {
        if (this.callInterrupt) {
            CometEngine.getEngine().interrupt0(this, true);
        } else {
            try {
                this.doTask();
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    public long getIdleTimeoutDelay() {
        return this.cometContext.getExpirationDelay();
    }

    public void release(SelectionKey selectionKey) {
    }

    public boolean timedOut(SelectionKey key) {
        CometEngine.getEngine().interrupt(this, true);
        return false;
    }

    public void handleSelectedKey(SelectionKey selectionKey) {
        if (!selectionKey.isValid()) {
            CometEngine.getEngine().interrupt(this, true);
            return;
        }
        if (this.cometHandlerIsAsyncRegistered) {
            if (selectionKey.isReadable()) {
                selectionKey.interestOps(selectionKey.interestOps() & 0xFFFFFFFE);
                this.upcoming_op_isread = true;
            }
            if (selectionKey.isWritable()) {
                selectionKey.interestOps(selectionKey.interestOps() & 0xFFFFFFFB);
                this.upcoming_op_isread = false;
            }
            this.asyncProcessorTask.getThreadPool().execute(this);
        } else {
            this.checkIfClientClosedConnection(selectionKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkIfClientClosedConnection(SelectionKey mainKey) {
        boolean connectionclosed = true;
        try {
            connectionclosed = ((SocketChannel)mainKey.channel()).read(ByteBuffer.allocate(1)) == -1;
        }
        catch (IOException iOException) {
        }
        finally {
            if (connectionclosed) {
                CometEngine.getEngine().interrupt(this, true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doTask() throws IOException {
        block22: {
            if (!this.cometContext.isActive(this.cometHandler)) {
                return;
            }
            ByteBuffer byteBuffer = null;
            boolean connectionClosed = false;
            boolean clearBuffer = true;
            SelectionKey key = this.getSelectionKey();
            try {
                byteBuffer = ((WorkerThread)Thread.currentThread()).getByteBuffer();
                if (byteBuffer == null) {
                    byteBuffer = ByteBuffer.allocate(this.asyncProcessorTask.getSelectorThread().getBufferSize());
                    ((WorkerThread)Thread.currentThread()).setByteBuffer(byteBuffer);
                } else {
                    byteBuffer.clear();
                }
                SocketChannel socketChannel = (SocketChannel)key.channel();
                if (this.upcoming_op_isread) {
                    int nRead = socketChannel.read(byteBuffer);
                    if (nRead == -1) {
                        connectionClosed = true;
                        break block22;
                    }
                    if (!this.cometHandlerIsAsyncRegistered) {
                        if (!this.cometContext.isActive(this.cometHandler)) {
                            return;
                        }
                        nRead = socketChannel.read(byteBuffer);
                        if (nRead == -1) {
                            connectionClosed = true;
                            return;
                        }
                        try {
                            this.cometHandler.onInterrupt(this.cometContext.eventInterrupt);
                        }
                        catch (IOException e) {
                            // empty catch block
                        }
                        CometEngine.cometEngine.flushPostExecute(this, false);
                        clearBuffer = false;
                        Controller controller = this.getSelectorThread().getController();
                        ProtocolChain protocolChain = controller.getProtocolChainInstanceHandler().poll();
                        NIOContext ctx = controller.pollContext();
                        ctx.setController(controller);
                        ctx.setSelectionKey(key);
                        ctx.setProtocolChain(protocolChain);
                        ctx.setProtocol(Controller.Protocol.TCP);
                        protocolChain.execute(ctx);
                        break block22;
                    }
                    byteBuffer.flip();
                    CometReader reader = new CometReader();
                    reader.setNRead(nRead);
                    reader.setByteBuffer(byteBuffer);
                    CometEvent<CometReader> event = new CometEvent<CometReader>(4, this.cometContext);
                    event.attach(reader);
                    this.cometContext.invokeCometHandler(event, this.cometHandler);
                    reader.setByteBuffer(null);
                    reader.setReady(false);
                    break block22;
                }
                CometEvent<CometWriter> event = new CometEvent<CometWriter>(5, this.cometContext);
                CometWriter writer = new CometWriter();
                writer.setChannel(socketChannel);
                event.attach(writer);
                this.cometContext.invokeCometHandler(event, this.cometHandler);
                writer.setReady(false);
            }
            catch (IOException ex) {
                connectionClosed = true;
                if (SelectorThread.logger().isLoggable(Level.FINEST)) {
                    SelectorThread.logger().log(Level.FINEST, "Comet exception", ex);
                }
            }
            catch (Throwable t) {
                connectionClosed = true;
                SelectorThread.logger().log(Level.SEVERE, "Comet exception", t);
            }
            finally {
                this.cometHandlerIsAsyncRegistered = false;
                if (connectionClosed) {
                    this.asyncProcessorTask.getSelectorThread().cancelKey(key);
                }
                if (clearBuffer && byteBuffer != null) {
                    byteBuffer.clear();
                }
            }
        }
    }

    public void setComethandlerIsAsyncRegistered(boolean cometHandlerIsAsyncRegistered) {
        this.cometHandlerIsAsyncRegistered = cometHandlerIsAsyncRegistered;
    }

    public boolean isComethandlerAsyncRegistered() {
        return this.cometHandlerIsAsyncRegistered;
    }

    public CometContext getCometContext() {
        return this.cometContext;
    }

    public AsyncProcessorTask getAsyncProcessorTask() {
        return this.asyncProcessorTask;
    }

    public void setAsyncProcessorTask(AsyncProcessorTask asyncProcessorTask) {
        this.asyncProcessorTask = asyncProcessorTask;
    }

    public SelectionKey getSelectionKey() {
        return this.asyncProcessorTask.getAsyncExecutor().getProcessorTask().getSelectionKey();
    }

    private SelectorThread getSelectorThread() {
        return this.asyncProcessorTask.getSelectorThread();
    }

    public CometHandler getCometHandler() {
        return this.cometHandler;
    }
}

