/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.handler.codec.spdy;

import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.handler.codec.spdy.SpdyProtocolException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class SpdySession {
    private static final SpdyProtocolException STREAM_CLOSED = new SpdyProtocolException("Stream closed");
    private final Map<Integer, StreamState> activeStreams = new ConcurrentHashMap<Integer, StreamState>();

    SpdySession() {
    }

    public int numActiveStreams() {
        return this.activeStreams.size();
    }

    public boolean noActiveStreams() {
        return this.activeStreams.isEmpty();
    }

    public boolean isActiveStream(int streamID) {
        return this.activeStreams.containsKey(new Integer(streamID));
    }

    public Set<Integer> getActiveStreams() {
        TreeSet<Integer> StreamIDs = new TreeSet<Integer>(new PriorityComparator());
        StreamIDs.addAll(this.activeStreams.keySet());
        return StreamIDs;
    }

    public void acceptStream(int streamID, byte priority, boolean remoteSideClosed, boolean localSideClosed, int sendWindowSize, int receiveWindowSize) {
        if (!remoteSideClosed || !localSideClosed) {
            this.activeStreams.put(new Integer(streamID), new StreamState(priority, remoteSideClosed, localSideClosed, sendWindowSize, receiveWindowSize));
        }
    }

    public void removeStream(int streamID) {
        Integer StreamID = new Integer(streamID);
        StreamState state = this.activeStreams.get(StreamID);
        this.activeStreams.remove(StreamID);
        if (state != null) {
            MessageEvent e = state.removePendingWrite();
            while (e != null) {
                e.getFuture().setFailure(STREAM_CLOSED);
                e = state.removePendingWrite();
            }
        }
    }

    public boolean isRemoteSideClosed(int streamID) {
        StreamState state = this.activeStreams.get(new Integer(streamID));
        return state == null || state.isRemoteSideClosed();
    }

    public void closeRemoteSide(int streamID) {
        Integer StreamID = new Integer(streamID);
        StreamState state = this.activeStreams.get(StreamID);
        if (state != null) {
            state.closeRemoteSide();
            if (state.isLocalSideClosed()) {
                this.activeStreams.remove(StreamID);
            }
        }
    }

    public boolean isLocalSideClosed(int streamID) {
        StreamState state = this.activeStreams.get(new Integer(streamID));
        return state == null || state.isLocalSideClosed();
    }

    public void closeLocalSide(int streamID) {
        Integer StreamID = new Integer(streamID);
        StreamState state = this.activeStreams.get(StreamID);
        if (state != null) {
            state.closeLocalSide();
            if (state.isRemoteSideClosed()) {
                this.activeStreams.remove(StreamID);
            }
        }
    }

    public boolean hasReceivedReply(int streamID) {
        StreamState state = this.activeStreams.get(new Integer(streamID));
        return state != null && state.hasReceivedReply();
    }

    public void receivedReply(int streamID) {
        StreamState state = this.activeStreams.get(new Integer(streamID));
        if (state != null) {
            state.receivedReply();
        }
    }

    public int getSendWindowSize(int streamID) {
        StreamState state = this.activeStreams.get(new Integer(streamID));
        return state != null ? state.getSendWindowSize() : -1;
    }

    public int updateSendWindowSize(int streamID, int deltaWindowSize) {
        StreamState state = this.activeStreams.get(new Integer(streamID));
        return state != null ? state.updateSendWindowSize(deltaWindowSize) : -1;
    }

    public int updateReceiveWindowSize(int streamID, int deltaWindowSize) {
        StreamState state = this.activeStreams.get(new Integer(streamID));
        if (deltaWindowSize > 0) {
            state.setReceiveWindowSizeLowerBound(0);
        }
        return state != null ? state.updateReceiveWindowSize(deltaWindowSize) : -1;
    }

    public int getReceiveWindowSizeLowerBound(int streamID) {
        StreamState state = this.activeStreams.get(new Integer(streamID));
        return state != null ? state.getReceiveWindowSizeLowerBound() : 0;
    }

    public void updateAllReceiveWindowSizes(int deltaWindowSize) {
        for (StreamState state : this.activeStreams.values()) {
            state.updateReceiveWindowSize(deltaWindowSize);
            if (deltaWindowSize >= 0) continue;
            state.setReceiveWindowSizeLowerBound(deltaWindowSize);
        }
    }

    public boolean putPendingWrite(int streamID, MessageEvent evt) {
        StreamState state = this.activeStreams.get(new Integer(streamID));
        return state != null && state.putPendingWrite(evt);
    }

    public MessageEvent getPendingWrite(int streamID) {
        StreamState state = this.activeStreams.get(new Integer(streamID));
        return state != null ? state.getPendingWrite() : null;
    }

    public MessageEvent removePendingWrite(int streamID) {
        StreamState state = this.activeStreams.get(new Integer(streamID));
        return state != null ? state.removePendingWrite() : null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class PriorityComparator
    implements Comparator<Integer> {
        @Override
        public int compare(Integer id1, Integer id2) {
            StreamState state1 = (StreamState)SpdySession.this.activeStreams.get(id1);
            StreamState state2 = (StreamState)SpdySession.this.activeStreams.get(id2);
            return state1.getPriority() - state2.getPriority();
        }
    }

    private static final class StreamState {
        private final byte priority;
        private volatile boolean remoteSideClosed;
        private volatile boolean localSideClosed;
        private boolean receivedReply;
        private final AtomicInteger sendWindowSize;
        private final AtomicInteger receiveWindowSize;
        private volatile int receiveWindowSizeLowerBound;
        private final ConcurrentLinkedQueue<MessageEvent> pendingWriteQueue = new ConcurrentLinkedQueue();

        public StreamState(byte priority, boolean remoteSideClosed, boolean localSideClosed, int sendWindowSize, int receiveWindowSize) {
            this.priority = priority;
            this.remoteSideClosed = remoteSideClosed;
            this.localSideClosed = localSideClosed;
            this.sendWindowSize = new AtomicInteger(sendWindowSize);
            this.receiveWindowSize = new AtomicInteger(receiveWindowSize);
        }

        public byte getPriority() {
            return this.priority;
        }

        public boolean isRemoteSideClosed() {
            return this.remoteSideClosed;
        }

        public void closeRemoteSide() {
            this.remoteSideClosed = true;
        }

        public boolean isLocalSideClosed() {
            return this.localSideClosed;
        }

        public void closeLocalSide() {
            this.localSideClosed = true;
        }

        public boolean hasReceivedReply() {
            return this.receivedReply;
        }

        public void receivedReply() {
            this.receivedReply = true;
        }

        public int getSendWindowSize() {
            return this.sendWindowSize.get();
        }

        public int updateSendWindowSize(int deltaWindowSize) {
            return this.sendWindowSize.addAndGet(deltaWindowSize);
        }

        public int updateReceiveWindowSize(int deltaWindowSize) {
            return this.receiveWindowSize.addAndGet(deltaWindowSize);
        }

        public int getReceiveWindowSizeLowerBound() {
            return this.receiveWindowSizeLowerBound;
        }

        public void setReceiveWindowSizeLowerBound(int receiveWindowSizeLowerBound) {
            this.receiveWindowSizeLowerBound = receiveWindowSizeLowerBound;
        }

        public boolean putPendingWrite(MessageEvent evt) {
            return this.pendingWriteQueue.offer(evt);
        }

        public MessageEvent getPendingWrite() {
            return this.pendingWriteQueue.peek();
        }

        public MessageEvent removePendingWrite() {
            return this.pendingWriteQueue.poll();
        }
    }
}

