/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.handler.codec.spdy;

import org.jboss.netty.handler.codec.spdy.DefaultSpdyHeaderBlock;
import org.jboss.netty.handler.codec.spdy.SpdySynStreamFrame;
import org.jboss.netty.util.internal.StringUtil;

public class DefaultSpdySynStreamFrame
extends DefaultSpdyHeaderBlock
implements SpdySynStreamFrame {
    private int streamID;
    private int associatedToStreamID;
    private byte priority;
    private boolean last;
    private boolean unidirectional;

    public DefaultSpdySynStreamFrame(int streamID, int associatedToStreamID, byte priority) {
        this.setStreamID(streamID);
        this.setAssociatedToStreamID(associatedToStreamID);
        this.setPriority(priority);
    }

    public int getStreamID() {
        return this.streamID;
    }

    public void setStreamID(int streamID) {
        if (streamID <= 0) {
            throw new IllegalArgumentException("Stream-ID must be positive: " + streamID);
        }
        this.streamID = streamID;
    }

    public int getAssociatedToStreamID() {
        return this.associatedToStreamID;
    }

    public void setAssociatedToStreamID(int associatedToStreamID) {
        if (associatedToStreamID < 0) {
            throw new IllegalArgumentException("Associated-To-Stream-ID cannot be negative: " + associatedToStreamID);
        }
        this.associatedToStreamID = associatedToStreamID;
    }

    public byte getPriority() {
        return this.priority;
    }

    public void setPriority(byte priority) {
        if (priority < 0 || priority > 7) {
            throw new IllegalArgumentException("Priority must be between 0 and 7 inclusive: " + priority);
        }
        this.priority = priority;
    }

    public boolean isLast() {
        return this.last;
    }

    public void setLast(boolean last) {
        this.last = last;
    }

    public boolean isUnidirectional() {
        return this.unidirectional;
    }

    public void setUnidirectional(boolean unidirectional) {
        this.unidirectional = unidirectional;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.getClass().getSimpleName());
        buf.append("(last: ");
        buf.append(this.isLast());
        buf.append("; unidirectional: ");
        buf.append(this.isUnidirectional());
        buf.append(')');
        buf.append(StringUtil.NEWLINE);
        buf.append("--> Stream-ID = ");
        buf.append(this.streamID);
        buf.append(StringUtil.NEWLINE);
        if (this.associatedToStreamID != 0) {
            buf.append("--> Associated-To-Stream-ID = ");
            buf.append(this.associatedToStreamID);
            buf.append(StringUtil.NEWLINE);
        }
        buf.append("--> Priority = ");
        buf.append(this.priority);
        buf.append(StringUtil.NEWLINE);
        buf.append("--> Headers:");
        buf.append(StringUtil.NEWLINE);
        this.appendHeaders(buf);
        buf.setLength(buf.length() - StringUtil.NEWLINE.length());
        return buf.toString();
    }
}

