/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.handler.codec.replay;

import java.net.SocketAddress;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.handler.codec.frame.FrameDecoder;
import org.jboss.netty.handler.codec.replay.ReplayError;
import org.jboss.netty.handler.codec.replay.ReplayingDecoderBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ReplayingDecoder<T extends Enum<T>>
extends FrameDecoder {
    private ReplayingDecoderBuffer replayable;
    private T state;
    private int checkpoint;
    private boolean needsCleanup;

    protected ReplayingDecoder() {
        this(null);
    }

    protected ReplayingDecoder(boolean unfold) {
        this(null, unfold);
    }

    protected ReplayingDecoder(T initialState) {
        this(initialState, false);
    }

    protected ReplayingDecoder(T initialState, boolean unfold) {
        super(unfold);
        this.state = initialState;
    }

    protected void checkpoint() {
        ChannelBuffer cumulation = this.cumulation;
        this.checkpoint = cumulation != null ? cumulation.readerIndex() : -1;
    }

    protected void checkpoint(T state) {
        this.checkpoint();
        this.setState(state);
    }

    protected T getState() {
        return this.state;
    }

    protected T setState(T newState) {
        T oldState = this.state;
        this.state = newState;
        return oldState;
    }

    protected abstract Object decode(ChannelHandlerContext var1, Channel var2, ChannelBuffer var3, T var4) throws Exception;

    protected Object decodeLast(ChannelHandlerContext ctx, Channel channel, ChannelBuffer buffer, T state) throws Exception {
        return this.decode(ctx, channel, buffer, state);
    }

    @Override
    protected final Object decode(ChannelHandlerContext ctx, Channel channel, ChannelBuffer buffer) throws Exception {
        return this.decode(ctx, channel, buffer, this.state);
    }

    @Override
    protected final Object decodeLast(ChannelHandlerContext ctx, Channel channel, ChannelBuffer buffer) throws Exception {
        return this.decodeLast(ctx, channel, buffer, this.state);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        ChannelBuffer buf;
        ChannelBuffer input;
        block23: {
            block21: {
                ChannelBuffer cumulation2;
                block24: {
                    int inputSize;
                    int oldReaderIndex;
                    block22: {
                        int bytesToPreserve2;
                        Object m = e.getMessage();
                        if (!(m instanceof ChannelBuffer)) {
                            ctx.sendUpstream(e);
                            return;
                        }
                        input = (ChannelBuffer)m;
                        if (!input.readable()) {
                            return;
                        }
                        this.needsCleanup = true;
                        if (this.cumulation != null) break block23;
                        this.cumulation = input;
                        this.replayable = new ReplayingDecoderBuffer(input);
                        oldReaderIndex = input.readerIndex();
                        inputSize = input.readableBytes();
                        try {
                            this.callDecode(ctx, e.getChannel(), input, this.replayable, e.getRemoteAddress());
                            Object var8_9 = null;
                            if (!input.readable()) break block21;
                            if (this.checkpoint <= 0) break block22;
                            bytesToPreserve2 = inputSize - (this.checkpoint - oldReaderIndex);
                        }
                        catch (Throwable throwable) {
                            ChannelBuffer cumulation2;
                            Object var8_10 = null;
                            if (!input.readable()) {
                                this.cumulation = null;
                                this.replayable = ReplayingDecoderBuffer.EMPTY_BUFFER;
                                throw throwable;
                            }
                            if (this.checkpoint > 0) {
                                int bytesToPreserve2 = inputSize - (this.checkpoint - oldReaderIndex);
                                cumulation2 = this.cumulation = this.newCumulationBuffer(ctx, bytesToPreserve2);
                                cumulation2.writeBytes(input, this.checkpoint, bytesToPreserve2);
                            } else if (this.checkpoint == 0) {
                                cumulation2 = this.cumulation = this.newCumulationBuffer(ctx, inputSize);
                                cumulation2.writeBytes(input, oldReaderIndex, inputSize);
                                cumulation2.readerIndex(input.readerIndex());
                            } else {
                                cumulation2 = this.cumulation = this.newCumulationBuffer(ctx, input.readableBytes());
                                cumulation2.writeBytes(input);
                            }
                            this.replayable = new ReplayingDecoderBuffer(cumulation2);
                            throw throwable;
                        }
                        cumulation2 = this.cumulation = this.newCumulationBuffer(ctx, bytesToPreserve2);
                        cumulation2.writeBytes(input, this.checkpoint, bytesToPreserve2);
                        break block24;
                    }
                    if (this.checkpoint == 0) {
                        cumulation2 = this.cumulation = this.newCumulationBuffer(ctx, inputSize);
                        cumulation2.writeBytes(input, oldReaderIndex, inputSize);
                        cumulation2.readerIndex(input.readerIndex());
                    } else {
                        cumulation2 = this.cumulation = this.newCumulationBuffer(ctx, input.readableBytes());
                        cumulation2.writeBytes(input);
                    }
                }
                this.replayable = new ReplayingDecoderBuffer(cumulation2);
                return;
            }
            this.cumulation = null;
            this.replayable = ReplayingDecoderBuffer.EMPTY_BUFFER;
            return;
        }
        assert (this.cumulation.readable());
        boolean fit = false;
        int readable = input.readableBytes();
        int writable = this.cumulation.writableBytes();
        int w = writable - readable;
        if (w < 0) {
            int readerIndex = this.cumulation.readerIndex();
            if (w + readerIndex >= 0) {
                this.cumulation.discardReadBytes();
                fit = true;
            }
        } else {
            fit = true;
        }
        if (fit) {
            buf = this.cumulation;
            buf.writeBytes(input);
        } else {
            this.cumulation = buf = ChannelBuffers.wrappedBuffer(this.cumulation, input);
            this.replayable = new ReplayingDecoderBuffer(this.cumulation);
        }
        try {
            this.callDecode(ctx, e.getChannel(), buf, this.replayable, e.getRemoteAddress());
            Object var12_20 = null;
            if (!buf.readable()) {
                this.cumulation = null;
                this.replayable = ReplayingDecoderBuffer.EMPTY_BUFFER;
                return;
            }
        }
        catch (Throwable throwable) {
            Object var12_21 = null;
            if (!buf.readable()) {
                this.cumulation = null;
                this.replayable = ReplayingDecoderBuffer.EMPTY_BUFFER;
                throw throwable;
            }
            this.cumulation = this.newCumulationBuffer(ctx, buf.readableBytes());
            this.cumulation.writeBytes(buf);
            this.replayable = new ReplayingDecoderBuffer(this.cumulation);
            throw throwable;
        }
        this.cumulation = this.newCumulationBuffer(ctx, buf.readableBytes());
        this.cumulation.writeBytes(buf);
        this.replayable = new ReplayingDecoderBuffer(this.cumulation);
    }

    private void callDecode(ChannelHandlerContext context, Channel channel, ChannelBuffer input, ChannelBuffer replayableInput, SocketAddress remoteAddress) throws Exception {
        while (input.readable()) {
            T oldState;
            Object result;
            int oldReaderIndex;
            block5: {
                oldReaderIndex = this.checkpoint = input.readerIndex();
                result = null;
                oldState = this.state;
                try {
                    result = this.decode(context, channel, replayableInput, this.state);
                    if (result == null) {
                        if (oldReaderIndex != input.readerIndex() || oldState != this.state) continue;
                        throw new IllegalStateException("null cannot be returned if no data is consumed and state didn't change.");
                    }
                }
                catch (ReplayError replay) {
                    int checkpoint = this.checkpoint;
                    if (checkpoint < 0) break block5;
                    input.readerIndex(checkpoint);
                }
            }
            if (result == null) break;
            if (oldReaderIndex == input.readerIndex() && oldState == this.state) {
                throw new IllegalStateException("decode() method must consume at least one byte if it returned a decoded message (caused by: " + this.getClass() + ")");
            }
            this.unfoldAndFireMessageReceived(context, remoteAddress, result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void cleanup(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        try {
            try {
                Object partiallyDecoded;
                ChannelBuffer cumulation = this.cumulation;
                if (!this.needsCleanup) {
                    Object var6_5 = null;
                    this.replayable = ReplayingDecoderBuffer.EMPTY_BUFFER;
                    ctx.sendUpstream(e);
                    return;
                }
                this.needsCleanup = false;
                this.cumulation = null;
                this.replayable.terminate();
                if (cumulation != null && cumulation.readable()) {
                    this.callDecode(ctx, e.getChannel(), cumulation, this.replayable, null);
                }
                if ((partiallyDecoded = this.decodeLast(ctx, e.getChannel(), this.replayable, this.state)) != null) {
                    this.unfoldAndFireMessageReceived(ctx, null, partiallyDecoded);
                }
            }
            catch (ReplayError replayError) {
                Object var6_7 = null;
                this.replayable = ReplayingDecoderBuffer.EMPTY_BUFFER;
                ctx.sendUpstream(e);
                return;
            }
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            this.replayable = ReplayingDecoderBuffer.EMPTY_BUFFER;
            ctx.sendUpstream(e);
            throw throwable;
        }
        Object var6_6 = null;
        this.replayable = ReplayingDecoderBuffer.EMPTY_BUFFER;
        ctx.sendUpstream(e);
    }
}

