/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.xmlrpc.converter.space;

import it.grid.storm.griduser.GridUserInterface;
import it.grid.storm.griduser.GridUserManager;
import it.grid.storm.srm.types.ArrayOfTMetaDataSpace;
import it.grid.storm.srm.types.ArrayOfTSpaceToken;
import it.grid.storm.srm.types.InvalidArrayOfTSpaceTokenAttributeException;
import it.grid.storm.srm.types.TReturnStatus;
import it.grid.storm.synchcall.data.InputData;
import it.grid.storm.synchcall.data.OutputData;
import it.grid.storm.synchcall.data.space.AnonymousGetSpaceMetaDataInputData;
import it.grid.storm.synchcall.data.space.GetSpaceMetaDataOutputData;
import it.grid.storm.synchcall.data.space.IdentityGetSpaceMetaDataInputData;
import it.grid.storm.xmlrpc.converter.Converter;
import java.util.Hashtable;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetSpaceMetaDataConverter
implements Converter {
    private static final Logger log = LoggerFactory.getLogger(GetSpaceMetaDataConverter.class);

    public InputData convertToInputData(Map inputParam) {
        ArrayOfTSpaceToken arrayOfSpaceTokens;
        Object memberName = null;
        GridUserInterface guser = GridUserManager.decode(inputParam);
        String authID = (String)inputParam.get("authorizationID");
        try {
            arrayOfSpaceTokens = ArrayOfTSpaceToken.decode(inputParam, "arrayOfSpaceTokens");
        }
        catch (InvalidArrayOfTSpaceTokenAttributeException e) {
            arrayOfSpaceTokens = null;
        }
        AnonymousGetSpaceMetaDataInputData inputData = guser != null ? new IdentityGetSpaceMetaDataInputData(guser, arrayOfSpaceTokens) : new AnonymousGetSpaceMetaDataInputData(arrayOfSpaceTokens);
        return inputData;
    }

    public Map convertFromOutputData(OutputData data) {
        ArrayOfTMetaDataSpace arrayOfSpaceDetails;
        log.debug("GetSpaceMetaDataConverter: Creation of XMLRPC Output Structure! ");
        Hashtable outputParam = new Hashtable();
        GetSpaceMetaDataOutputData outputData = (GetSpaceMetaDataOutputData)data;
        TReturnStatus returnStatus = outputData.getStatus();
        if (returnStatus != null) {
            returnStatus.encode(outputParam, "returnStatus");
        }
        if ((arrayOfSpaceDetails = outputData.getMetaDataSpaceArray()) != null) {
            arrayOfSpaceDetails.encode(outputParam, ArrayOfTMetaDataSpace.PNAME_ARRAYOFSPACEDETAILS);
        }
        log.debug(outputParam.toString());
        return outputParam;
    }
}

