/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.xmlrpc.converter.directory;

import it.grid.storm.griduser.GridUserInterface;
import it.grid.storm.griduser.GridUserManager;
import it.grid.storm.srm.types.InvalidTSURLAttributesException;
import it.grid.storm.srm.types.TReturnStatus;
import it.grid.storm.srm.types.TSURL;
import it.grid.storm.synchcall.data.InputData;
import it.grid.storm.synchcall.data.OutputData;
import it.grid.storm.synchcall.data.directory.AnonymousRmdirInputData;
import it.grid.storm.synchcall.data.directory.IdentityRmdirInputData;
import it.grid.storm.synchcall.data.directory.RmdirOutputData;
import it.grid.storm.xmlrpc.converter.Converter;
import it.grid.storm.xmlrpc.converter.ParameterDisplayHelper;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RmdirConverter
implements Converter {
    private static final Logger log = LoggerFactory.getLogger(RmdirConverter.class);

    public InputData convertToInputData(Map inputParam) {
        log.debug("srmRmdir: Converter :Call received :Creation of RmdirInputData = " + inputParam.size());
        log.debug("srmRmdir: Converter: Input Structure toString: " + ParameterDisplayHelper.display(inputParam));
        GridUserInterface guser = GridUserManager.decode(inputParam);
        TSURL surl = null;
        try {
            surl = TSURL.decode(inputParam, "surl");
        }
        catch (InvalidTSURLAttributesException e1) {
            log.debug("srmRm: ErrorCreating surl: " + e1.toString());
        }
        String member_recursive = new String("recursive");
        Boolean recursive = inputParam.get(member_recursive) == null ? false : (Boolean)inputParam.get(member_recursive);
        AnonymousRmdirInputData inputData = guser != null ? new IdentityRmdirInputData(guser, surl, recursive) : new AnonymousRmdirInputData(surl, recursive);
        return inputData;
    }

    public Map convertFromOutputData(OutputData outputData) {
        log.debug("srmRm: RmdirConverter :Call received :Creation of XMLRPC Output Structure! ");
        HashMap outputParam = new HashMap();
        RmdirOutputData rmdirOutputData = (RmdirOutputData)outputData;
        TReturnStatus outputStatus = rmdirOutputData.getStatus();
        outputStatus.encode(outputParam, "returnStatus");
        return outputParam;
    }
}

