/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.xmlrpc.converter.directory;

import it.grid.storm.griduser.GridUserInterface;
import it.grid.storm.griduser.GridUserManager;
import it.grid.storm.srm.types.InvalidTSURLAttributesException;
import it.grid.storm.srm.types.TReturnStatus;
import it.grid.storm.srm.types.TSURL;
import it.grid.storm.synchcall.data.InputData;
import it.grid.storm.synchcall.data.OutputData;
import it.grid.storm.synchcall.data.directory.AnonymousMkdirInputData;
import it.grid.storm.synchcall.data.directory.IdentityMkdirInputData;
import it.grid.storm.synchcall.data.directory.MkdirOutputData;
import it.grid.storm.xmlrpc.converter.Converter;
import it.grid.storm.xmlrpc.converter.ParameterDisplayHelper;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MkdirConverter
implements Converter {
    private static final Logger log = LoggerFactory.getLogger(MkdirConverter.class);

    public InputData convertToInputData(Map inputParam) {
        log.debug("SrmMkdir: Converter :Call received :Creation of MkdirInputData = " + inputParam.size());
        log.debug("SrmMkdir: Converter: Input Structure toString: " + ParameterDisplayHelper.display(inputParam));
        GridUserInterface guser = GridUserManager.decode(inputParam);
        TSURL surl = null;
        try {
            surl = TSURL.decode(inputParam, "surl");
        }
        catch (InvalidTSURLAttributesException e1) {
            log.debug("SrmMkdir: ErrorCreating surl: " + e1.toString());
        }
        AnonymousMkdirInputData inputData = guser != null ? new IdentityMkdirInputData(guser, surl) : new AnonymousMkdirInputData(surl);
        return inputData;
    }

    public Map convertFromOutputData(OutputData outputData) {
        log.debug("SrmMkdir: Converter :Call received :Creation of XMLRPC Output Structure! ");
        HashMap outputParam = new HashMap();
        MkdirOutputData odata = (MkdirOutputData)outputData;
        TReturnStatus outputStatus = odata.getStatus();
        outputStatus.encode(outputParam, "returnStatus");
        return outputParam;
    }
}

