/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.xmlrpc.converter.datatransfer;

import it.grid.storm.griduser.GridUserInterface;
import it.grid.storm.griduser.GridUserManager;
import it.grid.storm.srm.types.ArrayOfSURLs;
import it.grid.storm.srm.types.ArrayOfTSURLReturnStatus;
import it.grid.storm.srm.types.InvalidArrayOfSURLsAttributeException;
import it.grid.storm.srm.types.InvalidTRequestTokenAttributesException;
import it.grid.storm.srm.types.TRequestToken;
import it.grid.storm.srm.types.TReturnStatus;
import it.grid.storm.synchcall.data.InputData;
import it.grid.storm.synchcall.data.OutputData;
import it.grid.storm.synchcall.data.datatransfer.AbortFilesOutputData;
import it.grid.storm.synchcall.data.datatransfer.AbortGeneralOutputData;
import it.grid.storm.synchcall.data.datatransfer.AnonymousAbortFilesInputData;
import it.grid.storm.synchcall.data.datatransfer.IdentityAbortFilesInputData;
import it.grid.storm.xmlrpc.converter.Converter;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbortFilesConverter
implements Converter {
    private static final Logger log = LoggerFactory.getLogger(AbortFilesConverter.class);

    public InputData convertToInputData(Map inputParam) {
        ArrayOfSURLs arrayOfSURLs;
        TRequestToken requestToken;
        GridUserInterface guser = GridUserManager.decode(inputParam);
        try {
            requestToken = TRequestToken.decode(inputParam, "requestToken");
            log.debug("requestToken=" + requestToken.toString());
        }
        catch (InvalidTRequestTokenAttributesException e) {
            requestToken = null;
            log.debug("requestToken=NULL");
        }
        try {
            arrayOfSURLs = ArrayOfSURLs.decode(inputParam, "arrayOfSURLs");
        }
        catch (InvalidArrayOfSURLsAttributeException e) {
            log.debug("Empty surlArray!");
            arrayOfSURLs = null;
        }
        AnonymousAbortFilesInputData inputData = guser != null ? new IdentityAbortFilesInputData(guser, requestToken, arrayOfSURLs) : new AnonymousAbortFilesInputData(requestToken, arrayOfSURLs);
        return inputData;
    }

    public Map convertFromOutputData(OutputData data) {
        ArrayOfTSURLReturnStatus arrayOfFileStatuses;
        log.debug("AbortFilesOutputData - Creation of XMLRPC Output Structure!");
        HashMap outputParam = new HashMap();
        AbortFilesOutputData outputData = AbortFilesOutputData.make((AbortGeneralOutputData)data);
        TReturnStatus returnStatus = outputData.getReturnStatus();
        if (returnStatus != null) {
            returnStatus.encode(outputParam, "returnStatus");
        }
        if ((arrayOfFileStatuses = outputData.getArrayOfFileStatuses()) != null) {
            arrayOfFileStatuses.encode(outputParam, ArrayOfTSURLReturnStatus.PNAME_ARRAYOFFILESTATUSES);
        }
        log.debug("AbortFilesConverter - Sending: " + ((Object)outputParam).toString());
        return outputParam;
    }
}

