/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.xmlrpc;

import it.grid.storm.xmlrpc.StoRMXmlRpcException;
import it.grid.storm.xmlrpc.XMLRPCMethods;
import java.io.IOException;
import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.server.PropertyHandlerMapping;
import org.apache.xmlrpc.server.XmlRpcHandlerMapping;
import org.apache.xmlrpc.webserver.WebServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class XMLRPCHttpServer {
    private static final Logger log = LoggerFactory.getLogger(XMLRPCHttpServer.class);
    private static final int DEFAULT_PORT = 8080;
    private static final int DEFAULT_THREAD_NUM = 100;
    private final WebServer webServer;
    private boolean running = false;

    public XMLRPCHttpServer(int port, int maxThreadNum) throws StoRMXmlRpcException {
        log.info("[xmlrpc server] Creating server on port: " + port + " using at most " + maxThreadNum + " threads");
        this.webServer = this.buildWebServer(port, maxThreadNum);
    }

    public XMLRPCHttpServer(int port) throws StoRMXmlRpcException {
        this(port, 100);
    }

    public XMLRPCHttpServer() throws StoRMXmlRpcException {
        this(8080);
    }

    private WebServer buildWebServer(int port, int maxThreadNum) throws StoRMXmlRpcException {
        WebServer server = new WebServer(port);
        server.getXmlRpcServer().setMaxThreads(maxThreadNum);
        PropertyHandlerMapping phm = new PropertyHandlerMapping();
        try {
            phm.addHandler("synchcall", XMLRPCMethods.class);
        }
        catch (XmlRpcException e) {
            log.error("Unable to create synchcall PropertyHandlerMapping on XMLRPCMethods class . XmlRpcException" + e.getMessage());
            throw new StoRMXmlRpcException("Unable to initialize the XmlRpcServer");
        }
        server.getXmlRpcServer().setHandlerMapping((XmlRpcHandlerMapping)phm);
        return server;
    }

    public synchronized void start() throws StoRMXmlRpcException {
        if (!this.running) {
            log.info("[xmlrpc server] Starting server...");
            try {
                this.webServer.start();
            }
            catch (IOException e) {
                log.error("xmlrpcServer web server start failure. IOException" + e.getMessage());
                throw new StoRMXmlRpcException("Unable to create the xmlRPC server. IOException: " + e.getMessage());
            }
            this.running = true;
            log.info("[xmlrpc server] Server running...");
        }
    }

    public synchronized void stop() {
        if (this.webServer != null) {
            this.webServer.shutdown();
        }
        this.running = false;
    }
}

