/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.xmlrpc;

import it.grid.storm.health.BookKeeper;
import it.grid.storm.health.HealthDirector;
import it.grid.storm.health.LogEvent;
import it.grid.storm.health.OperationType;
import it.grid.storm.synchcall.SynchcallDispatcher;
import it.grid.storm.synchcall.SynchcallDispatcherFactory;
import it.grid.storm.synchcall.command.datatransfer.CommandException;
import it.grid.storm.synchcall.data.DataHelper;
import it.grid.storm.synchcall.data.InputData;
import it.grid.storm.synchcall.data.OutputData;
import it.grid.storm.xmlrpc.StoRMXmlRpcException;
import it.grid.storm.xmlrpc.converter.Converter;
import it.grid.storm.xmlrpc.converter.ConveterFactory;
import java.util.ArrayList;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XMLRPCExecutor {
    private static ArrayList<BookKeeper> bookKeepers = HealthDirector.getHealthMonitor().getBookKeepers();
    private static final Logger log = LoggerFactory.getLogger(XMLRPCExecutor.class);

    public Map execute(it.grid.storm.common.OperationType type, Map inputParam) throws StoRMXmlRpcException {
        OutputData outputData;
        long startTime = System.currentTimeMillis();
        long duration = System.nanoTime();
        log.debug("Executing a '" + type.toString() + "'" + "Call");
        log.debug("  Structure size  : " + inputParam.size());
        Converter converter = ConveterFactory.getConverter(type);
        SynchcallDispatcher dispatcher = SynchcallDispatcherFactory.getDispatcher();
        log.debug("Converting input data with Converter " + converter.getClass().getName());
        InputData inputData = converter.convertToInputData(inputParam);
        log.debug("Dispatching request using SynchcallDispatcher " + dispatcher.getClass().getName());
        try {
            outputData = dispatcher.processRequest(type, inputData);
        }
        catch (IllegalArgumentException e) {
            log.error("Unable to process the request. Error from the SynchcallDispatcher. IllegalArgumentException: " + e.getMessage());
            throw new StoRMXmlRpcException("Unable to process the request. IllegalArgumentException: " + e.getMessage());
        }
        catch (CommandException e) {
            log.error("Unable to execute the request. Error from the SynchcallDispatcher. CommandException: " + e.getMessage());
            throw new StoRMXmlRpcException("Unable to process the request. CommandException: " + e.getMessage());
        }
        Map<String, Object> outputParam = converter.convertFromOutputData(outputData);
        duration = System.nanoTime() - duration;
        this.logExecution(this.convertOperationType(type), DataHelper.getRequestor(inputData), startTime, duration, outputData.isSuccess());
        return outputParam;
    }

    private void logExecution(OperationType opType, String dn, long startTime, long duration, boolean successResult) {
        LogEvent event = new LogEvent(opType, dn, startTime, duration, successResult);
        if (!bookKeepers.isEmpty()) {
            log.debug("Found # " + bookKeepers.size() + "bookeepers.");
            for (int i = 0; i < bookKeepers.size(); ++i) {
                bookKeepers.get(i).addLogEvent(event);
            }
        }
    }

    private OperationType convertOperationType(it.grid.storm.common.OperationType type) {
        switch (type) {
            case PTG: {
                return OperationType.PTG;
            }
            case SPTG: {
                return OperationType.SPTG;
            }
            case PTP: {
                return OperationType.PTP;
            }
            case SPTP: {
                return OperationType.SPTP;
            }
            case COPY: {
                return OperationType.COPY;
            }
            case BOL: {
                return OperationType.BOL;
            }
            case AF: {
                return OperationType.AF;
            }
            case AR: {
                return OperationType.AR;
            }
            case EFL: {
                return OperationType.EFL;
            }
            case GSM: {
                return OperationType.GSM;
            }
            case GST: {
                return OperationType.GST;
            }
            case LS: {
                return OperationType.LS;
            }
            case MKD: {
                return OperationType.MKD;
            }
            case MV: {
                return OperationType.MV;
            }
            case PNG: {
                return OperationType.PNG;
            }
            case PD: {
                return OperationType.PD;
            }
            case RF: {
                return OperationType.RF;
            }
            case RESSP: {
                return OperationType.RS;
            }
            case RELSP: {
                return OperationType.RSP;
            }
            case RM: {
                return OperationType.RM;
            }
            case RMD: {
                return OperationType.RMD;
            }
        }
        return OperationType.UNDEF;
    }
}

