/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.tape.recalltable.resources;

import it.grid.storm.config.Configuration;
import it.grid.storm.persistence.exceptions.DataAccessException;
import it.grid.storm.persistence.model.TapeRecallTO;
import it.grid.storm.tape.recalltable.TapeRecallCatalog;
import it.grid.storm.tape.recalltable.TapeRecallException;
import it.grid.storm.tape.recalltable.model.PutTapeRecallStatusLogic;
import it.grid.storm.tape.recalltable.model.PutTapeRecallStatusValidator;
import it.grid.storm.tape.recalltable.model.TapeRecallData;
import it.grid.storm.tape.recalltable.model.TapeRecallStatus;
import it.grid.storm.tape.recalltable.persistence.TapeRecallBuilder;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.util.Date;
import java.util.UUID;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/recalltable/task")
public class TaskResource {
    private static final Logger log = LoggerFactory.getLogger(TaskResource.class);
    private static Configuration config = Configuration.getInstance();

    @GET
    @Path(value="/{taskId}")
    @Produces(value={"text/plain"})
    public String doGetWholeTask(@PathParam(value="taskId") String taskId) {
        return "doGetWholeTask: TASK-ID = " + taskId;
    }

    @GET
    @Path(value="/{taskId}/retry")
    @Produces(value={"text/plain"})
    public String doGetTaskRetry(@PathParam(value="taskId") String taskId) {
        return "doGetTaskRetry: TASK-ID = " + taskId;
    }

    @GET
    @Path(value="/{taskId}/status")
    @Produces(value={"text/plain"})
    public String doGetTaskStatus(@PathParam(value="taskId") String taskId) {
        return "doGetTaskStatus: TASK-ID = " + taskId;
    }

    @PUT
    @Path(value="/")
    @Consumes(value={"text/plain"})
    public Response putTaskStatus(InputStream input) {
        Response response;
        String inputString = this.buildInputString(input);
        log.debug("putTaskStatus() - Input:" + inputString);
        PutTapeRecallStatusValidator validator = new PutTapeRecallStatusValidator(inputString);
        if (!validator.validate()) {
            return validator.getResponse();
        }
        try {
            response = PutTapeRecallStatusLogic.serveRequest(validator.getRequestToken(), validator.getStoRI());
        }
        catch (TapeRecallException e) {
            log.error("Error serving request. TapeRecallException: " + e.getMessage());
            response = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
        return response;
    }

    @PUT
    @Path(value="/{groupTaskId}")
    @Consumes(value={"text/plain"})
    public void putNewTaskStatusOrRetryValue(@PathParam(value="groupTaskId") UUID groupTaskId, InputStream input) throws TapeRecallException {
        int intValue;
        log.debug("Requested to change recall table value for taskId " + groupTaskId);
        String inputStr = this.buildInputString(input);
        log.debug("@PUT (input string) = '" + inputStr + "'");
        String errorStr = null;
        TapeRecallCatalog rtCat = new TapeRecallCatalog();
        try {
            if (!rtCat.existsGroupTask(groupTaskId)) {
                log.info("Received a tape recall status update but no Recall Group Task found with ID = '" + groupTaskId + "'");
                throw new TapeRecallException("No Recall Group Task found with ID = '" + groupTaskId + "'");
            }
        }
        catch (DataAccessException e) {
            log.error("Unable to retrieve Recall Group Task with ID = '" + groupTaskId + "' " + e.getMessage());
            throw new TapeRecallException("Unable to retrieve Recall Group Task with ID = '" + groupTaskId + "' " + e.getMessage());
        }
        String keyRetryValue = config.getRetryValueKey();
        String keyStatus = config.getStatusKey();
        int eqIndex = inputStr.indexOf(61);
        String key = null;
        if (eqIndex <= 0) {
            errorStr = "Body '" + inputStr + "'is wrong";
            throw new TapeRecallException(errorStr);
        }
        String value = inputStr.substring(eqIndex);
        key = inputStr.substring(0, eqIndex);
        try {
            intValue = Integer.valueOf(value.substring(1, value.length() - 1));
        }
        catch (NumberFormatException e) {
            errorStr = "Unable to understand the number value = '" + value + "'";
            throw new TapeRecallException(errorStr);
        }
        if (key.equals(keyRetryValue)) {
            log.debug("Changing retry attempt of task " + groupTaskId + " to " + intValue);
            rtCat.changeGroupTaskRetryValue(groupTaskId, intValue);
        } else if (key.equals(keyStatus)) {
            log.debug("Changing status of task " + groupTaskId + " to " + intValue);
            try {
                rtCat.changeGroupTaskStatus(groupTaskId, TapeRecallStatus.getRecallTaskStatus(intValue), new Date());
            }
            catch (DataAccessException e) {
                log.error("Unable to change the status for group task id " + groupTaskId + " to status " + intValue + " . DataAccessException : " + e.getMessage());
                throw new TapeRecallException("Unable to change the status for group task id " + groupTaskId + " to status " + intValue + " . DataAccessException : " + e.getMessage());
            }
        } else {
            errorStr = "Unable to understand the key = '" + key + "' in @PUT request.";
            throw new TapeRecallException(errorStr);
        }
    }

    @POST
    @Path(value="/")
    @Consumes(value={"text/plain"})
    public Response postNewTask(InputStream input) throws TapeRecallException {
        Response result = Response.noContent().build();
        String errorStr = null;
        String inputStr = this.buildInputString(input);
        log.debug("@POST (input string) = '" + inputStr + "'");
        TapeRecallData rtd = TapeRecallData.buildFromString(inputStr);
        log.debug("RTD=" + rtd.toString());
        TapeRecallTO task = TapeRecallBuilder.buildFromPOST(rtd);
        try {
            new TapeRecallCatalog().insertNewTask(task);
        }
        catch (DataAccessException e) {
            errorStr = "Unable to insert the new task in tape recall DB.";
            log.error(errorStr);
            throw new TapeRecallException(errorStr);
        }
        URI newResource = URI.create("/" + task.getTaskId());
        result = Response.created((URI)newResource).build();
        log.debug("New task resource created: " + newResource);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String buildInputString(InputStream input) {
        BufferedReader reader = new BufferedReader(new InputStreamReader(input));
        StringBuilder sb = new StringBuilder();
        String line = null;
        try {
            while ((line = reader.readLine()) != null) {
                sb.append(line + "\n");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                input.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        String inputStr = sb.toString();
        return inputStr;
    }
}

