/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.tape.recalltable.model;

import it.grid.storm.filesystem.FSException;
import it.grid.storm.filesystem.LocalFile;
import it.grid.storm.namespace.StoRI;
import it.grid.storm.persistence.exceptions.DataAccessException;
import it.grid.storm.persistence.model.TapeRecallTO;
import it.grid.storm.tape.recalltable.TapeRecallCatalog;
import it.grid.storm.tape.recalltable.TapeRecallException;
import it.grid.storm.tape.recalltable.model.TapeRecallStatus;
import java.util.Date;
import java.util.UUID;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PutTapeRecallStatusLogic {
    private static final Logger log = LoggerFactory.getLogger(PutTapeRecallStatusLogic.class);

    public static Response serveRequest(String requestToken, StoRI stori) throws TapeRecallException {
        String outputMessage;
        boolean fileOnDisk;
        LocalFile localFile = stori.getLocalFile();
        try {
            fileOnDisk = localFile.isOnDisk();
        }
        catch (FSException e) {
            log.error("Unable to test file " + localFile.getAbsolutePath() + " presence on disk. FSException " + e.getMessage());
            throw new TapeRecallException("Error checking file existence");
        }
        if (fileOnDisk) {
            if (stori.getVirtualFileSystem().getStorageClassType().isTapeEnabled()) {
                String pfn = localFile.getAbsolutePath();
                UUID taskId = TapeRecallTO.buildTaskIdFromFileName(pfn);
                TapeRecallCatalog rtCat = new TapeRecallCatalog();
                boolean exists = false;
                try {
                    exists = rtCat.existsTask(taskId, requestToken);
                }
                catch (DataAccessException e) {
                    log.error("Error checking existence of a recall task for taskId=" + taskId + " requestToken=" + requestToken + ". DataAccessException: " + e);
                    throw new TapeRecallException("Error reading from tape recall table");
                }
                if (exists) {
                    TapeRecallTO task;
                    try {
                        task = rtCat.getTask(taskId, requestToken);
                    }
                    catch (DataAccessException e) {
                        log.error("Unable to update task recall status because unable to retrieve groupTaskId for token " + requestToken + " DataAccessException: " + e.getMessage());
                        throw new TapeRecallException("Error reading from tape recall table");
                    }
                    UUID groupTaskId = task.getGroupTaskId();
                    if (!TapeRecallStatus.getRecallTaskStatus(task.getStatusId()).equals((Object)TapeRecallStatus.SUCCESS)) {
                        boolean statusUpdated;
                        try {
                            statusUpdated = rtCat.changeGroupTaskStatus(groupTaskId, TapeRecallStatus.SUCCESS, new Date());
                        }
                        catch (DataAccessException e) {
                            log.error("Unable to update task recall status for token " + requestToken + " with groupTaskId=" + groupTaskId + ". DataAccessException : " + e.getMessage());
                            throw new TapeRecallException("Error updating tape recall table");
                        }
                        if (statusUpdated) {
                            log.info("Task status set to SUCCESS. groupTaskId=" + groupTaskId + " requestToken=" + requestToken + " pfn=" + pfn);
                        }
                        outputMessage = "true";
                    } else {
                        outputMessage = "true";
                    }
                } else {
                    outputMessage = "true";
                }
            } else {
                outputMessage = "true";
            }
        } else {
            outputMessage = "false";
        }
        return Response.ok((Object)outputMessage, (MediaType)MediaType.TEXT_PLAIN_TYPE).status(200).build();
    }
}

