/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.synchcall.data.space;

import it.grid.storm.srm.types.TLifeTimeInSeconds;
import it.grid.storm.srm.types.TRetentionPolicyInfo;
import it.grid.storm.srm.types.TReturnStatus;
import it.grid.storm.srm.types.TSizeInBytes;
import it.grid.storm.srm.types.TSpaceToken;
import it.grid.storm.synchcall.data.OutputData;
import it.grid.storm.synchcall.data.exception.InvalidReserveSpaceOutputDataAttributesException;
import java.io.Serializable;

public class ReserveSpaceOutputData
implements Serializable,
OutputData {
    private TSizeInBytes spaceTotal = null;
    private TSizeInBytes spaceGuaranteed = null;
    private TLifeTimeInSeconds spaceLifetime = null;
    private TSpaceToken spaceToken = null;
    private TReturnStatus status = null;
    private TRetentionPolicyInfo retentionPolicyInfo = null;

    public ReserveSpaceOutputData(TReturnStatus status) {
        this.status = status;
    }

    public ReserveSpaceOutputData(TSizeInBytes spaceTotal, TSizeInBytes spaceGuaranteed, TLifeTimeInSeconds spaceLifetime, TSpaceToken spaceToken, TReturnStatus status) throws InvalidReserveSpaceOutputDataAttributesException {
        boolean ok;
        boolean bl = ok = status != null;
        if (!ok) {
            throw new InvalidReserveSpaceOutputDataAttributesException(spaceTotal, spaceToken, status);
        }
        this.spaceTotal = spaceTotal;
        this.spaceGuaranteed = spaceGuaranteed;
        this.spaceLifetime = spaceLifetime;
        this.spaceToken = spaceToken;
        this.status = status;
    }

    public TSpaceToken getSpaceToken() {
        return this.spaceToken;
    }

    public TSizeInBytes getGuaranteedSize() {
        return this.spaceGuaranteed;
    }

    public TSizeInBytes getTotalSize() {
        return this.spaceTotal;
    }

    public TLifeTimeInSeconds getLifeTimeInSeconds() {
        return this.spaceLifetime;
    }

    public TReturnStatus getStatus() {
        return this.status;
    }

    public TRetentionPolicyInfo getRetentionPolicyInfo() {
        return this.retentionPolicyInfo;
    }

    public void setRetentionPolicyInfo(TRetentionPolicyInfo retentionPolicyInfo) {
        this.retentionPolicyInfo = retentionPolicyInfo;
    }

    public void setStatus(TReturnStatus status) {
        this.status = status;
    }

    public void print() {
        System.out.println("****SRM_SR_OutputData******");
        System.out.println("TSizeInBytesTotal: " + this.spaceTotal);
        System.out.println("TSizeInBytesGuar: " + this.spaceGuaranteed);
        System.out.println("LifeTimeInSeconds: " + this.spaceLifetime);
        System.out.println("TSpaceToken: " + this.spaceToken);
        System.out.println("TReturnStatus: " + this.status);
    }

    @Override
    public boolean isSuccess() {
        return true;
    }
}

