/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.synchcall.data.datatransfer;

import it.grid.storm.common.types.TURLPrefix;
import it.grid.storm.srm.types.TLifeTimeInSeconds;
import it.grid.storm.srm.types.TSURL;
import it.grid.storm.srm.types.TSpaceToken;
import it.grid.storm.synchcall.data.AbstractInputData;
import it.grid.storm.synchcall.data.datatransfer.FileTransferInputData;

public class AnonymousFileTransferInputData
extends AbstractInputData
implements FileTransferInputData {
    private final TSURL surl;
    private final TURLPrefix transferProtocols;
    private TLifeTimeInSeconds desiredPinLifetime = TLifeTimeInSeconds.makeEmpty();
    private TSpaceToken targetSpaceToken = TSpaceToken.makeEmpty();

    public AnonymousFileTransferInputData(TSURL surl, TURLPrefix transferProtocols) throws IllegalArgumentException {
        if (surl == null || transferProtocols == null) {
            throw new IllegalArgumentException("Unable to create PrepareToPutInputData. Received nul parameters: surl = " + surl + " , transferProtocols = " + transferProtocols);
        }
        this.surl = surl;
        this.transferProtocols = transferProtocols;
    }

    @Override
    public TSURL getSurl() {
        return this.surl;
    }

    @Override
    public TURLPrefix getTransferProtocols() {
        return this.transferProtocols;
    }

    @Override
    public void setTargetSpaceToken(TSpaceToken targetSpaceToken) {
        this.targetSpaceToken = targetSpaceToken;
    }

    @Override
    public TSpaceToken getTargetSpaceToken() {
        return this.targetSpaceToken;
    }

    @Override
    public TLifeTimeInSeconds getDesiredPinLifetime() {
        return this.desiredPinLifetime;
    }

    @Override
    public void setDesiredPinLifetime(TLifeTimeInSeconds desiredPinLifetime) {
        this.desiredPinLifetime = desiredPinLifetime;
    }
}

