/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.synchcall.command.space;

import it.grid.storm.acl.AclManager;
import it.grid.storm.acl.AclManagerFSAndHTTPS;
import it.grid.storm.catalogs.InvalidSpaceDataAttributesException;
import it.grid.storm.catalogs.ReservedSpaceCatalog;
import it.grid.storm.common.types.PFN;
import it.grid.storm.common.types.SizeUnit;
import it.grid.storm.filesystem.FilesystemPermission;
import it.grid.storm.filesystem.LocalFile;
import it.grid.storm.filesystem.ReservationException;
import it.grid.storm.filesystem.Space;
import it.grid.storm.griduser.CannotMapUserException;
import it.grid.storm.griduser.GridUserInterface;
import it.grid.storm.griduser.LocalUser;
import it.grid.storm.namespace.NamespaceDirector;
import it.grid.storm.namespace.NamespaceException;
import it.grid.storm.namespace.NamespaceInterface;
import it.grid.storm.namespace.StoRI;
import it.grid.storm.namespace.VirtualFSInterface;
import it.grid.storm.namespace.naming.NamespaceUtil;
import it.grid.storm.persistence.exceptions.DataAccessException;
import it.grid.storm.persistence.model.TransferObjectDecodingException;
import it.grid.storm.space.StorageSpaceData;
import it.grid.storm.srm.types.InvalidTReturnStatusAttributeException;
import it.grid.storm.srm.types.InvalidTSizeAttributesException;
import it.grid.storm.srm.types.InvalidTSpaceTokenAttributesException;
import it.grid.storm.srm.types.TAccessLatency;
import it.grid.storm.srm.types.TLifeTimeInSeconds;
import it.grid.storm.srm.types.TRetentionPolicy;
import it.grid.storm.srm.types.TRetentionPolicyInfo;
import it.grid.storm.srm.types.TReturnStatus;
import it.grid.storm.srm.types.TSURL;
import it.grid.storm.srm.types.TSizeInBytes;
import it.grid.storm.srm.types.TSpaceToken;
import it.grid.storm.srm.types.TSpaceType;
import it.grid.storm.srm.types.TStatusCode;
import it.grid.storm.synchcall.command.Command;
import it.grid.storm.synchcall.command.CommandHelper;
import it.grid.storm.synchcall.command.SpaceCommand;
import it.grid.storm.synchcall.data.IdentityInputData;
import it.grid.storm.synchcall.data.InputData;
import it.grid.storm.synchcall.data.OutputData;
import it.grid.storm.synchcall.data.exception.InvalidReserveSpaceOutputDataAttributesException;
import it.grid.storm.synchcall.data.space.GetSpaceMetaDataOutputData;
import it.grid.storm.synchcall.data.space.IdentityReserveSpaceInputData;
import it.grid.storm.synchcall.data.space.ReserveSpaceInputData;
import it.grid.storm.synchcall.data.space.ReserveSpaceOutputData;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReserveSpaceCommand
extends SpaceCommand
implements Command {
    private ReservedSpaceCatalog catalog;
    private static final Logger log = LoggerFactory.getLogger(ReserveSpaceCommand.class);
    private NamespaceInterface namespace;
    private static final boolean SUCCESS = true;
    private static final boolean FAILURE = false;
    private static final String SRM_COMMAND = "srmReserveSpace";
    TStatusCode statusCode = TStatusCode.EMPTY;
    String explanation = null;

    private String formatLogMessage(boolean success, GridUserInterface user, TSizeInBytes desSize, TSizeInBytes guarSize, TLifeTimeInSeconds lifetime, TRetentionPolicyInfo rpinfo, TStatusCode code, String expl) {
        TReturnStatus status = null;
        try {
            status = new TReturnStatus(code, expl);
        }
        catch (InvalidTReturnStatusAttributeException e) {
            e.printStackTrace();
        }
        return this.formatLogMessage(success, user, desSize, guarSize, lifetime, rpinfo, status);
    }

    private String formatLogMessage(boolean success, GridUserInterface user, TSizeInBytes desSize, TSizeInBytes guarSize, TLifeTimeInSeconds lifetime, TRetentionPolicyInfo rpinfo, TReturnStatus status) {
        StringBuffer buf = new StringBuffer("srmReserveSpace: ");
        buf.append("<" + user + "> ");
        buf.append("Request for [");
        buf.append("desiredSizeOfTotalSpace: " + desSize);
        buf.append(", desiredSizeOfGuaranteedSpace: " + guarSize);
        buf.append("] ");
        buf.append("with [desiredLifetimeOfReservedSpace: " + lifetime + "] ");
        buf.append("with [retentionPolicyInfo: " + rpinfo + "] ");
        if (success) {
            buf.append("successfully done with:[status:");
        } else {
            buf.append("failed with:[status:");
        }
        buf.append(status);
        buf.append("]");
        return buf.toString();
    }

    public ReserveSpaceCommand() {
        this.namespace = NamespaceDirector.getNamespace();
        this.catalog = new ReservedSpaceCatalog();
    }

    @Override
    public OutputData execute(InputData indata) {
        if (!(indata instanceof IdentityInputData)) {
            GetSpaceMetaDataOutputData outputData = new GetSpaceMetaDataOutputData();
            outputData.setStatus(CommandHelper.buildStatus(TStatusCode.SRM_NOT_SUPPORTED, "Anonymous user can not performsrmReserveSpace"));
            this.printRequestOutcome(outputData.getStatus(), (ReserveSpaceInputData)indata);
            return outputData;
        }
        IdentityReserveSpaceInputData data = (IdentityReserveSpaceInputData)indata;
        log.debug("<SpaceReservationManager>:reserveSpace start.");
        if (!this.checkParameters(data)) {
            return this.manageError(this.statusCode, this.explanation);
        }
        String spaceFN = null;
        try {
            spaceFN = this.getSpaceFN(data.getUser());
        }
        catch (Exception e) {
            log.error(this.formatLogMessage(false, data.getUser(), data.getDesiredSize(), data.getGuaranteedSize(), data.getSpaceLifetime(), data.getRetentionPolicyInfo(), this.statusCode, this.explanation));
            return this.manageError(this.statusCode, this.explanation);
        }
        VirtualFSInterface vfs = null;
        try {
            vfs = this.getSpaceVFS(spaceFN);
        }
        catch (Exception e) {
            log.error(this.formatLogMessage(false, data.getUser(), data.getDesiredSize(), data.getGuaranteedSize(), data.getSpaceLifetime(), data.getRetentionPolicyInfo(), this.statusCode, this.explanation));
            return this.manageError(this.statusCode, this.explanation);
        }
        this.setDefaults(data, vfs);
        String relativeSpaceFN = null;
        try {
            relativeSpaceFN = this.getRelativeSpaceFilePath(vfs, spaceFN);
        }
        catch (Exception e) {
            log.error(this.formatLogMessage(false, data.getUser(), data.getDesiredSize(), data.getGuaranteedSize(), data.getSpaceLifetime(), data.getRetentionPolicyInfo(), this.statusCode, this.explanation));
            return this.manageError(this.statusCode, this.explanation);
        }
        SpaceSize spaceSize = null;
        try {
            spaceSize = this.computeSpaceSize(data.getDesiredSize(), data.getGuaranteedSize(), vfs);
        }
        catch (Exception e) {
            log.error(this.formatLogMessage(false, data.getUser(), data.getDesiredSize(), data.getGuaranteedSize(), data.getSpaceLifetime(), data.getRetentionPolicyInfo(), this.statusCode, this.explanation));
            return this.manageError(this.statusCode, this.explanation);
        }
        StoRI spaceStori = null;
        try {
            spaceStori = this.getSpaceStoRI(vfs, relativeSpaceFN, spaceSize.getDesiderataSpaceSize());
        }
        catch (Exception e) {
            log.error(this.formatLogMessage(false, data.getUser(), data.getDesiredSize(), data.getGuaranteedSize(), data.getSpaceLifetime(), data.getRetentionPolicyInfo(), this.statusCode, this.explanation));
            return this.manageError(this.statusCode, this.explanation);
        }
        log.debug("Reserve Space File Size :" + spaceSize.getDesiderataSpaceSize().toString());
        try {
            spaceStori.getSpace().fakeAllot();
        }
        catch (ReservationException e) {
            log.debug("Space reservation fail at FS level" + e);
            this.statusCode = TStatusCode.SRM_INTERNAL_ERROR;
            this.explanation = "Unable to create Space File into filesystem. \n";
            log.error(this.formatLogMessage(false, data.getUser(), data.getDesiredSize(), data.getGuaranteedSize(), data.getSpaceLifetime(), data.getRetentionPolicyInfo(), this.statusCode, this.explanation));
            return this.manageError(this.statusCode, this.explanation);
        }
        try {
            this.setSpaceFilePermissions(spaceStori, data.getUser());
        }
        catch (Exception e) {
            log.error(this.formatLogMessage(false, data.getUser(), data.getDesiredSize(), data.getGuaranteedSize(), data.getSpaceLifetime(), data.getRetentionPolicyInfo(), this.statusCode, this.explanation));
            this.revertAllocation(spaceStori.getSpace());
            return this.manageError(this.statusCode, this.explanation);
        }
        TSpaceToken spaceToken = null;
        try {
            spaceToken = this.registerIntoDB(data.getUser(), data.getSpaceTokenAlias(), spaceSize.getTotalSize(), spaceSize.getDesiderataSpaceSize(), data.getSpaceLifetime(), spaceStori.getPFN());
        }
        catch (Exception e) {
            log.error(this.formatLogMessage(false, data.getUser(), data.getDesiredSize(), data.getGuaranteedSize(), data.getSpaceLifetime(), data.getRetentionPolicyInfo(), this.statusCode, this.explanation));
            this.revertAllocation(spaceStori.getSpace());
            return this.manageError(this.statusCode, this.explanation);
        }
        ReserveSpaceOutputData output = null;
        try {
            output = this.buildOutput(spaceSize, spaceToken, data.getSpaceLifetime());
            log.info(this.formatLogMessage(true, data.getUser(), data.getDesiredSize(), data.getGuaranteedSize(), data.getSpaceLifetime(), data.getRetentionPolicyInfo(), output.getStatus()));
        }
        catch (Exception e) {
            this.statusCode = TStatusCode.SRM_INTERNAL_ERROR;
            this.explanation = "Unable to build a valid output object ";
            log.error(this.formatLogMessage(false, data.getUser(), data.getDesiredSize(), data.getGuaranteedSize(), data.getSpaceLifetime(), data.getRetentionPolicyInfo(), this.statusCode, this.explanation));
            this.revertAllocation(spaceStori.getSpace());
            return this.manageError(this.statusCode, this.explanation);
        }
        return output;
    }

    private void revertAllocation(Space space) {
        try {
            space.fakeRelease();
        }
        catch (ReservationException e) {
            log.error("Error releasing space: ReservationException" + e.getMessage());
        }
    }

    private StoRI getSpaceStoRI(VirtualFSInterface vfs, String relativeSpaceFN, TSizeInBytes desiderataSpaceSize) throws Exception {
        StoRI spaceFile = null;
        try {
            spaceFile = vfs.createSpace(relativeSpaceFN, desiderataSpaceSize.value());
        }
        catch (NamespaceException e) {
            log.debug("Unable to create Space File in VFS ", (Throwable)e);
            this.statusCode = TStatusCode.SRM_INTERNAL_ERROR;
            this.explanation = "Unable to create Space File in VFS \n" + e;
            throw new Exception(this.explanation);
        }
        return spaceFile;
    }

    private boolean checkParameters(IdentityReserveSpaceInputData data) {
        if (data == null) {
            this.explanation = "Invalid Parameter specified";
            this.statusCode = TStatusCode.SRM_FAILURE;
            log.error(this.formatLogMessage(false, null, null, null, null, null, this.statusCode, this.explanation));
            return false;
        }
        if (data.getUser() == null) {
            log.error("SpaceRes: Unable to get user credential. ");
            this.statusCode = TStatusCode.SRM_AUTHENTICATION_FAILURE;
            this.explanation = "Unable to get user credential!";
            log.error(this.formatLogMessage(false, null, data.getDesiredSize(), data.getGuaranteedSize(), data.getSpaceLifetime(), data.getRetentionPolicyInfo(), this.statusCode, this.explanation));
            return false;
        }
        if (data.getRetentionPolicyInfo() == null) {
            log.debug("SpaceRes: Invalid request, null TRetentionPolicyInfo specified");
            this.statusCode = TStatusCode.SRM_INVALID_REQUEST;
            this.explanation = "RetentionPolicy not specified.";
            log.error(this.formatLogMessage(false, data.getUser(), data.getDesiredSize(), data.getGuaranteedSize(), data.getSpaceLifetime(), data.getRetentionPolicyInfo(), this.statusCode, this.explanation));
            return false;
        }
        TAccessLatency latency = data.getRetentionPolicyInfo().getAccessLatency();
        TRetentionPolicy retentionPolicy = data.getRetentionPolicyInfo().getRetentionPolicy();
        if (latency != null && !latency.equals(TAccessLatency.EMPTY) && !latency.equals(TAccessLatency.ONLINE) || retentionPolicy != null && !retentionPolicy.equals(TRetentionPolicy.EMPTY) && !retentionPolicy.equals(TRetentionPolicy.REPLICA)) {
            log.debug("SpaceRes: Invalid TRetentionPolicyInfo specified:  " + data.getRetentionPolicyInfo().getAccessLatency().toString() + "," + data.getRetentionPolicyInfo().getRetentionPolicy().toString());
            this.statusCode = TStatusCode.SRM_NOT_SUPPORTED;
            this.explanation = "RetentionPolicy requested cannot be satisfied.";
            log.error(this.formatLogMessage(false, data.getUser(), data.getDesiredSize(), data.getGuaranteedSize(), data.getSpaceLifetime(), data.getRetentionPolicyInfo(), this.statusCode, this.explanation));
            return false;
        }
        return true;
    }

    private String getSpaceFN(GridUserInterface user) throws Exception {
        String spaceFN = null;
        try {
            spaceFN = this.namespace.makeSpaceFileURI(user);
            log.debug(" Space FN : " + spaceFN);
        }
        catch (NamespaceException ex) {
            log.error("Unable to build default Space FN ", (Throwable)ex);
            this.statusCode = TStatusCode.SRM_INVALID_REQUEST;
            this.explanation = "Unable to build default Space FN \n" + ex;
            throw new Exception(this.explanation);
        }
        return spaceFN;
    }

    private VirtualFSInterface getSpaceVFS(String spaceFN) throws Exception {
        VirtualFSInterface vfs = null;
        try {
            vfs = this.namespace.resolveVFSbyAbsolutePath(spaceFN);
            log.debug("Space File belongs to VFS : " + vfs.getAliasName());
        }
        catch (NamespaceException ex2) {
            log.debug("Unable to resolve VFS ", (Throwable)ex2);
            this.statusCode = TStatusCode.SRM_INVALID_REQUEST;
            this.explanation = "Unable to resolve VFS \n" + ex2;
            throw new Exception(this.explanation);
        }
        return vfs;
    }

    private void setDefaults(IdentityReserveSpaceInputData data, VirtualFSInterface vfs) {
        if (data.getRetentionPolicyInfo().getAccessLatency() == null || data.getRetentionPolicyInfo().getAccessLatency().equals(TAccessLatency.EMPTY)) {
            data.getRetentionPolicyInfo().setAccessLatency(TAccessLatency.ONLINE);
        }
        if (data.getRetentionPolicyInfo().getRetentionPolicy() == null || data.getRetentionPolicyInfo().getRetentionPolicy().equals(TRetentionPolicy.EMPTY)) {
            data.getRetentionPolicyInfo().setRetentionPolicy(TRetentionPolicy.REPLICA);
        }
        if (data.getSpaceLifetime().isEmpty()) {
            log.debug("LifeTime is EMPTY. Using default value.");
            data.setSpaceLifetime(vfs.getDefaultValues().getDefaultSpaceLifetime());
        }
    }

    private SpaceSize computeSpaceSize(TSizeInBytes totalSize, TSizeInBytes guarSize, VirtualFSInterface vfs) throws Exception {
        TSizeInBytes desiderataSpaceSize = TSizeInBytes.makeEmpty();
        if (!totalSize.isEmpty() && !guarSize.isEmpty() && guarSize.value() != 0L) {
            if (totalSize.value() < guarSize.value()) {
                log.debug("Error: totalSize < guaranteedSize");
                this.statusCode = TStatusCode.SRM_INVALID_REQUEST;
                this.explanation = "Error: totalSize can not be greater then guaranteedSize";
                throw new Exception(this.explanation);
            }
        } else if (!totalSize.isEmpty()) {
            guarSize = vfs.getDefaultValues().getDefaultGuaranteedSpaceSize();
            if (totalSize.value() < guarSize.value()) {
                guarSize = totalSize;
            }
        } else if (!guarSize.isEmpty() && guarSize.value() != 0L) {
            totalSize = vfs.getDefaultValues().getDefaultTotalSpaceSize();
            if (totalSize.value() < guarSize.value()) {
                totalSize = guarSize;
                log.debug("GuaranteedSize greater than default total size!");
            }
        } else {
            totalSize = vfs.getDefaultValues().getDefaultTotalSpaceSize();
            guarSize = vfs.getDefaultValues().getDefaultGuaranteedSpaceSize();
            if (totalSize.value() < guarSize.value()) {
                totalSize = guarSize;
            }
        }
        log.debug("Parameter parsing end");
        guarSize = desiderataSpaceSize = totalSize;
        TSizeInBytes freeSpace = null;
        try {
            freeSpace = TSizeInBytes.make(vfs.getFilesystem().getFreeSpace(), SizeUnit.BYTES);
        }
        catch (InvalidTSizeAttributesException e) {
            log.debug("Error while retrieving free Space in underlying Filesystem", (Throwable)e);
            this.statusCode = TStatusCode.SRM_INTERNAL_ERROR;
            this.explanation = "Error while retrieving free Space in underlying Filesystem \n" + e;
            throw new Exception(this.explanation);
        }
        catch (NamespaceException ex) {
            log.debug("Error while retrieving free Space in underlying Filesystem. Unable to retrieve FS Driver", (Throwable)ex);
            this.statusCode = TStatusCode.SRM_INTERNAL_ERROR;
            this.explanation = "Error while retrieving free Space in underlying Filesystem. Unable to retrieve FS Driver \n" + ex;
            throw new Exception(this.explanation);
        }
        boolean lower_space = false;
        if (freeSpace.value() < desiderataSpaceSize.value()) {
            if (freeSpace.value() < guarSize.value()) {
                log.debug("<SpaceResManager>:reserveSpace Not Enough Free Space on storage!");
                this.statusCode = TStatusCode.SRM_NO_FREE_SPACE;
                this.explanation = "SRM has not more free space.";
                throw new Exception(this.explanation);
            }
            desiderataSpaceSize = guarSize;
            lower_space = true;
        }
        return new SpaceSize(desiderataSpaceSize, totalSize, lower_space);
    }

    private String getRelativeSpaceFilePath(VirtualFSInterface vfs, String spaceFN) throws Exception {
        String relativeSpaceFN = null;
        try {
            log.debug("ExtraceRelativeSpace: root:" + vfs.getRootPath() + " spaceFN:" + spaceFN);
            relativeSpaceFN = NamespaceUtil.extractRelativePath(vfs.getRootPath(), spaceFN);
            log.debug("relativeSpaceFN:" + relativeSpaceFN);
        }
        catch (NamespaceException ex3) {
            log.debug("Unable to retrieve the relative space file name ", (Throwable)ex3);
            this.statusCode = TStatusCode.SRM_INVALID_REQUEST;
            this.explanation = "Unable to retrieve the relative space file name \n" + ex3;
            throw new Exception(this.explanation);
        }
        return relativeSpaceFN;
    }

    private void setSpaceFilePermissions(StoRI spaceStori, GridUserInterface user) throws Exception {
        LocalUser localUser;
        FilesystemPermission fp = FilesystemPermission.ReadWrite;
        AclManager manager = AclManagerFSAndHTTPS.getInstance();
        LocalFile localFile = spaceStori.getLocalFile();
        try {
            localUser = user.getLocalUser();
        }
        catch (CannotMapUserException e) {
            log.debug("Unable to setting up the ACL ", (Throwable)e);
            this.statusCode = TStatusCode.SRM_INTERNAL_ERROR;
            this.explanation = "Unable to setting up the ACL ";
            throw new Exception(this.explanation);
        }
        if (localFile == null || localUser == null) {
            log.warn("Unable to setting up the ACL. Null value/s : LocalFile " + localFile + " , localUser " + localUser);
            this.statusCode = TStatusCode.SRM_INTERNAL_ERROR;
            this.explanation = "Unable to setting up the ACL ";
            throw new Exception(this.explanation);
        }
        if (spaceStori.hasJustInTimeACLs()) {
            log.debug("<SpaceResManager>:reserveSpace AddACL for FIle: " + spaceStori.getPFN() + "  " + "USER RW");
            try {
                manager.grantUserPermission(localFile, localUser, fp);
            }
            catch (IllegalArgumentException e) {
                log.error("Unable to grant user permission on space file. IllegalArgumentException: " + e.getMessage());
                this.statusCode = TStatusCode.SRM_INTERNAL_ERROR;
                this.explanation = "Unable to grant group permission on space file ";
                throw new Exception(this.explanation);
            }
        }
        log.debug("<SpaceResManager>:reserveSpace AddACL for FIle: " + spaceStori.getPFN() + "  " + "GROUP RW");
        try {
            manager.grantGroupPermission(localFile, localUser, fp);
        }
        catch (IllegalArgumentException e) {
            log.error("Unable to grant group permission on the space file. IllegalArgumentException: " + e.getMessage());
            this.statusCode = TStatusCode.SRM_INTERNAL_ERROR;
            this.explanation = "Unable to setting up the ACL ";
            throw new Exception(this.explanation);
        }
    }

    private TSpaceToken registerIntoDB(GridUserInterface user, String spaceTokenAlias, TSizeInBytes totalSize, TSizeInBytes desiderataSpaceSize, TLifeTimeInSeconds lifeTime, PFN pfn) throws Exception {
        log.debug("-- Creating Storage Space Data ...");
        StorageSpaceData spaceData = null;
        try {
            spaceData = new StorageSpaceData(user, TSpaceType.PERMANENT, spaceTokenAlias, totalSize, desiderataSpaceSize, lifeTime, null, new Date(), pfn);
        }
        catch (InvalidSpaceDataAttributesException e) {
            log.debug("Unable to create Storage Space Data", (Throwable)e);
            this.statusCode = TStatusCode.SRM_INTERNAL_ERROR;
            this.explanation = "Unable to create storage space data.";
            log.error(this.formatLogMessage(false, user, totalSize, desiderataSpaceSize, lifeTime, null, this.statusCode, this.explanation));
            throw new Exception(this.explanation);
        }
        spaceData.setUsedSpaceSize(TSizeInBytes.make(0L, SizeUnit.BYTES));
        spaceData.setUnavailableSpaceSize(TSizeInBytes.make(0L, SizeUnit.BYTES));
        spaceData.setReservedSpaceSize(desiderataSpaceSize);
        log.debug("Created space data: " + spaceData.toString());
        try {
            this.catalog.addStorageSpace(spaceData);
        }
        catch (DataAccessException e) {
            log.debug("Unable to register Storage Space Data into DB", (Throwable)e);
            this.statusCode = TStatusCode.SRM_INTERNAL_ERROR;
            this.explanation = "Unable to register Storage Space Data into DB.";
            log.error(this.formatLogMessage(false, user, totalSize, desiderataSpaceSize, lifeTime, null, this.statusCode, this.explanation));
            throw new Exception(this.explanation);
        }
        TSpaceToken spaceToken = null;
        try {
            spaceToken = TSpaceToken.make(spaceData.getSpaceToken().toString());
        }
        catch (InvalidTSpaceTokenAttributesException e) {
            log.debug("Error creating Space Token . Critical error!" + e);
            this.statusCode = TStatusCode.SRM_INTERNAL_ERROR;
            this.explanation = "Unable to create space token.";
            log.error(this.formatLogMessage(false, user, totalSize, desiderataSpaceSize, lifeTime, null, this.statusCode, this.explanation));
            throw new Exception(this.explanation);
        }
        return spaceToken;
    }

    private ReserveSpaceOutputData buildOutput(SpaceSize spaceSize, TSpaceToken spaceToken, TLifeTimeInSeconds lifeTime) throws Exception {
        TReturnStatus status = null;
        try {
            status = !spaceSize.isLowerSpace() ? new TReturnStatus(TStatusCode.SRM_SUCCESS, "Space Reservation done") : new TReturnStatus(TStatusCode.SRM_LOWER_SPACE_GRANTED, "Space Reservation done, lower space granted.");
        }
        catch (InvalidTReturnStatusAttributeException e) {
            log.debug("InvalidTReturnStatusAttributeException", (Throwable)e);
            this.statusCode = TStatusCode.SRM_INTERNAL_ERROR;
            this.explanation = "Unable to build a valid return status ";
            throw new Exception(this.explanation);
        }
        ReserveSpaceOutputData outputData = null;
        try {
            outputData = new ReserveSpaceOutputData(spaceSize.getTotalSize(), spaceSize.getDesiderataSpaceSize(), lifeTime, spaceToken, status);
        }
        catch (InvalidReserveSpaceOutputDataAttributesException ex11) {
            log.error("Error creating Output DATA . Critical error!" + ex11);
            this.statusCode = TStatusCode.SRM_INTERNAL_ERROR;
            this.explanation = "Unable to build a valid return output object ";
            throw new Exception(this.explanation);
        }
        return outputData;
    }

    public TReturnStatus resetReservation(TSpaceToken token) {
        TSizeInBytes desiderataSpaceSize;
        StorageSpaceData sdata;
        TStatusCode statusCode;
        String explanation;
        block29: {
            explanation = null;
            statusCode = TStatusCode.EMPTY;
            try {
                sdata = this.catalog.getStorageSpace(token);
            }
            catch (TransferObjectDecodingException e) {
                log.error("Unable to build StorageSpaceData from StorageSpaceTO. TransferObjectDecodingException: " + e.getMessage());
                statusCode = TStatusCode.SRM_INTERNAL_ERROR;
                explanation = "Error building space data from row DB data\n" + e;
                return this.manageErrorStatus(statusCode, explanation);
            }
            catch (DataAccessException e) {
                log.error("Unable to build get StorageSpaceTO. DataAccessException: " + e.getMessage());
                statusCode = TStatusCode.SRM_INTERNAL_ERROR;
                explanation = "Error retrieving row space token data from DB\n" + e;
                return this.manageErrorStatus(statusCode, explanation);
            }
            if (sdata.getSpaceType().equals(TSpaceType.VOSPACE)) {
                return this.manageErrorStatus(TStatusCode.SRM_SUCCESS, "Abort file done.");
            }
            GridUserInterface user = sdata.getOwner();
            PFN spacePFN = sdata.getSpaceFileName();
            String spaceFN = null;
            spaceFN = spacePFN.toString();
            VirtualFSInterface vfs = null;
            try {
                vfs = this.namespace.resolveVFSbyAbsolutePath(spaceFN);
                log.debug("Space File belongs to VFS : " + vfs.getAliasName());
            }
            catch (NamespaceException ex2) {
                log.debug("Unable to resolve VFS ", (Throwable)ex2);
                statusCode = TStatusCode.SRM_INVALID_REQUEST;
                explanation = "Unable to resolve VFS \n" + ex2;
                return this.manageErrorStatus(statusCode, explanation);
            }
            String relativeSpaceFN = null;
            try {
                log.debug("ExtractRelativeSpace: root:" + vfs.getRootPath() + " spaceFN:" + spaceFN);
                relativeSpaceFN = NamespaceUtil.extractRelativePath(vfs.getRootPath(), spaceFN);
                log.debug("relativeSpaceFN:" + relativeSpaceFN);
            }
            catch (NamespaceException ex3) {
                log.debug("Unable to retrieve the relative space file name ", (Throwable)ex3);
                statusCode = TStatusCode.SRM_INVALID_REQUEST;
                explanation = "Unable to retrieve the relative space file name \n" + ex3;
                return this.manageErrorStatus(statusCode, explanation);
            }
            desiderataSpaceSize = sdata.getTotalSpaceSize();
            TSizeInBytes totalSize = sdata.getTotalSpaceSize();
            TSizeInBytes guarSize = sdata.getReservedSpaceSize();
            try {
                long bytesFree = vfs.getFilesystem().getFreeSpace();
                TSizeInBytes freeSpace = TSizeInBytes.make(bytesFree, SizeUnit.BYTES);
            }
            catch (InvalidTSizeAttributesException e) {
                log.debug("Error while retrieving free Space in underlying Filesystem", (Throwable)e);
                statusCode = TStatusCode.SRM_INTERNAL_ERROR;
                explanation = "Error while retrieving free Space in underlying Filesystem \n" + e;
                return this.manageErrorStatus(statusCode, explanation);
            }
            catch (NamespaceException ex) {
                log.debug("Error while retrieving free Space in underlying Filesystem. Unable to retrieve FS Driver", (Throwable)ex);
                statusCode = TStatusCode.SRM_INTERNAL_ERROR;
                explanation = "Error while retrieving free Space in underlying Filesystem. Unable to retrieve FS Driver \n" + ex;
                return this.manageErrorStatus(statusCode, explanation);
            }
            boolean authorize = true;
            if (authorize) {
                log.debug("reserve Space File Size :" + desiderataSpaceSize.toString());
                StoRI spaceFile = null;
                try {
                    spaceFile = vfs.createSpace(relativeSpaceFN, desiderataSpaceSize.value());
                }
                catch (NamespaceException ex4) {
                    log.debug("Unable to create Space File in VFS ", (Throwable)ex4);
                    statusCode = TStatusCode.SRM_INTERNAL_ERROR;
                    explanation = "Unable to create Space File in VFS \n" + ex4;
                    return this.manageErrorStatus(statusCode, explanation);
                }
                try {
                    spaceFile.getSpace().allot();
                }
                catch (ReservationException e) {
                    log.debug("Space reservation fail at FS level" + e);
                    statusCode = TStatusCode.SRM_INTERNAL_ERROR;
                    explanation = "Unable to create Space File into filesystem. \n";
                    return this.manageErrorStatus(statusCode, explanation);
                }
                boolean hasJiTACL = spaceFile.hasJustInTimeACLs();
                FilesystemPermission fp = FilesystemPermission.ReadWrite;
                if (hasJiTACL) {
                    log.debug("<SpaceResManager>:reserveSpace AddACL for FIle: " + spacePFN + "  " + "USER RW");
                    try {
                        AclManager manager = AclManagerFSAndHTTPS.getInstance();
                        LocalFile localFile = spaceFile.getLocalFile();
                        LocalUser localUser = user.getLocalUser();
                        if (localFile == null || localUser == null) {
                            log.warn("Unable to setting up the ACL. Null value/s : LocalFile " + localFile + " , localUser " + localUser);
                            statusCode = TStatusCode.SRM_INTERNAL_ERROR;
                            explanation = "Unable to setting up the ACL ";
                            return this.manageErrorStatus(statusCode, explanation);
                        }
                        try {
                            manager.grantGroupPermission(localFile, localUser, fp);
                            break block29;
                        }
                        catch (IllegalArgumentException e) {
                            log.error("Unable to grant group permission on space file. IllegalArgumentException: " + e.getMessage());
                            statusCode = TStatusCode.SRM_INTERNAL_ERROR;
                            explanation = "Unable to grant group permission on space file ";
                            return this.manageErrorStatus(statusCode, explanation);
                        }
                    }
                    catch (CannotMapUserException ex5) {
                        log.debug("Unable to setting up the ACL ", (Throwable)ex5);
                        statusCode = TStatusCode.SRM_INTERNAL_ERROR;
                        explanation = "Unable to setting up the ACL ";
                        return this.manageErrorStatus(statusCode, explanation);
                    }
                }
                log.debug("<SpaceResManager>:reserveSpace AddACL for FIle: " + spacePFN + "  " + "GROUP RW");
                try {
                    AclManager manager = AclManagerFSAndHTTPS.getInstance();
                    LocalFile localFile = spaceFile.getLocalFile();
                    LocalUser localUser = user.getLocalUser();
                    if (localFile == null || localUser == null) {
                        log.warn("Unable to setting up the ACL. Null value/s : LocalFile " + localFile + " , localUser " + localUser);
                        statusCode = TStatusCode.SRM_INTERNAL_ERROR;
                        explanation = "Unable to setting up the ACL ";
                        return this.manageErrorStatus(statusCode, explanation);
                    }
                    try {
                        manager.grantGroupPermission(localFile, localUser, fp);
                    }
                    catch (IllegalArgumentException e) {
                        log.error("Unable to grant group permission on space file. IllegalArgumentException: " + e.getMessage());
                        statusCode = TStatusCode.SRM_INTERNAL_ERROR;
                        explanation = "Unable to grant group permission on space file ";
                        return this.manageErrorStatus(statusCode, explanation);
                    }
                }
                catch (CannotMapUserException ex5) {
                    log.debug("Unable to setting up the ACL ", (Throwable)ex5);
                    statusCode = TStatusCode.SRM_INTERNAL_ERROR;
                    explanation = "Unable to setting up the ACL ";
                    return this.manageErrorStatus(statusCode, explanation);
                }
            }
        }
        sdata.setUsedSpaceSize(desiderataSpaceSize);
        try {
            this.catalog.updateStorageSpaceFreeSpace(sdata);
        }
        catch (DataAccessException e) {
            log.error("Unable to persist the space reservation into the DB. DataAccessException: " + e.getMessage());
            statusCode = TStatusCode.SRM_INTERNAL_ERROR;
            explanation = "Error persisting space token data into the DB\n" + e.getMessage();
            return this.manageErrorStatus(statusCode, explanation);
        }
        return this.manageErrorStatus(TStatusCode.SRM_SUCCESS, "Successfull creation.");
    }

    public TReturnStatus updateReservation(TSpaceToken token, TSizeInBytes sizeToAdd, TSURL toSurl) {
        LocalFile localFile;
        TSizeInBytes availableSize;
        StorageSpaceData sdata;
        TStatusCode statusCode;
        String explanation;
        block30: {
            AclManager manager;
            explanation = null;
            statusCode = TStatusCode.EMPTY;
            try {
                sdata = this.catalog.getStorageSpace(token);
            }
            catch (TransferObjectDecodingException e) {
                log.error("Unable to build StorageSpaceData from StorageSpaceTO. TransferObjectDecodingException: " + e.getMessage());
                statusCode = TStatusCode.SRM_INTERNAL_ERROR;
                explanation = "Error building space data from row DB data\n" + e;
                return this.manageErrorStatus(statusCode, explanation);
            }
            catch (DataAccessException e) {
                log.error("Unable to build get StorageSpaceTO. DataAccessException: " + e.getMessage());
                statusCode = TStatusCode.SRM_INTERNAL_ERROR;
                explanation = "Error retrieving row space token data from DB\n" + e;
                return this.manageErrorStatus(statusCode, explanation);
            }
            GridUserInterface user = sdata.getOwner();
            PFN spacePFN = sdata.getSpaceFileName();
            if (sdata.getSpaceType().equals(TSpaceType.VOSPACE)) {
                return this.manageErrorStatus(TStatusCode.SRM_SUCCESS, "Abort file done.");
            }
            String spaceFN = null;
            spaceFN = spacePFN.toString();
            VirtualFSInterface vfs = null;
            try {
                vfs = this.namespace.resolveVFSbyAbsolutePath(spaceFN);
                log.debug("Space File belongs to VFS : " + vfs.getAliasName());
            }
            catch (NamespaceException ex2) {
                log.debug("Unable to resolve VFS ", (Throwable)ex2);
                statusCode = TStatusCode.SRM_INVALID_REQUEST;
                explanation = "Unable to resolve VFS \n" + ex2;
                return this.manageErrorStatus(statusCode, explanation);
            }
            String relativeSpaceFN = null;
            try {
                log.debug("ExtractRelativeSpace: root:" + vfs.getRootPath() + " spaceFN:" + spaceFN);
                relativeSpaceFN = NamespaceUtil.extractRelativePath(vfs.getRootPath(), spaceFN);
                log.debug("relativeSpaceFN:" + relativeSpaceFN);
            }
            catch (NamespaceException ex3) {
                log.debug("Unable to retrieve the relative space file name ", (Throwable)ex3);
                statusCode = TStatusCode.SRM_INVALID_REQUEST;
                explanation = "Unable to retrieve the relative space file name \n" + ex3;
                return this.manageErrorStatus(statusCode, explanation);
            }
            TSizeInBytes desiderataSpaceSize = sdata.getTotalSpaceSize();
            availableSize = sdata.getAvailableSpaceSize();
            log.debug("available Size : " + availableSize.value());
            log.debug("Size of removed file: " + sizeToAdd.value());
            try {
                desiderataSpaceSize = TSizeInBytes.make(availableSize.value() + sizeToAdd.value(), SizeUnit.BYTES);
            }
            catch (InvalidTSizeAttributesException e1) {
                e1.printStackTrace();
            }
            log.debug("reserve Space File Size :" + desiderataSpaceSize.toString());
            StoRI spaceFile = null;
            try {
                spaceFile = vfs.createSpace(relativeSpaceFN, desiderataSpaceSize.value());
            }
            catch (NamespaceException ex4) {
                log.debug("Unable to create Space File in VFS ", (Throwable)ex4);
                statusCode = TStatusCode.SRM_INTERNAL_ERROR;
                explanation = "Unable to create Space File in VFS \n" + ex4;
                return this.manageErrorStatus(statusCode, explanation);
            }
            localFile = spaceFile.getLocalFile();
            if (localFile != null) {
                localFile.delete();
            }
            try {
                spaceFile.getSpace().allot();
            }
            catch (ReservationException e) {
                log.debug("Space reservation fail at FS level" + e);
                this.revertOldSpaceFileDeletion(localFile);
                statusCode = TStatusCode.SRM_INTERNAL_ERROR;
                explanation = "Unable to create Space File into filesystem. \n";
                return this.manageErrorStatus(statusCode, explanation);
            }
            boolean hasJiTACL = spaceFile.hasJustInTimeACLs();
            FilesystemPermission fp = FilesystemPermission.ReadWrite;
            if (hasJiTACL) {
                log.debug("<SpaceResManager>:reserveSpace AddACL for FIle: " + spacePFN + "  " + "USER RW");
                try {
                    manager = AclManagerFSAndHTTPS.getInstance();
                    localFile = spaceFile.getLocalFile();
                    LocalUser localUser = user.getLocalUser();
                    if (localFile == null || localUser == null) {
                        log.warn("Unable to setting up the ACL. Null value/s : LocalFile " + localFile + " , localUser " + localUser);
                        this.revertOldSpaceFileDeletion(localFile);
                        statusCode = TStatusCode.SRM_INTERNAL_ERROR;
                        explanation = "Unable to setting up the ACL ";
                        return this.manageErrorStatus(statusCode, explanation);
                    }
                    try {
                        manager.grantGroupPermission(localFile, localUser, fp);
                        break block30;
                    }
                    catch (IllegalArgumentException e) {
                        log.error("Unable to grant group permission on space file. IllegalArgumentException: " + e.getMessage());
                        this.revertOldSpaceFileDeletion(localFile);
                        statusCode = TStatusCode.SRM_INTERNAL_ERROR;
                        explanation = "Unable to grant group permission on space file ";
                        return this.manageErrorStatus(statusCode, explanation);
                    }
                }
                catch (CannotMapUserException ex5) {
                    log.debug("Unable to setting up the ACL ", (Throwable)ex5);
                    this.revertOldSpaceFileDeletion(localFile);
                    statusCode = TStatusCode.SRM_INTERNAL_ERROR;
                    explanation = "Unable to setting up the ACL ";
                    return this.manageErrorStatus(statusCode, explanation);
                }
            }
            log.debug("<SpaceResManager>:reserveSpace AddACL for FIle: " + spacePFN + "  " + "GROUP RW");
            try {
                manager = AclManagerFSAndHTTPS.getInstance();
                localFile = spaceFile.getLocalFile();
                LocalUser localUser = user.getLocalUser();
                if (localFile == null || localUser == null) {
                    log.warn("Unable to setting up the ACL. Null value/s : LocalFile " + localFile + " , localUser " + localUser);
                    this.revertOldSpaceFileDeletion(localFile);
                    statusCode = TStatusCode.SRM_INTERNAL_ERROR;
                    explanation = "Unable to setting up the ACL ";
                    return this.manageErrorStatus(statusCode, explanation);
                }
                try {
                    manager.grantGroupPermission(spaceFile.getLocalFile(), localUser, fp);
                }
                catch (IllegalArgumentException e) {
                    log.error("Unable to grant group permission on space file. IllegalArgumentException: " + e.getMessage());
                    this.revertOldSpaceFileDeletion(localFile);
                    statusCode = TStatusCode.SRM_INTERNAL_ERROR;
                    explanation = "Unable to grant group permission on space file ";
                    return this.manageErrorStatus(statusCode, explanation);
                }
            }
            catch (CannotMapUserException ex5) {
                log.debug("Unable to setting up the ACL ", (Throwable)ex5);
                this.revertOldSpaceFileDeletion(localFile);
                statusCode = TStatusCode.SRM_INTERNAL_ERROR;
                explanation = "Unable to setting up the ACL ";
                return this.manageErrorStatus(statusCode, explanation);
            }
        }
        try {
            availableSize = TSizeInBytes.make(sdata.getAvailableSpaceSize().value() + sizeToAdd.value(), SizeUnit.BYTES);
        }
        catch (InvalidTSizeAttributesException e) {
            log.error("Unable to compute new available space size. InvalidTSizeAttributesException: " + e.getMessage());
            this.revertOldSpaceFileDeletion(localFile);
            statusCode = TStatusCode.SRM_INTERNAL_ERROR;
            explanation = "Error computing new available space size\n" + e.getMessage();
            return this.manageErrorStatus(statusCode, explanation);
        }
        sdata.forceAvailableSpaceSize(availableSize);
        try {
            this.catalog.updateStorageSpaceFreeSpace(sdata);
        }
        catch (DataAccessException e) {
            log.error("Unable to persist the space reservation into the DB. DataAccessException: " + e.getMessage());
            this.revertOldSpaceFileDeletion(localFile);
            statusCode = TStatusCode.SRM_INTERNAL_ERROR;
            explanation = "Error persisting space token data into the DB\n" + e.getMessage();
            return this.manageErrorStatus(statusCode, explanation);
        }
        return this.manageErrorStatus(TStatusCode.SRM_SUCCESS, "Successfull creation.");
    }

    private void revertOldSpaceFileDeletion(LocalFile localFile) {
    }

    private ReserveSpaceOutputData manageError(TStatusCode statusCode, String explanation) {
        TReturnStatus status = null;
        try {
            status = new TReturnStatus(statusCode, explanation);
        }
        catch (InvalidTReturnStatusAttributeException ex1) {
            log.warn("SpaceManger: Error creating returnStatus " + ex1);
        }
        return new ReserveSpaceOutputData(status);
    }

    private TReturnStatus manageErrorStatus(TStatusCode statusCode, String explanation) {
        TReturnStatus status = null;
        try {
            status = new TReturnStatus(statusCode, explanation);
        }
        catch (InvalidTReturnStatusAttributeException ex1) {
            log.warn("SpaceManger: Error creating returnStatus " + ex1);
        }
        return status;
    }

    private void printRequestOutcome(TReturnStatus status, ReserveSpaceInputData data) {
        if (data != null) {
            CommandHelper.printRequestOutcome(SRM_COMMAND, log, status, data);
        } else {
            CommandHelper.printRequestOutcome(SRM_COMMAND, log, status);
        }
    }

    private class SpaceSize {
        private final TSizeInBytes desiderataSpaceSize;
        private final TSizeInBytes totalSize;
        private final boolean lowerSpace;

        public SpaceSize(TSizeInBytes desiderataSpaceSize, TSizeInBytes totalSize, boolean lowerSpace) {
            this.desiderataSpaceSize = desiderataSpaceSize;
            this.totalSize = totalSize;
            this.lowerSpace = lowerSpace;
        }

        protected TSizeInBytes getDesiderataSpaceSize() {
            return this.desiderataSpaceSize;
        }

        protected TSizeInBytes getTotalSize() {
            return this.totalSize;
        }

        protected boolean isLowerSpace() {
            return this.lowerSpace;
        }
    }
}

