/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.synchcall.command.space;

import it.grid.storm.catalogs.ReservedSpaceCatalog;
import it.grid.storm.common.types.PFN;
import it.grid.storm.griduser.GridUserInterface;
import it.grid.storm.persistence.exceptions.DataAccessException;
import it.grid.storm.persistence.model.TransferObjectDecodingException;
import it.grid.storm.space.StorageSpaceData;
import it.grid.storm.srm.types.InvalidTReturnStatusAttributeException;
import it.grid.storm.srm.types.TReturnStatus;
import it.grid.storm.srm.types.TStatusCode;
import it.grid.storm.synchcall.command.Command;
import it.grid.storm.synchcall.command.CommandHelper;
import it.grid.storm.synchcall.command.SpaceCommand;
import it.grid.storm.synchcall.data.IdentityInputData;
import it.grid.storm.synchcall.data.InputData;
import it.grid.storm.synchcall.data.OutputData;
import it.grid.storm.synchcall.data.space.IdentityReleaseSpaceInputData;
import it.grid.storm.synchcall.data.space.ReleaseSpaceInputData;
import it.grid.storm.synchcall.data.space.ReleaseSpaceOutputData;
import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReleaseSpaceCommand
extends SpaceCommand
implements Command {
    private final ReservedSpaceCatalog catalog = new ReservedSpaceCatalog();
    private static final Logger log = LoggerFactory.getLogger(ReleaseSpaceCommand.class);
    private static final String SRM_COMMAND = "srmReleaseSpace";

    @Override
    public OutputData execute(InputData indata) {
        StorageSpaceData data;
        ReleaseSpaceOutputData outputData = new ReleaseSpaceOutputData();
        if (!(indata instanceof IdentityInputData)) {
            outputData.setStatus(CommandHelper.buildStatus(TStatusCode.SRM_NOT_SUPPORTED, "Anonymous user can not performsrmReleaseSpace"));
            this.printRequestOutcome(outputData.getStatus(), (ReleaseSpaceInputData)indata);
            return outputData;
        }
        IdentityReleaseSpaceInputData inputData = (IdentityReleaseSpaceInputData)indata;
        TReturnStatus returnStatus = null;
        if (inputData == null || inputData != null && inputData.getSpaceToken() == null) {
            log.error("ReleaseSpace : Invalid input parameter specified");
            returnStatus = this.manageStatus(TStatusCode.SRM_INVALID_REQUEST, "SpaceToken is empty.");
            outputData.setStatus(returnStatus);
            return outputData;
        }
        GridUserInterface user = inputData.getUser();
        if (user == null) {
            log.debug("Release Space: Unable to get user credential. ");
            returnStatus = this.manageStatus(TStatusCode.SRM_AUTHENTICATION_FAILURE, "Unable to get user credential");
            outputData.setStatus(returnStatus);
            log.error("srmReleaseSpace: <" + user + "> Request for [spacetoken:" + inputData.getSpaceToken() + "] failed with: [status:" + returnStatus + "]");
            return outputData;
        }
        log.debug("INPUT data not null");
        boolean forceFileRelease = inputData.isForceFileRelease();
        boolean nopinned = true;
        boolean failure = false;
        String explanation = "";
        TStatusCode statusCode = null;
        try {
            data = this.catalog.getStorageSpace(inputData.getSpaceToken());
        }
        catch (TransferObjectDecodingException e) {
            log.error("Unable to build StorageSpaceData from StorageSpaceTO. TransferObjectDecodingException: " + e.getMessage());
            failure = true;
            explanation = "Error building space data from row DB data.";
            statusCode = TStatusCode.SRM_INTERNAL_ERROR;
            returnStatus = this.manageStatus(statusCode, explanation);
            outputData.setStatus(returnStatus);
            log.error("srmReleaseSpace: <" + user + "> Request for [spacetoken:" + inputData.getSpaceToken() + "] for failed with: [status:" + returnStatus + "]");
            return outputData;
        }
        catch (DataAccessException e) {
            log.error("Unable to build get StorageSpaceTO. DataAccessException: " + e.getMessage());
            failure = true;
            explanation = "Error retrieving row space token data from DB.";
            statusCode = TStatusCode.SRM_INTERNAL_ERROR;
            returnStatus = this.manageStatus(statusCode, explanation);
            outputData.setStatus(returnStatus);
            log.error("srmReleaseSpace: <" + user + "> Request for [spacetoken:" + inputData.getSpaceToken() + "] for failed with: [status:" + returnStatus + "]");
            return outputData;
        }
        if (data == null) {
            failure = true;
            explanation = "SpaceToken does not refers to an existing space.";
            statusCode = TStatusCode.SRM_INVALID_REQUEST;
            returnStatus = this.manageStatus(statusCode, explanation);
            outputData.setStatus(returnStatus);
            log.error("srmReleaseSpace: <" + user + "> Request for [spacetoken:" + inputData.getSpaceToken() + "] for failed with: [status:" + returnStatus + "]");
            return outputData;
        }
        log.debug("ReleaseExecutor: space data not null retrieved.");
        if (!forceFileRelease) {
            nopinned = true;
        }
        if (forceFileRelease || nopinned) {
            if (data.getOwner().getDn().equals(user.getDn())) {
                log.debug("ReleaseCommand: Authorized Release Space for user: " + data.getOwner());
                returnStatus = this.manageAuthorizedReleaseSpace(data, user);
            } else {
                log.debug("ReleaseCommand: Unauthorized ReleaseSpaceRequest!");
                failure = true;
                explanation = "User is not authorized to release this token";
                statusCode = TStatusCode.SRM_AUTHORIZATION_FAILURE;
                returnStatus = this.manageStatus(statusCode, explanation);
            }
        } else {
            log.debug("ReleaseCommand: Space still contains pinned files!");
            failure = true;
            explanation = "Space still contains pinned files. ";
            statusCode = TStatusCode.SRM_FAILURE;
            returnStatus = this.manageStatus(statusCode, explanation);
        }
        log.debug("ReleaseCommand:return outputData");
        outputData.setStatus(returnStatus);
        if (returnStatus.isSRM_SUCCESS()) {
            log.info("srmReleaseSpace: <" + user + "> Request for [spacetoken:" + inputData.getSpaceToken() + "] successfully done with: [status:" + returnStatus + "]");
        } else {
            log.error("srmReleaseSpace: <" + user + "> Request for [spacetoken:" + inputData.getSpaceToken() + "] for failed with: [status:" + returnStatus + "]");
        }
        return outputData;
    }

    private TReturnStatus manageAuthorizedReleaseSpace(StorageSpaceData data, GridUserInterface user) {
        PFN pfn = data.getSpaceFileName();
        log.debug("ReleaseCommand: manageAuthorizedReleaseSpace");
        if (pfn != null) {
            String spaceFileName = pfn.getValue();
            log.debug("ReleaseCommand: spaceFileName: " + spaceFileName);
            File spaceFile = new File(spaceFileName);
            if (spaceFile.delete()) {
                if (this.catalog.release(user, data.getSpaceToken())) {
                    return this.manageStatus(TStatusCode.SRM_SUCCESS, "Space Released.");
                }
                return this.manageStatus(TStatusCode.SRM_INTERNAL_ERROR, "Space removed, but spaceToken was not found in the DB");
            }
            return this.manageStatus(TStatusCode.SRM_FAILURE, "Space can not be removed by StoRM!");
        }
        return this.manageStatus(TStatusCode.SRM_FAILURE, "SRM Internal failure.");
    }

    private TReturnStatus manageStatus(TStatusCode statusCode, String explanation) {
        TReturnStatus returnStatus = null;
        try {
            returnStatus = new TReturnStatus(statusCode, explanation);
        }
        catch (InvalidTReturnStatusAttributeException ex1) {
            log.debug("ReleaseFile : Error creating returnStatus " + ex1);
        }
        return returnStatus;
    }

    private void printRequestOutcome(TReturnStatus status, ReleaseSpaceInputData indata) {
        if (indata != null) {
            CommandHelper.printRequestOutcome(SRM_COMMAND, log, status, indata);
        } else {
            CommandHelper.printRequestOutcome(SRM_COMMAND, log, status);
        }
    }
}

