/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.synchcall.command.space;

import it.grid.storm.catalogs.ReservedSpaceCatalog;
import it.grid.storm.griduser.GridUserInterface;
import it.grid.storm.srm.types.ArrayOfTSpaceToken;
import it.grid.storm.srm.types.InvalidTReturnStatusAttributeException;
import it.grid.storm.srm.types.TReturnStatus;
import it.grid.storm.srm.types.TStatusCode;
import it.grid.storm.synchcall.command.Command;
import it.grid.storm.synchcall.command.CommandHelper;
import it.grid.storm.synchcall.command.SpaceCommand;
import it.grid.storm.synchcall.data.IdentityInputData;
import it.grid.storm.synchcall.data.InputData;
import it.grid.storm.synchcall.data.OutputData;
import it.grid.storm.synchcall.data.space.GetSpaceTokensInputData;
import it.grid.storm.synchcall.data.space.GetSpaceTokensOutputData;
import it.grid.storm.synchcall.data.space.IdentityGetSpaceTokensInputData;

public class GetSpaceTokensCommand
extends SpaceCommand
implements Command {
    private static final String SRM_COMMAND = "srmGetSpaceTokens";
    private ReservedSpaceCatalog catalog = new ReservedSpaceCatalog();

    @Override
    public OutputData execute(InputData data) {
        if (!(data instanceof IdentityInputData)) {
            GetSpaceTokensOutputData outputData = new GetSpaceTokensOutputData();
            outputData.setStatus(CommandHelper.buildStatus(TStatusCode.SRM_NOT_SUPPORTED, "Anonymous user can not performsrmGetSpaceTokens"));
            this.printRequestOutcome(outputData.getStatus(), (GetSpaceTokensInputData)data);
            return outputData;
        }
        IdentityGetSpaceTokensInputData inputData = (IdentityGetSpaceTokensInputData)data;
        TReturnStatus status = null;
        this.log.debug("Started GetSpaceTokens function");
        GridUserInterface user = inputData.getUser();
        if (user == null) {
            this.log.debug("GetSpaceTokens: the user field is NULL");
            try {
                status = new TReturnStatus(TStatusCode.SRM_AUTHENTICATION_FAILURE, "Unable to get user credential!");
            }
            catch (InvalidTReturnStatusAttributeException ex1) {
                this.log.debug("GetSpaceTokens: Error creating returnStatus ");
            }
            this.log.error("srmGetSpaceTokens: <" + user + "> Request for [spaceTokenDescription:" + inputData.getSpaceTokenAlias() + "] failed with: [status:" + status + "]");
            GetSpaceTokensOutputData outputData = new GetSpaceTokensOutputData(status, null);
            return outputData;
        }
        String spaceAlias = inputData.getSpaceTokenAlias();
        if (spaceAlias == null) {
            this.log.debug("userSpaceTokenDescription=NULL");
        } else {
            this.log.debug("userSpaceTokenDescription=" + spaceAlias);
        }
        ArrayOfTSpaceToken arrayOfSpaceTokens = this.catalog.getSpaceTokens(user, spaceAlias);
        if (arrayOfSpaceTokens.size() == 0) {
            arrayOfSpaceTokens = this.catalog.getSpaceTokensByAlias(spaceAlias);
        }
        try {
            if (arrayOfSpaceTokens.size() == 0) {
                status = spaceAlias != null ? new TReturnStatus(TStatusCode.SRM_INVALID_REQUEST, "'userSpaceTokenDescription' does not refer to an existing space") : new TReturnStatus(TStatusCode.SRM_FAILURE, "No space tokens owned by this user");
                arrayOfSpaceTokens = null;
            } else {
                status = new TReturnStatus(TStatusCode.SRM_SUCCESS, "");
            }
        }
        catch (InvalidTReturnStatusAttributeException e) {
            this.log.error("GetSpaceTokens: Error creating returnStatus ");
        }
        if (status.isSRM_SUCCESS()) {
            this.log.info("srmGetSpaceTokens: <" + user + "> Request for [spaceTokenDescription:" + inputData.getSpaceTokenAlias() + "] successfully done with: [status:" + status + "]");
        } else {
            this.log.error("srmGetSpaceTokens: <" + user + "> Request for [spaceTokenDescription:" + inputData.getSpaceTokenAlias() + "] failed with: [status:" + status + "]");
        }
        GetSpaceTokensOutputData outputData = new GetSpaceTokensOutputData(status, arrayOfSpaceTokens);
        return outputData;
    }

    private void printRequestOutcome(TReturnStatus status, GetSpaceTokensInputData data) {
        if (data != null) {
            CommandHelper.printRequestOutcome(SRM_COMMAND, this.log, status, data);
        } else {
            CommandHelper.printRequestOutcome(SRM_COMMAND, this.log, status);
        }
    }
}

