/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.synchcall.command.space;

import it.grid.storm.catalogs.ReservedSpaceCatalog;
import it.grid.storm.griduser.GridUserInterface;
import it.grid.storm.persistence.exceptions.DataAccessException;
import it.grid.storm.persistence.model.TransferObjectDecodingException;
import it.grid.storm.space.StorageSpaceData;
import it.grid.storm.space.quota.BackgroundGPFSQuota;
import it.grid.storm.srm.types.ArrayOfTMetaDataSpace;
import it.grid.storm.srm.types.ArrayOfTSpaceToken;
import it.grid.storm.srm.types.InvalidTMetaDataSpaceAttributeException;
import it.grid.storm.srm.types.InvalidTReturnStatusAttributeException;
import it.grid.storm.srm.types.InvalidTSizeAttributesException;
import it.grid.storm.srm.types.TMetaDataSpace;
import it.grid.storm.srm.types.TReturnStatus;
import it.grid.storm.srm.types.TSpaceToken;
import it.grid.storm.srm.types.TStatusCode;
import it.grid.storm.synchcall.command.Command;
import it.grid.storm.synchcall.command.CommandHelper;
import it.grid.storm.synchcall.command.SpaceCommand;
import it.grid.storm.synchcall.data.IdentityInputData;
import it.grid.storm.synchcall.data.InputData;
import it.grid.storm.synchcall.data.OutputData;
import it.grid.storm.synchcall.data.exception.InvalidGetSpaceMetaDataOutputAttributeException;
import it.grid.storm.synchcall.data.space.GetSpaceMetaDataInputData;
import it.grid.storm.synchcall.data.space.GetSpaceMetaDataOutputData;
import it.grid.storm.synchcall.data.space.IdentityGetSpaceMetaDataInputData;

public class GetSpaceMetaDataCommand
extends SpaceCommand
implements Command {
    private ReservedSpaceCatalog catalog = new ReservedSpaceCatalog();
    private static final boolean SUCCESS = true;
    private static final boolean FAILURE = false;
    private static final boolean GLOBALSTATUS = true;
    private static final boolean LOCALSTATUS = false;
    private static final String SRM_COMMAND = "srmGetSpaceMetaData";

    @Override
    public OutputData execute(InputData indata) {
        this.log.debug("<GetSpaceMetaData Start!>");
        this.log.debug(" Updating SA with GPFS quotas results");
        BackgroundGPFSQuota.getInstance().submitGPFSQuota();
        if (!(indata instanceof IdentityInputData)) {
            GetSpaceMetaDataOutputData outputData = new GetSpaceMetaDataOutputData();
            outputData.setStatus(CommandHelper.buildStatus(TStatusCode.SRM_NOT_SUPPORTED, "Anonymous user can not performsrmGetSpaceMetaData"));
            this.printRequestOutcome(outputData.getStatus(), (GetSpaceMetaDataInputData)indata);
            return outputData;
        }
        IdentityGetSpaceMetaDataInputData data = (IdentityGetSpaceMetaDataInputData)indata;
        int errorCount = 0;
        ArrayOfTMetaDataSpace arrayData = new ArrayOfTMetaDataSpace();
        TReturnStatus globalStatus = null;
        TMetaDataSpace metadata = null;
        for (TSpaceToken token : data.getSpaceTokenArray().getTSpaceTokenArray()) {
            StorageSpaceData spaceData = null;
            try {
                spaceData = this.catalog.getStorageSpace(token);
            }
            catch (TransferObjectDecodingException e) {
                this.log.error("Unable to build StorageSpaceData from StorageSpaceTO. TransferObjectDecodingException: " + e.getMessage());
                metadata = this.createFailureMetadata(token, TStatusCode.SRM_INTERNAL_ERROR, "Error building space data from row DB data", data.getUser());
                ++errorCount;
                arrayData.addTMetaDataSpace(metadata);
                continue;
            }
            catch (DataAccessException e) {
                this.log.error("Unable to build get StorageSpaceTO. DataAccessException: " + e.getMessage());
                metadata = this.createFailureMetadata(token, TStatusCode.SRM_INTERNAL_ERROR, "Error retrieving row space token data from DB", data.getUser());
                ++errorCount;
                arrayData.addTMetaDataSpace(metadata);
                continue;
            }
            if (spaceData != null) {
                if (!spaceData.isInitialized()) {
                    this.log.warn("Unable to create a valid TMetaDataSpace for storage space token '" + token + "', the space is not initialized");
                    metadata = this.createFailureMetadata(token, TStatusCode.SRM_FAILURE, "Storage Space not initialized yet", data.getUser());
                    ++errorCount;
                } else {
                    try {
                        metadata = new TMetaDataSpace(spaceData);
                    }
                    catch (InvalidTMetaDataSpaceAttributeException e) {
                        this.log.error("Unable to build TMetaDataSpace from  StorageSpaceData. InvalidTMetaDataSpaceAttributeException: " + e.getMessage());
                        metadata = this.createFailureMetadata(token, TStatusCode.SRM_INTERNAL_ERROR, "Error building Storage Space Metadata from row data", data.getUser());
                        ++errorCount;
                    }
                    catch (InvalidTSizeAttributesException e) {
                        this.log.error("Unable to build TMetaDataSpace from  StorageSpaceData. InvalidTSizeAttributesException: " + e.getMessage());
                        metadata = this.createFailureMetadata(token, TStatusCode.SRM_INTERNAL_ERROR, "Error building Storage Space Metadata from row data", data.getUser());
                        ++errorCount;
                    }
                }
            } else {
                this.log.warn("getMetaDataSpace: unable to retrieve SpaceData for token: " + token);
                metadata = this.createFailureMetadata(token, TStatusCode.SRM_INVALID_REQUEST, "Space Token not found", data.getUser());
                ++errorCount;
            }
            arrayData.addTMetaDataSpace(metadata);
        }
        boolean requestSuccess = errorCount == 0;
        boolean requestFailure = errorCount == data.getSpaceTokenArray().size();
        try {
            if (requestSuccess) {
                globalStatus = new TReturnStatus(TStatusCode.SRM_SUCCESS, "");
                this.log.info(this.formatLogMessage(true, true, data.getUser(), null, data.getSpaceTokenArray(), globalStatus));
            } else if (requestFailure) {
                globalStatus = new TReturnStatus(TStatusCode.SRM_FAILURE, "No valid space tokens");
                this.log.info(this.formatLogMessage(false, true, data.getUser(), null, data.getSpaceTokenArray(), globalStatus));
            } else {
                globalStatus = new TReturnStatus(TStatusCode.SRM_PARTIAL_SUCCESS, "Check space tokens statuses for details");
                this.log.info(this.formatLogMessage(true, true, data.getUser(), null, data.getSpaceTokenArray(), globalStatus));
            }
        }
        catch (InvalidTReturnStatusAttributeException ex) {
            this.log.error("srmGetSpaceMetaData: Impossible is happen!!", (Throwable)ex);
            return new GetSpaceMetaDataOutputData();
        }
        this.log.debug("<GetSpaceMetaData > all value retrived...");
        GetSpaceMetaDataOutputData response = null;
        try {
            response = new GetSpaceMetaDataOutputData(globalStatus, arrayData);
        }
        catch (InvalidGetSpaceMetaDataOutputAttributeException e) {
            this.log.error("Unexpected InvalidGetSpaceMetaDataOutputAttributeException in execute : " + e.getMessage());
        }
        return response;
    }

    private TMetaDataSpace createFailureMetadata(TSpaceToken token, TStatusCode statusCode, String message, GridUserInterface user) {
        TMetaDataSpace metadata = TMetaDataSpace.makeEmpty();
        metadata.setSpaceToken(token);
        try {
            metadata.setStatus(new TReturnStatus(statusCode, message));
        }
        catch (InvalidTReturnStatusAttributeException e) {
            this.log.error("Unexpected InvalidTReturnStatusAttributeException in execute : " + e);
        }
        this.log.error(this.formatLogMessage(true, false, user, token, null, metadata.getStatus()));
        return metadata;
    }

    private void printRequestOutcome(TReturnStatus status, GetSpaceMetaDataInputData inputData) {
        if (inputData != null) {
            CommandHelper.printRequestOutcome(SRM_COMMAND, this.log, status, inputData);
        } else {
            CommandHelper.printRequestOutcome(SRM_COMMAND, this.log, status);
        }
    }

    private String formatLogMessage(boolean success, boolean globalStatus, GridUserInterface user, TSpaceToken token, ArrayOfTSpaceToken arrayOfToken, TReturnStatus status) {
        StringBuffer buf = new StringBuffer("srmGetSpaceMetaData: ");
        buf.append("<" + user + "> ");
        buf.append("Request for [spacetoken:");
        if (!globalStatus) {
            buf.append(token);
        } else {
            buf.append(arrayOfToken);
        }
        buf.append("] ");
        if (success) {
            buf.append("successfully done with:[status:");
        } else {
            buf.append("failed with:[status:");
        }
        buf.append(status);
        buf.append("]");
        return buf.toString();
    }
}

