/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.synchcall.command.discovery;

import it.grid.storm.Constants;
import it.grid.storm.config.Configuration;
import it.grid.storm.persistence.exceptions.DataAccessException;
import it.grid.storm.persistence.model.TapeRecallTO;
import it.grid.storm.srm.types.ArrayOfTExtraInfo;
import it.grid.storm.srm.types.InvalidTExtraInfoAttributeException;
import it.grid.storm.srm.types.TExtraInfo;
import it.grid.storm.synchcall.command.Command;
import it.grid.storm.synchcall.command.DiscoveryCommand;
import it.grid.storm.synchcall.data.DataHelper;
import it.grid.storm.synchcall.data.InputData;
import it.grid.storm.synchcall.data.OutputData;
import it.grid.storm.synchcall.data.discovery.PingInputData;
import it.grid.storm.synchcall.data.discovery.PingOutputData;
import it.grid.storm.tape.recalltable.TapeRecallCatalog;
import it.grid.storm.tape.recalltable.TapeRecallException;
import it.grid.storm.tape.recalltable.model.TapeRecallData;
import it.grid.storm.tape.recalltable.persistence.TapeRecallBuilder;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;

public class PingCommand
extends DiscoveryCommand
implements Command {
    private static final String KEY_ELEMENT_KEY = "key=";

    @Override
    public OutputData execute(InputData data) {
        PingOutputData outputData = new PingOutputData();
        PingInputData inputData = (PingInputData)data;
        outputData.setVersionInfo("StoRM - SRM Version 2.2");
        ArrayOfTExtraInfo extraInfoArray = new ArrayOfTExtraInfo();
        TExtraInfo otherInfo = null;
        String key = this.getKey(inputData.getAuthorizationID());
        Properties pingValues = this.loadProperties();
        if (pingValues.containsKey(key)) {
            for (Map.Entry<Object, Object> entry : pingValues.entrySet()) {
                try {
                    otherInfo = new TExtraInfo(entry.getKey().toString(), entry.getValue().toString());
                    this.log.debug("srmPing: Found the value for key='" + key + "' = '" + otherInfo + "'");
                }
                catch (InvalidTExtraInfoAttributeException ex) {
                    this.log.error("Invalid KEY requested in Ping.");
                    otherInfo = new TExtraInfo();
                }
                extraInfoArray.addTExtraInfo(otherInfo);
            }
        } else {
            extraInfoArray = this.manageSpecialKey(key);
        }
        outputData.setExtraInfoArray(extraInfoArray);
        String infoLogs = "srmPing: <" + DataHelper.getRequestor(inputData).toString() + ">" + "[AuthID:'" + inputData.getAuthorizationID() + "']" + "return values: [" + extraInfoArray + "]";
        this.log.info(infoLogs);
        return outputData;
    }

    private String getKey(String authorizationID) {
        if (authorizationID == null || authorizationID.contains(KEY_ELEMENT_KEY)) {
            return "";
        }
        String result = authorizationID.trim();
        if (result.substring(0, 4).equalsIgnoreCase(KEY_ELEMENT_KEY)) {
            result = result.substring(4);
        }
        this.log.debug("Retrieved KEY:'" + result + "' from AuthorizationID : '" + authorizationID + "'");
        return result;
    }

    private Properties loadProperties() {
        Properties properties = new Properties();
        Configuration config = Configuration.getInstance();
        String configurationPATH = config.namespaceConfigPath();
        String pingPropertiesFileName = config.getPingValuesPropertiesFilename();
        String propertiesFile = configurationPATH + File.separator + pingPropertiesFileName;
        if (new File(propertiesFile).exists()) {
            try {
                properties.load(new FileInputStream(propertiesFile));
                this.log.debug("srmPing: Loaded PING values from the properties file: '" + pingPropertiesFileName + "'");
            }
            catch (IOException e) {
                this.log.error("Error while readind Ping Values in file : '" + propertiesFile + "' EXCEPTION:" + e);
            }
        }
        properties.put(Constants.BE_VERSION.getKey(), Constants.BE_VERSION.getValue());
        properties.put(Constants.BE_OS_DISTRIBUTION.getKey(), Constants.BE_OS_DISTRIBUTION.getValue());
        this.log.debug("srmPing: Loaded NR " + properties.size() + " PING key/value couple.");
        return properties;
    }

    private ArrayOfTExtraInfo manageSpecialKey(String key) {
        ArrayOfTExtraInfo arrayResult = new ArrayOfTExtraInfo();
        SpecialKey specialKey = SpecialKey.fromString(key);
        switch (specialKey) {
            case ALL: {
                arrayResult = this.allKeys(PingCommand.extractParam(key));
                break;
            }
            case BE_OS_PLATFORM: {
                try {
                    arrayResult.addTExtraInfo(new TExtraInfo(key, Constants.BE_OS_PLATFORM.getValue()));
                }
                catch (InvalidTExtraInfoAttributeException e) {
                    this.log.warn("Really strange!");
                }
                break;
            }
            case BE_OS_KERNEL_RELEASE: {
                try {
                    arrayResult.addTExtraInfo(new TExtraInfo(key, Constants.BE_OS_KERNEL_RELEASE.getValue()));
                }
                catch (InvalidTExtraInfoAttributeException e) {
                    this.log.warn("Really strange!");
                }
                break;
            }
            case TEST_POST_NEW_TASK: {
                arrayResult = this.test_post_new_task(PingCommand.extractParam(key));
                break;
            }
            case TEST_PUT_NEW_STATUS: {
                arrayResult = this.test_put_new_status(PingCommand.extractParam(key));
                break;
            }
            case TEST_PUT_RETRY_VALUE: {
                arrayResult = this.test_put_retry_value(PingCommand.extractParam(key));
                break;
            }
            case TEST_TAKEOVER: {
                arrayResult = this.test_takeover(PingCommand.extractParam(key));
                break;
            }
            default: {
                TExtraInfo extraInfo = new TExtraInfo();
                try {
                    extraInfo = new TExtraInfo(SpecialKey.UNKNOWN.toString(), SpecialKey.UNKNOWN.getDescription() + ":'" + key + "'");
                }
                catch (InvalidTExtraInfoAttributeException e) {
                    this.log.warn("Really strange!");
                }
                arrayResult.addTExtraInfo(extraInfo);
                break;
            }
        }
        return arrayResult;
    }

    private ArrayOfTExtraInfo allKeys(String param) {
        ArrayOfTExtraInfo arrayResult = new ArrayOfTExtraInfo();
        Properties pingValues = this.loadProperties();
        TExtraInfo otherInfo = new TExtraInfo();
        this.log.debug("srmPing: Found a request to retrieve ALL key values. (NR:" + pingValues.size() + ")");
        Enumeration<?> e = pingValues.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String value = pingValues.getProperty(key);
            try {
                otherInfo = new TExtraInfo(key, value);
            }
            catch (InvalidTExtraInfoAttributeException ex) {
                this.log.error("Invalid KEY (key='" + key + "') requested in Ping.");
                otherInfo = new TExtraInfo();
            }
            arrayResult.addTExtraInfo(otherInfo);
        }
        return arrayResult;
    }

    private ArrayOfTExtraInfo test_post_new_task(String param) {
        ArrayOfTExtraInfo arrayResult = new ArrayOfTExtraInfo();
        try {
            TapeRecallData rtd = TapeRecallData.buildFromString(param);
            this.log.debug("RTD=" + rtd.toString());
            TapeRecallTO task = TapeRecallBuilder.buildFromPOST(rtd);
            try {
                new TapeRecallCatalog().insertNewTask(task);
            }
            catch (DataAccessException e) {
                String errorStr = "Unable to use RecallTable DB.";
                this.log.error(errorStr);
                return arrayResult;
            }
            URI newResource = URI.create("/" + task.getTaskId());
            this.log.debug("New task resource created: " + newResource);
        }
        catch (TapeRecallException e) {
            String errorStr = "Unable to use build the recall task from the provided string '" + param + "'";
            this.log.error(errorStr);
            return arrayResult;
        }
        return arrayResult;
    }

    private ArrayOfTExtraInfo test_put_new_status(String param) {
        ArrayOfTExtraInfo arrayResult = new ArrayOfTExtraInfo();
        return arrayResult;
    }

    private ArrayOfTExtraInfo test_put_retry_value(String param) {
        ArrayOfTExtraInfo arrayResult = new ArrayOfTExtraInfo();
        return arrayResult;
    }

    private ArrayOfTExtraInfo test_takeover(String param) {
        ArrayOfTExtraInfo arrayResult = new ArrayOfTExtraInfo();
        TExtraInfo otherInfo = new TExtraInfo();
        int numbOfTask = 1;
        try {
            ArrayList<TapeRecallTO> tasks = new TapeRecallCatalog().takeoverNTasksWithDoubles(numbOfTask);
            if (tasks != null) {
                for (TapeRecallTO tapeRecallTO : tasks) {
                    otherInfo = new TExtraInfo(tapeRecallTO.getTaskId().toString(), tapeRecallTO.toString());
                    arrayResult.addTExtraInfo(otherInfo);
                }
            }
        }
        catch (InvalidTExtraInfoAttributeException e) {
            e.printStackTrace();
        }
        return arrayResult;
    }

    private static String extractCmd(String key) {
        String cmd = key.trim().toLowerCase();
        int indexOfEqual = cmd.indexOf("=");
        if (indexOfEqual < 0) {
            indexOfEqual = cmd.length();
        }
        return cmd.substring(0, indexOfEqual);
    }

    private static String extractParam(String key) {
        String normalizedKey = key.trim().toLowerCase();
        String param = "";
        int equalIndex = normalizedKey.indexOf("=");
        if (equalIndex > 0) {
            param = normalizedKey.substring(equalIndex + 1);
        }
        return param;
    }

    public static void main(String[] arg) {
    }

    private static enum SpecialKey {
        ALL("all", "return all the pair <key,value> defined in properties"),
        BE_OS_PLATFORM(Constants.BE_OS_PLATFORM.getKey(), "returns the operating system platform"),
        BE_OS_KERNEL_RELEASE(Constants.BE_OS_KERNEL_RELEASE.getKey(), "returns the operating system kernel release"),
        TEST_TAKEOVER("take-over", "testing the take-over method"),
        TEST_POST_NEW_TASK("new-task", "testing the take-over method"),
        TEST_PUT_NEW_STATUS("new-status", "testing the take-over method"),
        TEST_PUT_RETRY_VALUE("retry-value", "testing the take-over method"),
        UNKNOWN("unknown", "Unable to manage the key");

        private final String operationName;
        private final String operationDescription;

        private SpecialKey(String opName, String opDescr) {
            this.operationName = opName;
            this.operationDescription = opDescr;
        }

        public String getDescription() {
            return this.operationDescription;
        }

        public static SpecialKey fromString(String keyStr) {
            String cmd = PingCommand.extractCmd(keyStr);
            for (SpecialKey keyValue : SpecialKey.values()) {
                if (!keyValue.toString().equalsIgnoreCase(cmd)) continue;
                return keyValue;
            }
            return UNKNOWN;
        }

        public String toString() {
            return this.operationName;
        }
    }
}

