/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.synchcall.command.directory;

import it.grid.storm.authz.AuthzDecision;
import it.grid.storm.authz.AuthzDirector;
import it.grid.storm.authz.SpaceAuthzInterface;
import it.grid.storm.authz.path.model.SRMFileRequest;
import it.grid.storm.authz.sa.model.SRMSpaceRequest;
import it.grid.storm.filesystem.LocalFile;
import it.grid.storm.namespace.NamespaceDirector;
import it.grid.storm.namespace.NamespaceInterface;
import it.grid.storm.namespace.StoRI;
import it.grid.storm.namespace.UnapprochableSurlException;
import it.grid.storm.namespace.VirtualFSInterface;
import it.grid.storm.space.SpaceHelper;
import it.grid.storm.srm.types.ArrayOfSURLs;
import it.grid.storm.srm.types.ArrayOfTSURLReturnStatus;
import it.grid.storm.srm.types.InvalidTReturnStatusAttributeException;
import it.grid.storm.srm.types.TRequestType;
import it.grid.storm.srm.types.TReturnStatus;
import it.grid.storm.srm.types.TSURL;
import it.grid.storm.srm.types.TSURLReturnStatus;
import it.grid.storm.srm.types.TSpaceToken;
import it.grid.storm.srm.types.TStatusCode;
import it.grid.storm.synchcall.command.Command;
import it.grid.storm.synchcall.command.CommandHelper;
import it.grid.storm.synchcall.data.DataHelper;
import it.grid.storm.synchcall.data.IdentityInputData;
import it.grid.storm.synchcall.data.InputData;
import it.grid.storm.synchcall.data.OutputData;
import it.grid.storm.synchcall.data.directory.RmInputData;
import it.grid.storm.synchcall.data.directory.RmOutputData;
import it.grid.storm.synchcall.surl.SurlStatusManager;
import it.grid.storm.synchcall.surl.UnknownSurlException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RmCommand
implements Command {
    private static final String SRM_COMMAND = "srmRm";
    private final Logger log = LoggerFactory.getLogger(RmCommand.class);
    private final String funcName = "srmRm";
    private final NamespaceInterface namespace = NamespaceDirector.getNamespace();

    @Override
    public OutputData execute(InputData inputDataGeneric) {
        this.log.debug("SrmRm: Dir Manager Rm start!");
        TReturnStatus globalStatus = null;
        RmOutputData outputData = new RmOutputData();
        RmInputData inputData = (RmInputData)inputDataGeneric;
        if (inputData == null || inputData != null && inputData.getSurlArray() == null) {
            this.log.debug("srmRm : Invalid input parameter specified");
            globalStatus = CommandHelper.buildStatus(TStatusCode.SRM_INVALID_REQUEST, "Invalid input parameters specified");
            this.printRequestOutcome(globalStatus, inputData);
            outputData.setStatus(globalStatus);
            outputData.setSurlStatus(null);
            return outputData;
        }
        ArrayOfSURLs surlArray = inputData.getSurlArray();
        ArrayOfTSURLReturnStatus arrayOfFileStatus = new ArrayOfTSURLReturnStatus();
        this.log.debug("srmRm: DirManager: Rm: SURLVectorSize: " + surlArray.size());
        for (TSURL surl : inputData.getSurlArray().getArrayList()) {
            this.log.debug("srmRm: DirManager: Rm: SURL: " + surl);
            TSURLReturnStatus fileStatus = new TSURLReturnStatus();
            fileStatus.setSurl(surl);
            TReturnStatus returnStatus = null;
            StoRI stori = null;
            if (!surl.isEmpty()) {
                try {
                    if (inputData instanceof IdentityInputData) {
                        try {
                            stori = this.namespace.resolveStoRIbySURL(surl, ((IdentityInputData)((Object)inputData)).getUser());
                        }
                        catch (UnapprochableSurlException e) {
                            this.log.info("Unable to build a stori for surl " + surl + " for user " + DataHelper.getRequestor(inputData) + " UnapprochableSurlException: " + e.getMessage());
                            globalStatus = CommandHelper.buildStatus(TStatusCode.SRM_INVALID_PATH, "Invalid SURL path specified");
                            this.printRequestOutcome(globalStatus, inputData);
                            outputData.setStatus(globalStatus);
                            outputData.setSurlStatus(null);
                            return outputData;
                        }
                    }
                    try {
                        stori = this.namespace.resolveStoRIbySURL(surl);
                    }
                    catch (UnapprochableSurlException e) {
                        this.log.info("Unable to build a stori for surl " + surl + " UnapprochableSurlException: " + e.getMessage());
                        globalStatus = CommandHelper.buildStatus(TStatusCode.SRM_INVALID_PATH, "Invalid SURL path specified");
                        this.printRequestOutcome(globalStatus, inputData);
                        outputData.setStatus(globalStatus);
                        outputData.setSurlStatus(null);
                        return outputData;
                    }
                }
                catch (IllegalArgumentException e) {
                    this.log.error("SrmRm: Unable to build StoRI by surl and user. IllegalArgumentException: " + e.getMessage());
                    globalStatus = CommandHelper.buildStatus(TStatusCode.SRM_INTERNAL_ERROR, "Unable to build a STORI from surl");
                    this.printRequestOutcome(globalStatus, inputData);
                    outputData.setStatus(globalStatus);
                    outputData.setSurlStatus(null);
                    return outputData;
                }
            } else {
                this.log.error("srmRm: Malformed SURL passed from converter ");
                returnStatus = CommandHelper.buildStatus(TStatusCode.SRM_INVALID_PATH, "Invalid SURL");
                this.printSurlOutcome(returnStatus, inputData, surl);
            }
            if (stori != null) {
                TSpaceToken token = new SpaceHelper().getTokenFromStoRI(this.log, stori);
                SpaceAuthzInterface spaceAuth = AuthzDirector.getSpaceAuthz(token);
                boolean isSpaceAuthorized = inputData instanceof IdentityInputData ? spaceAuth.authorize(((IdentityInputData)((Object)inputData)).getUser(), SRMSpaceRequest.RM) : spaceAuth.authorizeAnonymous(SRMSpaceRequest.RM);
                if (isSpaceAuthorized) {
                    AuthzDecision decision = inputData instanceof IdentityInputData ? AuthzDirector.getPathAuthz().authorize(((IdentityInputData)((Object)inputData)).getUser(), SRMFileRequest.RM, stori) : AuthzDirector.getPathAuthz().authorizeAnonymous(SRMFileRequest.RM, stori.getStFN());
                    if (decision.equals((Object)AuthzDecision.PERMIT)) {
                        VirtualFSInterface fs;
                        this.log.debug("srmRm: authorized for " + DataHelper.getRequestor(inputData) + " for file = " + stori.getPFN());
                        long fileSize = 0L;
                        if (stori.getLocalFile().exists()) {
                            fileSize = stori.getLocalFile().getExactSize();
                        }
                        try {
                            returnStatus = this.manageAuthorizedRM(surl, stori);
                        }
                        catch (IllegalArgumentException e) {
                            this.log.error("srmRm: IllegalArgumentException from manageAuthorizedRM: " + e);
                            globalStatus = CommandHelper.buildStatus(TStatusCode.SRM_INTERNAL_ERROR, "Error while performing an authorized rm");
                            this.printRequestOutcome(globalStatus, inputData);
                            outputData.setStatus(globalStatus);
                            outputData.setSurlStatus(null);
                            return outputData;
                        }
                        catch (UnknownSurlException e) {
                            this.log.error("srmRm: UnknownSurlException from manageAuthorizedRM: " + e);
                            returnStatus = CommandHelper.buildStatus(TStatusCode.SRM_INVALID_PATH, "The SURL is unknown");
                        }
                        if (returnStatus.isSRM_SUCCESS() && (fs = stori.getVirtualFileSystem()) != null && fs.getProperties().isOnlineSpaceLimited()) {
                            if (inputData instanceof IdentityInputData) {
                                new SpaceHelper().increaseFreeSpaceForSA(this.log, SRM_COMMAND, ((IdentityInputData)((Object)inputData)).getUser(), surl, fileSize);
                            } else {
                                new SpaceHelper().increaseFreeSpaceForSA(this.log, SRM_COMMAND, surl, fileSize);
                            }
                        }
                    } else {
                        this.log.debug("srmRm: User not authorized to delete the file AuthzDecision is :'" + (Object)((Object)decision) + "')");
                        returnStatus = CommandHelper.buildStatus(TStatusCode.SRM_AUTHORIZATION_FAILURE, "User is not authorized to delete the file");
                    }
                } else {
                    this.log.debug("srmRm: User not authorized to perform srmRm request on the storage area: " + token);
                    returnStatus = CommandHelper.buildStatus(TStatusCode.SRM_AUTHORIZATION_FAILURE, "User not authorized to perform srmRm request on the storage area");
                }
            }
            this.printSurlOutcome(returnStatus, inputData, surl);
            fileStatus.setStatus(returnStatus);
            arrayOfFileStatus.addTSurlReturnStatus(fileStatus);
        }
        boolean atLeastOneSuccess = false;
        boolean atLeastOneFailure = false;
        for (TSURLReturnStatus status : arrayOfFileStatus.getArray()) {
            if (atLeastOneFailure && atLeastOneSuccess) break;
            if (status.getStatus().isSRM_SUCCESS()) {
                atLeastOneSuccess = true;
                continue;
            }
            atLeastOneFailure = true;
        }
        globalStatus = atLeastOneSuccess ? (atLeastOneFailure ? CommandHelper.buildStatus(TStatusCode.SRM_PARTIAL_SUCCESS, "Some files were not removed") : CommandHelper.buildStatus(TStatusCode.SRM_SUCCESS, "All files removed")) : CommandHelper.buildStatus(TStatusCode.SRM_FAILURE, "No files removed");
        this.printRequestOutcome(globalStatus, inputData);
        outputData.setStatus(globalStatus);
        outputData.setSurlStatus(arrayOfFileStatus);
        return outputData;
    }

    private TReturnStatus manageAuthorizedRM(TSURL surl, StoRI stori) throws IllegalArgumentException, UnknownSurlException {
        TReturnStatus returnStatus = null;
        String explanation = "";
        TStatusCode statusCode = TStatusCode.EMPTY;
        LocalFile file = stori.getLocalFile();
        if (!file.exists()) {
            statusCode = TStatusCode.SRM_INVALID_PATH;
            explanation = "File does not exist";
        } else if (file.isDirectory()) {
            statusCode = TStatusCode.SRM_INVALID_PATH;
            explanation = "The specified file is a directory. Not removed";
        } else {
            SurlStatusManager.checkAndUpdateStatus(TRequestType.PREPARE_TO_PUT, surl, TStatusCode.SRM_SPACE_AVAILABLE, TStatusCode.SRM_ABORTED, "File Removed by a SrmRm()");
            boolean fileRemoved = this.removeTarget(file);
            if (!fileRemoved) {
                statusCode = TStatusCode.SRM_AUTHORIZATION_FAILURE;
                explanation = "File not removed, permission denied.";
            } else {
                statusCode = TStatusCode.SRM_SUCCESS;
                explanation = "File removed";
            }
        }
        try {
            returnStatus = new TReturnStatus(statusCode, explanation);
        }
        catch (InvalidTReturnStatusAttributeException ex1) {
            this.log.debug("srmRm: Error creating returnStatus " + ex1);
        }
        return returnStatus;
    }

    private boolean removeTarget(LocalFile file) {
        boolean result = false;
        boolean canDelete = true;
        if (canDelete) {
            result = file.delete();
        } else {
            this.log.debug("srmRm : Unable to delete the file '" + file + "'. Permission denied.");
        }
        return result;
    }

    private void printSurlOutcome(TReturnStatus status, RmInputData inputData, TSURL surl) {
        CommandHelper.printSurlOutcome(SRM_COMMAND, this.log, status, inputData, surl);
    }

    private void printRequestOutcome(TReturnStatus status, RmInputData inputData) {
        if (inputData != null) {
            if (inputData.getSurlArray() != null) {
                CommandHelper.printRequestOutcome(SRM_COMMAND, this.log, status, (InputData)inputData, inputData.getSurlArray().asStringList());
            } else {
                CommandHelper.printRequestOutcome(SRM_COMMAND, this.log, status, inputData);
            }
        } else {
            CommandHelper.printRequestOutcome(SRM_COMMAND, this.log, status);
        }
    }
}

