/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.synchcall.command.directory;

import it.grid.storm.acl.AclManagerFSAndHTTPS;
import it.grid.storm.authz.AuthzDecision;
import it.grid.storm.authz.AuthzDirector;
import it.grid.storm.authz.SpaceAuthzInterface;
import it.grid.storm.authz.path.model.SRMFileRequest;
import it.grid.storm.authz.sa.model.SRMSpaceRequest;
import it.grid.storm.config.Configuration;
import it.grid.storm.filesystem.FilesystemPermission;
import it.grid.storm.filesystem.LocalFile;
import it.grid.storm.griduser.CannotMapUserException;
import it.grid.storm.griduser.GridUserInterface;
import it.grid.storm.griduser.LocalUser;
import it.grid.storm.namespace.NamespaceDirector;
import it.grid.storm.namespace.NamespaceInterface;
import it.grid.storm.namespace.StoRI;
import it.grid.storm.namespace.UnapprochableSurlException;
import it.grid.storm.namespace.VirtualFSInterface;
import it.grid.storm.namespace.model.ACLEntry;
import it.grid.storm.namespace.model.DefaultACL;
import it.grid.storm.space.SpaceHelper;
import it.grid.storm.srm.types.TReturnStatus;
import it.grid.storm.srm.types.TSURL;
import it.grid.storm.srm.types.TSpaceToken;
import it.grid.storm.srm.types.TStatusCode;
import it.grid.storm.synchcall.command.Command;
import it.grid.storm.synchcall.command.CommandHelper;
import it.grid.storm.synchcall.command.DirectoryCommand;
import it.grid.storm.synchcall.data.DataHelper;
import it.grid.storm.synchcall.data.IdentityInputData;
import it.grid.storm.synchcall.data.InputData;
import it.grid.storm.synchcall.data.OutputData;
import it.grid.storm.synchcall.data.directory.MkdirInputData;
import it.grid.storm.synchcall.data.directory.MkdirOutputData;
import java.util.Arrays;

public class MkdirCommand
extends DirectoryCommand
implements Command {
    private static final String SRM_COMMAND = "SrmMkdir";
    private final NamespaceInterface namespace = NamespaceDirector.getNamespace();

    @Override
    public OutputData execute(InputData data) {
        this.log.debug("SrmMkdir: Start execution.");
        TReturnStatus returnStatus = null;
        MkdirInputData inputData = (MkdirInputData)data;
        MkdirOutputData outData = null;
        if (inputData == null || inputData != null && inputData.getSurl() == null) {
            returnStatus = CommandHelper.buildStatus(TStatusCode.SRM_FAILURE, "Invalid parameter specified.");
            this.printRequestOutcome(returnStatus, inputData);
            outData = new MkdirOutputData(returnStatus);
            return outData;
        }
        TSURL surl = inputData.getSurl();
        StoRI stori = null;
        if (!surl.isEmpty()) {
            try {
                if (inputData instanceof IdentityInputData) {
                    try {
                        stori = this.namespace.resolveStoRIbySURL(surl, ((IdentityInputData)((Object)inputData)).getUser());
                    }
                    catch (UnapprochableSurlException e) {
                        this.log.info("Unable to build a stori for surl " + surl + " for user " + DataHelper.getRequestor(inputData) + " UnapprochableSurlException: " + e.getMessage());
                        returnStatus = CommandHelper.buildStatus(TStatusCode.SRM_INVALID_PATH, "Invalid SURL path specified");
                        this.printRequestOutcome(returnStatus, inputData);
                        outData = new MkdirOutputData(returnStatus);
                        return outData;
                    }
                }
                try {
                    stori = this.namespace.resolveStoRIbySURL(surl);
                }
                catch (UnapprochableSurlException e) {
                    this.log.info("Unable to build a stori for surl " + surl + " UnapprochableSurlException: " + e.getMessage());
                    returnStatus = CommandHelper.buildStatus(TStatusCode.SRM_INVALID_PATH, "Invalid SURL path specified");
                    this.printRequestOutcome(returnStatus, inputData);
                    outData = new MkdirOutputData(returnStatus);
                    return outData;
                }
            }
            catch (IllegalArgumentException e) {
                this.log.error("Unable to get surl's stori. IllegalArgumentException: " + e.getMessage());
                returnStatus = CommandHelper.buildStatus(TStatusCode.SRM_INTERNAL_ERROR, "Unable to get StoRI for surl");
                this.printRequestOutcome(returnStatus, inputData);
                outData = new MkdirOutputData(returnStatus);
                return outData;
            }
        } else {
            returnStatus = CommandHelper.buildStatus(TStatusCode.SRM_INVALID_PATH, "Invalid SURL specified!");
            this.printRequestOutcome(returnStatus, inputData);
            outData = new MkdirOutputData(returnStatus);
            return outData;
        }
        TSpaceToken token = new SpaceHelper().getTokenFromStoRI(this.log, stori);
        SpaceAuthzInterface spaceAuth = AuthzDirector.getSpaceAuthz(token);
        boolean isSpaceAuthorized = inputData instanceof IdentityInputData ? spaceAuth.authorize(((IdentityInputData)((Object)inputData)).getUser(), SRMSpaceRequest.MD) : spaceAuth.authorizeAnonymous(SRMSpaceRequest.MD);
        if (!isSpaceAuthorized) {
            this.log.debug("srmMkdir: User not authorized to perform srmMkdir request on the storage area: " + token);
            returnStatus = CommandHelper.buildStatus(TStatusCode.SRM_AUTHORIZATION_FAILURE, ": User not authorized to perform srmMkdir request on the storage area: " + token);
            this.printRequestOutcome(returnStatus, inputData);
            outData = new MkdirOutputData(returnStatus);
            return outData;
        }
        AuthzDecision decision = inputData instanceof IdentityInputData ? AuthzDirector.getPathAuthz().authorize(((IdentityInputData)((Object)inputData)).getUser(), SRMFileRequest.MD, stori) : AuthzDirector.getPathAuthz().authorizeAnonymous(SRMFileRequest.MD, stori.getStFN());
        if (decision.equals((Object)AuthzDecision.PERMIT)) {
            this.log.debug("srmMkdir authorized for " + DataHelper.getRequestor(inputData) + " for directory = " + stori.getPFN());
            returnStatus = this.manageAuthorizedMKDIR(stori, data);
        } else {
            returnStatus = CommandHelper.buildStatus(TStatusCode.SRM_AUTHORIZATION_FAILURE, "User is not authorized to make a new directory");
        }
        this.printRequestOutcome(returnStatus, inputData);
        outData = new MkdirOutputData(returnStatus);
        return outData;
    }

    private TReturnStatus manageAuthorizedMKDIR(StoRI stori, InputData data) {
        TReturnStatus returnStatus = this.createFolder(stori.getLocalFile());
        if (returnStatus.getStatusCode().equals((Object)TStatusCode.SRM_SUCCESS)) {
            this.manageAcl(stori, data, returnStatus);
        }
        return returnStatus;
    }

    private TReturnStatus createFolder(LocalFile file) {
        LocalFile parent = file.getParentFile();
        if (parent != null) {
            this.log.debug("Mkdir : Parent of '" + file + "' exists");
            if (!file.exists()) {
                if (file.mkdir()) {
                    this.log.debug("SrmMkdir: Request success!");
                    return CommandHelper.buildStatus(TStatusCode.SRM_SUCCESS, "Directory created with success");
                }
                if (file.exists()) {
                    this.log.debug("SrmMkdir: Request fails because it specifies an existent file or directory.");
                    return CommandHelper.buildStatus(TStatusCode.SRM_DUPLICATION_ERROR, "The given SURL identifies an existing file or directory");
                }
                this.log.debug("SrmMkdir: Request fails because the path is invalid.");
                return CommandHelper.buildStatus(TStatusCode.SRM_INVALID_PATH, "Invalid path");
            }
            if (file.isDirectory()) {
                this.log.debug("SrmMkdir: Request fails because it specifies an existent directory.");
                return CommandHelper.buildStatus(TStatusCode.SRM_DUPLICATION_ERROR, "Directory specified exists!");
            }
            this.log.debug("SrmMkdir: Request fails because the path specified is an existent file.");
            return CommandHelper.buildStatus(TStatusCode.SRM_INVALID_PATH, "Path specified exists as a file");
        }
        this.log.debug("SrmMkdir: Request fails because it specifies an invalid parent directory.");
        return CommandHelper.buildStatus(TStatusCode.SRM_INVALID_PATH, "Parent directory does not exists. Recursive directory creation Not Allowed");
    }

    private void manageAcl(StoRI stori, InputData inputData, TReturnStatus returnStatus) {
        FilesystemPermission permission = Configuration.getInstance().getEnableWritePermOnDirectory() ? FilesystemPermission.ListTraverseWrite : FilesystemPermission.ListTraverse;
        if (inputData instanceof IdentityInputData) {
            this.setAcl(((IdentityInputData)inputData).getUser(), stori.getLocalFile(), stori.hasJustInTimeACLs(), permission, returnStatus);
            this.manageDefaultACL(stori, permission, returnStatus);
        } else {
            this.manageDefaultACL(stori, permission, returnStatus);
            this.setHttpsServiceAcl(stori.getLocalFile(), permission, returnStatus);
        }
    }

    private void setAcl(GridUserInterface user, LocalFile file, boolean hasJiTACL, FilesystemPermission permission, TReturnStatus returnStatus) {
        this.log.debug("SrmMkdir: Adding ACL for directory created : '" + file + "'  " + "group:g_name:--x");
        if (!hasJiTACL) {
            try {
                if (user.getLocalUser() == null) {
                    this.log.warn("SrmMkdir: Unable to setting up the ACL. LocalUser il null!");
                    returnStatus.extendExplaination("Unable to setting up the ACL");
                } else {
                    try {
                        AclManagerFSAndHTTPS.getInstance().grantGroupPermission(file, user.getLocalUser(), permission);
                    }
                    catch (IllegalArgumentException e) {
                        this.log.error("Unable to grant user permission on the created folder. IllegalArgumentException: " + e.getMessage());
                        returnStatus.extendExplaination("Unable to grant group permission on the created folder");
                    }
                }
            }
            catch (CannotMapUserException e) {
                this.log.warn("SrmMkdir: Unable to setting up the ACL.CannotMapUserException: " + e.getMessage());
                returnStatus.extendExplaination("Unable to setting up the ACL");
            }
        }
    }

    private void manageDefaultACL(StoRI stori, FilesystemPermission permission, TReturnStatus returnStatus) {
        VirtualFSInterface vfs = stori.getVirtualFileSystem();
        DefaultACL dacl = vfs.getCapabilities().getDefaultACL();
        if (dacl != null && !dacl.isEmpty()) {
            for (ACLEntry ace : dacl.getACL()) {
                this.log.debug("Adding DefaultACL for the gid: " + ace.getGroupID() + " with permission: " + ace.getFilePermissionString());
                LocalUser user = new LocalUser(ace.getGroupID(), ace.getGroupID());
                try {
                    AclManagerFSAndHTTPS.getInstance().grantGroupPermission(stori.getLocalFile(), user, permission);
                }
                catch (IllegalArgumentException e) {
                    this.log.error("Unable to grant group permission on the created folder to user " + user + " . IllegalArgumentException: " + e.getMessage());
                    returnStatus.extendExplaination("Errors setting default acls");
                }
            }
        }
    }

    private void setHttpsServiceAcl(LocalFile file, FilesystemPermission permission, TReturnStatus returnStatus) {
        this.log.debug("SrmMkdir: Adding default ACL for directory created : '" + file + "'  " + permission);
        try {
            AclManagerFSAndHTTPS.getInstance().grantHttpsServiceGroupPermission(file, permission);
        }
        catch (IllegalArgumentException e) {
            this.log.error("Unable to grant user permission on the created folder. IllegalArgumentException: " + e.getMessage());
            returnStatus.extendExplaination("Unable to grant group permission on the created folder");
        }
    }

    private void printRequestOutcome(TReturnStatus status, MkdirInputData inputData) {
        if (inputData != null) {
            if (inputData.getSurl() != null) {
                CommandHelper.printRequestOutcome(SRM_COMMAND, this.log, status, (InputData)inputData, Arrays.asList(inputData.getSurl().toString()));
            } else {
                CommandHelper.printRequestOutcome(SRM_COMMAND, this.log, status, inputData);
            }
        } else {
            CommandHelper.printRequestOutcome(SRM_COMMAND, this.log, status);
        }
    }
}

