/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.synchcall.command.datatransfer;

import it.grid.storm.ea.StormEA;
import it.grid.storm.namespace.NamespaceDirector;
import it.grid.storm.namespace.StoRI;
import it.grid.storm.namespace.UnapprochableSurlException;
import it.grid.storm.srm.types.ArrayOfSURLs;
import it.grid.storm.srm.types.ArrayOfTSURLReturnStatus;
import it.grid.storm.srm.types.TRequestToken;
import it.grid.storm.srm.types.TReturnStatus;
import it.grid.storm.srm.types.TSURL;
import it.grid.storm.srm.types.TSURLReturnStatus;
import it.grid.storm.srm.types.TStatusCode;
import it.grid.storm.synchcall.command.Command;
import it.grid.storm.synchcall.command.CommandHelper;
import it.grid.storm.synchcall.command.DataTransferCommand;
import it.grid.storm.synchcall.command.SurlStatusCommandHelper;
import it.grid.storm.synchcall.command.datatransfer.RequestUnknownException;
import it.grid.storm.synchcall.data.InputData;
import it.grid.storm.synchcall.data.OutputData;
import it.grid.storm.synchcall.data.datatransfer.ManageFileTransferFilesInputData;
import it.grid.storm.synchcall.data.datatransfer.ManageFileTransferOutputData;
import it.grid.storm.synchcall.data.datatransfer.ManageFileTransferRequestFilesInputData;
import it.grid.storm.synchcall.data.datatransfer.ManageFileTransferRequestInputData;
import it.grid.storm.synchcall.surl.ExpiredTokenException;
import it.grid.storm.synchcall.surl.SurlStatusManager;
import it.grid.storm.synchcall.surl.UnknownSurlException;
import it.grid.storm.synchcall.surl.UnknownTokenException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReleaseFilesCommand
extends DataTransferCommand
implements Command {
    private static final Logger log = LoggerFactory.getLogger(ReleaseFilesCommand.class);
    private static final String SRM_COMMAND = "srmReleaseFiles";

    @Override
    public OutputData execute(InputData inputData) {
        Map<TSURL, TReturnStatus> surlStastuses;
        log.debug("Started ReleaseFiles function");
        if (inputData == null) {
            log.error("ReleaseFiles: Invalid input parameters specified: inputData=" + inputData);
            ManageFileTransferOutputData outputData = new ManageFileTransferOutputData(CommandHelper.buildStatus(TStatusCode.SRM_INTERNAL_ERROR, "Empty request parametes"));
            SurlStatusCommandHelper.printRequestOutcome(outputData.getReturnStatus(), inputData, SRM_COMMAND);
            return outputData;
        }
        if (!(inputData instanceof ManageFileTransferRequestFilesInputData || inputData instanceof ManageFileTransferFilesInputData || inputData instanceof ManageFileTransferRequestInputData)) {
            throw new IllegalArgumentException("Unable to execute the task. Wrong input argumenbt type: " + inputData.getClass());
        }
        try {
            surlStastuses = SurlStatusCommandHelper.getSurlsStatus(inputData);
        }
        catch (IllegalArgumentException e) {
            log.warn("Unexpected IllegalArgumentException in getSurlsStatus: " + e);
            ManageFileTransferOutputData outputData = new ManageFileTransferOutputData(CommandHelper.buildStatus(TStatusCode.SRM_FAILURE, "Internal error. Unablr to determine current SURL status"));
            SurlStatusCommandHelper.printRequestOutcome(outputData.getReturnStatus(), inputData, SRM_COMMAND);
            return outputData;
        }
        catch (RequestUnknownException e) {
            log.info("No surls status available. RequestUnknownException: " + e.getMessage());
            ManageFileTransferOutputData outputData = new ManageFileTransferOutputData(CommandHelper.buildStatus(TStatusCode.SRM_INVALID_REQUEST, "Invalid request token and surls"));
            SurlStatusCommandHelper.printRequestOutcome(outputData.getReturnStatus(), inputData, SRM_COMMAND);
            return outputData;
        }
        catch (UnknownTokenException e) {
            log.info("No surls status available. UnknownTokenException: " + e.getMessage());
            ManageFileTransferOutputData outputData = new ManageFileTransferOutputData(CommandHelper.buildStatus(TStatusCode.SRM_INVALID_REQUEST, "Invalid request token"));
            SurlStatusCommandHelper.printRequestOutcome(outputData.getReturnStatus(), inputData, SRM_COMMAND);
            return outputData;
        }
        catch (ExpiredTokenException e) {
            log.info("The request is expired: ExpiredTokenException: " + e.getMessage());
            ManageFileTransferOutputData outputData = new ManageFileTransferOutputData(CommandHelper.buildStatus(TStatusCode.SRM_REQUEST_TIMED_OUT, "Request expired"));
            SurlStatusCommandHelper.printRequestOutcome(outputData.getReturnStatus(), inputData, SRM_COMMAND);
            return outputData;
        }
        if (surlStastuses.isEmpty()) {
            TReturnStatus returnStatus;
            log.info("No SURLs found in the DB. Request failed");
            if (inputData instanceof ManageFileTransferRequestFilesInputData) {
                returnStatus = CommandHelper.buildStatus(TStatusCode.SRM_INVALID_REQUEST, "Invalid request token, no match with provided surls");
            } else if (inputData instanceof ManageFileTransferRequestInputData) {
                returnStatus = CommandHelper.buildStatus(TStatusCode.SRM_INVALID_REQUEST, "Invalid request token");
            } else if (inputData instanceof ManageFileTransferFilesInputData) {
                returnStatus = CommandHelper.buildStatus(TStatusCode.SRM_INVALID_REQUEST, "None of the specified SURLs was found");
            } else {
                throw new IllegalStateException("Unexpected InputData received: " + inputData.getClass());
            }
            SurlStatusCommandHelper.printRequestOutcome(returnStatus, inputData, SRM_COMMAND);
            return new ManageFileTransferOutputData(returnStatus);
        }
        ArrayOfTSURLReturnStatus surlReturnStatuses = inputData instanceof ManageFileTransferFilesInputData ? this.prepareSurlsReturnStatus(surlStastuses, ((ManageFileTransferFilesInputData)inputData).getArrayOfSURLs()) : this.prepareSurlsReturnStatus(surlStastuses);
        List<TSURL> surlToRelease = this.extractSurlToRelease(surlReturnStatuses);
        if (!surlToRelease.isEmpty()) {
            try {
                if (inputData instanceof ManageFileTransferRequestInputData) {
                    this.expireSurls(surlToRelease, ((ManageFileTransferRequestInputData)inputData).getRequestToken());
                } else {
                    this.expireSurls(surlToRelease);
                }
            }
            catch (IllegalArgumentException e) {
                log.warn("Unexpected IllegalArgumentException in expireSurls: " + e);
                ManageFileTransferOutputData outputData = new ManageFileTransferOutputData(CommandHelper.buildStatus(TStatusCode.SRM_INTERNAL_ERROR, "Internal error. Unable to transit SURLs to SRM_RELEASED status"));
                SurlStatusCommandHelper.printRequestOutcome(outputData.getReturnStatus(), inputData, SRM_COMMAND);
                return outputData;
            }
            catch (UnknownTokenException e) {
                log.warn("Unexpected RequestUnknownException in expireSurls: " + e);
                ManageFileTransferOutputData outputData = new ManageFileTransferOutputData(CommandHelper.buildStatus(TStatusCode.SRM_INTERNAL_ERROR, "Internal error. Unable to transit SURLs to SRM_RELEASED status"));
                SurlStatusCommandHelper.printRequestOutcome(outputData.getReturnStatus(), inputData, SRM_COMMAND);
                return outputData;
            }
            catch (ExpiredTokenException e) {
                log.info("The request is expired: ExpiredTokenException: " + e.getMessage());
                ManageFileTransferOutputData outputData = new ManageFileTransferOutputData(CommandHelper.buildStatus(TStatusCode.SRM_REQUEST_TIMED_OUT, "Request expired"));
                SurlStatusCommandHelper.printRequestOutcome(outputData.getReturnStatus(), inputData, SRM_COMMAND);
                return outputData;
            }
            catch (UnknownSurlException e) {
                log.warn("Unexpected UnknownSurlException in expireSurls: " + e);
                ManageFileTransferOutputData outputData = new ManageFileTransferOutputData(CommandHelper.buildStatus(TStatusCode.SRM_INTERNAL_ERROR, "Internal error. Unable to transit SURLs to SRM_RELEASED status"));
                SurlStatusCommandHelper.printRequestOutcome(outputData.getReturnStatus(), inputData, SRM_COMMAND);
                return outputData;
            }
        }
        this.removePinneExtendedAttribute(surlToRelease);
        boolean atLeastOneReleased = false;
        boolean atLeastOneFailure = false;
        for (TSURLReturnStatus returnStatus : surlReturnStatuses.getArray()) {
            this.printSurlOutcome(returnStatus, inputData);
            if (returnStatus.getStatus().getStatusCode().equals((Object)TStatusCode.SRM_RELEASED)) {
                atLeastOneReleased = true;
                continue;
            }
            atLeastOneFailure = true;
        }
        TReturnStatus returnStatus = atLeastOneReleased ? (atLeastOneFailure ? CommandHelper.buildStatus(TStatusCode.SRM_PARTIAL_SUCCESS, "Check files status for details") : CommandHelper.buildStatus(TStatusCode.SRM_SUCCESS, "Files released")) : CommandHelper.buildStatus(TStatusCode.SRM_FAILURE, "No files released");
        SurlStatusCommandHelper.printRequestOutcome(returnStatus, inputData, SRM_COMMAND);
        log.debug("End of ReleaseFiles function");
        return new ManageFileTransferOutputData(returnStatus, surlReturnStatuses);
    }

    private ArrayOfTSURLReturnStatus prepareSurlsReturnStatus(Map<TSURL, TReturnStatus> surlStastuses) {
        ArrayOfTSURLReturnStatus surlReturnStatuses = new ArrayOfTSURLReturnStatus(surlStastuses.size());
        for (Map.Entry<TSURL, TReturnStatus> surlStatus : surlStastuses.entrySet()) {
            TReturnStatus returnStatus = this.prepareStatus(surlStatus.getValue());
            surlReturnStatuses.addTSurlReturnStatus(CommandHelper.buildStatus(surlStatus.getKey(), returnStatus));
        }
        return surlReturnStatuses;
    }

    private ArrayOfTSURLReturnStatus prepareSurlsReturnStatus(Map<TSURL, TReturnStatus> surlStastuses, ArrayOfSURLs arrayOfUserSURLs) {
        ArrayOfTSURLReturnStatus surlReturnStatuses = new ArrayOfTSURLReturnStatus(surlStastuses.size());
        for (TSURL surl : arrayOfUserSURLs.getArrayList()) {
            TReturnStatus status = surlStastuses.get(surl);
            TReturnStatus returnStatus = status != null ? this.prepareStatus(status) : CommandHelper.buildStatus(TStatusCode.SRM_INVALID_PATH, "Invalid SURL");
            surlReturnStatuses.addTSurlReturnStatus(CommandHelper.buildStatus(surl, returnStatus));
        }
        return surlReturnStatuses;
    }

    private TReturnStatus prepareStatus(TReturnStatus status) {
        if (TStatusCode.SRM_FILE_PINNED.equals((Object)status.getStatusCode()) || TStatusCode.SRM_SUCCESS.equals((Object)status.getStatusCode())) {
            return CommandHelper.buildStatus(TStatusCode.SRM_RELEASED, "Released");
        }
        return CommandHelper.buildStatus(TStatusCode.SRM_INVALID_PATH, "Not released because it is not pinned");
    }

    private List<TSURL> extractSurlToRelease(ArrayOfTSURLReturnStatus surlReturnStatuses) {
        LinkedList<TSURL> surlToRelease = new LinkedList<TSURL>();
        for (TSURLReturnStatus returnStatus : surlReturnStatuses.getArray()) {
            if (!TStatusCode.SRM_RELEASED.equals((Object)returnStatus.getStatus().getStatusCode())) continue;
            surlToRelease.add(returnStatus.getSurl());
        }
        return surlToRelease;
    }

    private void expireSurls(List<TSURL> surlToRelease, TRequestToken requestToken) throws IllegalArgumentException, UnknownTokenException, ExpiredTokenException, UnknownSurlException {
        if (surlToRelease == null || surlToRelease.isEmpty() || requestToken == null) {
            throw new IllegalArgumentException("unable to expire Surls, null arguments: surlToRelease=" + surlToRelease + " requestToken=" + requestToken);
        }
        SurlStatusManager.checkAndUpdateStatus(requestToken, surlToRelease, TStatusCode.SRM_FILE_PINNED, TStatusCode.SRM_RELEASED);
        SurlStatusManager.checkAndUpdateStatus(requestToken, surlToRelease, TStatusCode.SRM_SUCCESS, TStatusCode.SRM_RELEASED);
    }

    private void expireSurls(List<TSURL> surlToRelease) throws IllegalArgumentException, UnknownTokenException, ExpiredTokenException, UnknownSurlException {
        if (surlToRelease == null) {
            throw new IllegalArgumentException("unable to expire Surls, null arguments: surlToRelease=" + surlToRelease);
        }
        for (TSURL surl : surlToRelease) {
            Map<TRequestToken, TReturnStatus> tokenStatusMap = SurlStatusManager.getSurlCurrentStatuses(surl);
            for (Map.Entry<TRequestToken, TReturnStatus> tokenStatus : tokenStatusMap.entrySet()) {
                if (TStatusCode.SRM_FILE_PINNED.equals((Object)tokenStatus.getValue().getStatusCode())) {
                    SurlStatusManager.checkAndUpdateStatus(tokenStatus.getKey(), surlToRelease, TStatusCode.SRM_FILE_PINNED, TStatusCode.SRM_RELEASED);
                    continue;
                }
                if (!TStatusCode.SRM_SUCCESS.equals((Object)tokenStatus.getValue().getStatusCode())) continue;
                SurlStatusManager.checkAndUpdateStatus(tokenStatus.getKey(), surlToRelease, TStatusCode.SRM_SUCCESS, TStatusCode.SRM_RELEASED);
            }
        }
    }

    private void removePinneExtendedAttribute(List<TSURL> surlToRelease) {
        for (TSURL surl : surlToRelease) {
            StoRI stori;
            try {
                stori = NamespaceDirector.getNamespace().resolveStoRIbySURL(surl);
            }
            catch (UnapprochableSurlException e) {
                log.warn("UNEXPECTED: Unable to build a stori for surl " + surl + " UnapprochableSurlException: " + e.getMessage());
                continue;
            }
            if (!stori.getVirtualFileSystem().getStorageClassType().isTapeEnabled()) continue;
            StormEA.removePinned(stori.getAbsolutePath());
        }
    }

    private void printSurlOutcome(TSURLReturnStatus surlStatus, InputData inputData) {
        CommandHelper.printSurlOutcome(SRM_COMMAND, log, surlStatus.getStatus(), inputData, surlStatus.getSurl());
    }
}

