/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.synchcall.command.datatransfer;

import it.grid.storm.catalogs.VolatileAndJiTCatalog;
import it.grid.storm.common.types.PFN;
import it.grid.storm.ea.StormEA;
import it.grid.storm.filesystem.LocalFile;
import it.grid.storm.griduser.CannotMapUserException;
import it.grid.storm.griduser.GridUserInterface;
import it.grid.storm.griduser.LocalUser;
import it.grid.storm.namespace.NamespaceDirector;
import it.grid.storm.namespace.StoRI;
import it.grid.storm.namespace.UnapprochableSurlException;
import it.grid.storm.namespace.VirtualFSInterface;
import it.grid.storm.space.SpaceHelper;
import it.grid.storm.srm.types.ArrayOfTSURLReturnStatus;
import it.grid.storm.srm.types.InvalidTReturnStatusAttributeException;
import it.grid.storm.srm.types.InvalidTSURLReturnStatusAttributeException;
import it.grid.storm.srm.types.TRequestToken;
import it.grid.storm.srm.types.TReturnStatus;
import it.grid.storm.srm.types.TSURL;
import it.grid.storm.srm.types.TSURLReturnStatus;
import it.grid.storm.srm.types.TStatusCode;
import it.grid.storm.synchcall.command.Command;
import it.grid.storm.synchcall.command.CommandHelper;
import it.grid.storm.synchcall.command.DataTransferCommand;
import it.grid.storm.synchcall.command.datatransfer.RequestUnknownException;
import it.grid.storm.synchcall.data.IdentityInputData;
import it.grid.storm.synchcall.data.InputData;
import it.grid.storm.synchcall.data.OutputData;
import it.grid.storm.synchcall.data.datatransfer.ManageFileTransferOutputData;
import it.grid.storm.synchcall.data.datatransfer.ManageFileTransferRequestFilesInputData;
import it.grid.storm.synchcall.surl.ExpiredTokenException;
import it.grid.storm.synchcall.surl.SurlStatusManager;
import it.grid.storm.synchcall.surl.UnknownSurlException;
import it.grid.storm.synchcall.surl.UnknownTokenException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PutDoneCommand
extends DataTransferCommand
implements Command {
    private static final Logger log = LoggerFactory.getLogger(PutDoneCommand.class);
    private static final String funcName = "PutDone: ";
    private static final Set<String> lockedSurls = new HashSet<String>();
    private static final Object lock = new Object();
    private static final TReturnStatus anotherPutDoneActiveReturnStatus = CommandHelper.buildStatus(TStatusCode.SRM_FAILURE, "There is another PutDone in execution on this SURL.");
    private static final String SRM_COMMAND = "srmPutDone";

    @Override
    public OutputData execute(InputData absData) {
        ArrayOfTSURLReturnStatus surlsStatuses;
        ManageFileTransferRequestFilesInputData inputData = (ManageFileTransferRequestFilesInputData)absData;
        TReturnStatus globalStatus = null;
        log.debug("PutDone: Started.");
        if (inputData == null || inputData.getRequestToken() == null || inputData.getArrayOfSURLs() == null || inputData.getArrayOfSURLs().size() < 1) {
            log.error("PutDone: Invalid input parameter specified");
            globalStatus = CommandHelper.buildStatus(TStatusCode.SRM_INVALID_REQUEST, "Missing mandatory parameters");
            if (inputData == null) {
                log.error("srmPutDone: Requestfailed with [status: " + globalStatus + "]");
            } else {
                PutDoneCommand.printRequestOutcome(globalStatus, inputData);
            }
            return new ManageFileTransferOutputData(globalStatus);
        }
        TRequestToken requestToken = inputData.getRequestToken();
        ArrayList<TSURL> listOfSURLs = inputData.getArrayOfSURLs().getArrayList();
        try {
            surlsStatuses = this.loadSURLsStatus(requestToken, listOfSURLs);
        }
        catch (IllegalArgumentException e) {
            log.error("PutDone: Unexpected IllegalArgumentException: " + e.getMessage());
            globalStatus = CommandHelper.buildStatus(TStatusCode.SRM_INTERNAL_ERROR, "Request Failed, retry.");
            PutDoneCommand.printRequestOutcome(globalStatus, inputData);
            return new ManageFileTransferOutputData(globalStatus);
        }
        catch (RequestUnknownException e) {
            log.info("PutDone: Invalid request token and surl. RequestUnknownException: " + e.getMessage());
            globalStatus = CommandHelper.buildStatus(TStatusCode.SRM_INVALID_REQUEST, "Invalid request token and surls");
            PutDoneCommand.printRequestOutcome(globalStatus, inputData);
            return new ManageFileTransferOutputData(globalStatus);
        }
        catch (UnknownTokenException e) {
            log.info("PutDone: Invalid request token. UnknownTokenException: " + e.getMessage());
            globalStatus = CommandHelper.buildStatus(TStatusCode.SRM_INVALID_REQUEST, "Invalid request token");
            PutDoneCommand.printRequestOutcome(globalStatus, inputData);
            return new ManageFileTransferOutputData(globalStatus);
        }
        catch (ExpiredTokenException e) {
            log.info("PutDone: The request is expired: ExpiredTokenException: " + e.getMessage());
            globalStatus = CommandHelper.buildStatus(TStatusCode.SRM_REQUEST_TIMED_OUT, "Request expired");
            PutDoneCommand.printRequestOutcome(globalStatus, inputData);
            return new ManageFileTransferOutputData(globalStatus);
        }
        LinkedList<TSURL> spaceAvailableSURLs = new LinkedList<TSURL>();
        boolean atLeastOneSuccess = false;
        boolean atLeastOneFailure = false;
        boolean atLeastOneAborted = false;
        for (TSURLReturnStatus surlStatus : surlsStatuses.getArray()) {
            TReturnStatus newStatus;
            TReturnStatus currentStatus = surlStatus.getStatus();
            switch (currentStatus.getStatusCode()) {
                case SRM_SPACE_AVAILABLE: {
                    if (PutDoneCommand.lockSurl(surlStatus.getSurl())) {
                        spaceAvailableSURLs.add(surlStatus.getSurl());
                        newStatus = CommandHelper.buildStatus(TStatusCode.SRM_SUCCESS, "");
                        atLeastOneSuccess = true;
                        break;
                    }
                    newStatus = anotherPutDoneActiveReturnStatus;
                    break;
                }
                case SRM_SUCCESS: {
                    newStatus = CommandHelper.buildStatus(TStatusCode.SRM_DUPLICATION_ERROR, "");
                    atLeastOneFailure = true;
                    break;
                }
                case SRM_ABORTED: {
                    newStatus = CommandHelper.buildStatus(TStatusCode.SRM_INVALID_PATH, "PtP status for this SURL is SRM_ABORTED");
                    atLeastOneAborted = true;
                    break;
                }
                default: {
                    newStatus = CommandHelper.buildStatus(TStatusCode.SRM_FAILURE, "Check StatusOfPutRequest for more information");
                    atLeastOneFailure = true;
                }
            }
            surlsStatuses.updateStatus(surlStatus, newStatus);
        }
        GridUserInterface user = inputData instanceof IdentityInputData ? ((IdentityInputData)((Object)inputData)).getUser() : null;
        PutDoneCommand.executePutDone(spaceAvailableSURLs, user);
        if (!spaceAvailableSURLs.isEmpty()) {
            try {
                SurlStatusManager.checkAndUpdateStatus(requestToken, spaceAvailableSURLs, TStatusCode.SRM_SPACE_AVAILABLE, TStatusCode.SRM_SUCCESS);
            }
            catch (IllegalArgumentException e) {
                log.error("PutDone: Unexpected IllegalArgumentException: " + e.getMessage());
                globalStatus = CommandHelper.buildStatus(TStatusCode.SRM_INTERNAL_ERROR, "Request Failed, retry.");
                PutDoneCommand.printRequestOutcome(globalStatus, inputData);
                return new ManageFileTransferOutputData(globalStatus);
            }
            catch (UnknownTokenException e) {
                log.error("PutDone: Unexpected UnknownTokenException: " + e.getMessage());
                globalStatus = CommandHelper.buildStatus(TStatusCode.SRM_INTERNAL_ERROR, "Request Failed,. Unexpected UnknownSurlException in checkAndUpdateStatus");
                PutDoneCommand.printRequestOutcome(globalStatus, inputData);
                return new ManageFileTransferOutputData(globalStatus);
            }
            catch (ExpiredTokenException e) {
                log.info("PutDone: The request is expired: ExpiredTokenException: " + e.getMessage());
                globalStatus = CommandHelper.buildStatus(TStatusCode.SRM_REQUEST_TIMED_OUT, "Request expired");
                PutDoneCommand.printRequestOutcome(globalStatus, inputData);
                return new ManageFileTransferOutputData(globalStatus);
            }
            catch (UnknownSurlException e) {
                log.error("PutDone: Unexpected UnknownSurlException: " + e.getMessage());
                globalStatus = CommandHelper.buildStatus(TStatusCode.SRM_INTERNAL_ERROR, "Request Failed. Unexpected UnknownSurlException in checkAndUpdateStatus");
                PutDoneCommand.printRequestOutcome(globalStatus, inputData);
                return new ManageFileTransferOutputData(globalStatus);
            }
        }
        for (TSURL surl : spaceAvailableSURLs) {
            if (surl == null) continue;
            PutDoneCommand.unlockSurl(surl);
        }
        log.debug("Number of SURLs locked: " + lockedSurls.size());
        if (atLeastOneSuccess) {
            globalStatus = !atLeastOneFailure && !atLeastOneAborted ? CommandHelper.buildStatus(TStatusCode.SRM_SUCCESS, "All file requests are successfully completed") : CommandHelper.buildStatus(TStatusCode.SRM_PARTIAL_SUCCESS, "Details are on the file statuses");
        } else if (atLeastOneFailure) {
            globalStatus = !atLeastOneAborted ? CommandHelper.buildStatus(TStatusCode.SRM_FAILURE, "All file requests are failed") : CommandHelper.buildStatus(TStatusCode.SRM_FAILURE, "Some file requests are failed, the others are aborted");
        } else if (atLeastOneAborted) {
            globalStatus = CommandHelper.buildStatus(TStatusCode.SRM_ABORTED, "Request " + requestToken.toString());
        } else {
            log.error("None of the surls is success, failed or aborted, Unexpeced! SurlStatus = " + surlsStatuses.getArray());
            globalStatus = CommandHelper.buildStatus(TStatusCode.SRM_INTERNAL_ERROR, "Request Failed, no surl status recognized, retry.");
        }
        log.debug("PutDone: Finished with status: " + globalStatus.toString());
        PutDoneCommand.printRequestOutcome(globalStatus, inputData);
        return new ManageFileTransferOutputData(globalStatus, surlsStatuses);
    }

    private static void printRequestOutcome(TReturnStatus status, ManageFileTransferRequestFilesInputData inputData) {
        if (inputData != null) {
            if (inputData.getArrayOfSURLs() != null) {
                if (inputData.getRequestToken() != null) {
                    CommandHelper.printRequestOutcome(SRM_COMMAND, log, status, inputData, inputData.getRequestToken(), inputData.getArrayOfSURLs().asStringList());
                } else {
                    CommandHelper.printRequestOutcome(SRM_COMMAND, log, status, (InputData)inputData, inputData.getArrayOfSURLs().asStringList());
                }
            } else if (inputData.getRequestToken() != null) {
                CommandHelper.printRequestOutcome(SRM_COMMAND, log, status, (InputData)inputData, inputData.getRequestToken());
            } else {
                CommandHelper.printRequestOutcome(SRM_COMMAND, log, status, inputData);
            }
        } else {
            CommandHelper.printRequestOutcome(SRM_COMMAND, log, status);
        }
    }

    private ArrayOfTSURLReturnStatus loadSURLsStatus(TRequestToken requestToken, List<TSURL> inputSURLs) throws IllegalArgumentException, RequestUnknownException, UnknownTokenException, ExpiredTokenException {
        ArrayOfTSURLReturnStatus returnStatuses = new ArrayOfTSURLReturnStatus(inputSURLs.size());
        Map<TSURL, TReturnStatus> surlsStatuses = SurlStatusManager.getSurlsStatus(requestToken, inputSURLs);
        if (surlsStatuses.isEmpty()) {
            log.info("PutDone: No one of the requested surls found for the provided token");
            throw new RequestUnknownException("No one of the requested surls found for the provided token");
        }
        TReturnStatus status = null;
        for (TSURL surl : inputSURLs) {
            TSURLReturnStatus surlRetStatus;
            log.debug("PutDone: Checking SURL " + surl);
            if (surlsStatuses.containsKey(surl)) {
                log.debug("PutDone: SURL '" + surl + "' found!");
                status = surlsStatuses.get(surl);
            } else {
                log.debug("PutDone: SURL '" + surl + "' NOT found in the DB!");
                try {
                    status = new TReturnStatus(TStatusCode.SRM_INVALID_PATH, "SURL does not refer to an existing file for the specified request token");
                }
                catch (InvalidTReturnStatusAttributeException e) {
                    throw new IllegalStateException("Unexpected InvalidTReturnStatusAttributeException in building TReturnStatus: " + e.getMessage());
                }
            }
            try {
                surlRetStatus = new TSURLReturnStatus(surl, status);
            }
            catch (InvalidTSURLReturnStatusAttributeException e) {
                throw new IllegalStateException("Unexpected InvalidTSURLReturnStatusAttributeException in building TReturnStatus: " + e.getMessage());
            }
            returnStatuses.addTSurlReturnStatus(surlRetStatus);
        }
        return returnStatuses;
    }

    public static void executePutDone(List<TSURL> spaceAvailableSURLs, GridUserInterface user) {
        for (TSURL surl : spaceAvailableSURLs) {
            VirtualFSInterface fs;
            StoRI stori;
            block18: {
                if (surl == null) continue;
                log.debug("Executing PutDone for SURL: " + surl.getSURLString());
                stori = null;
                if (user == null) {
                    try {
                        stori = NamespaceDirector.getNamespace().resolveStoRIbySURL(surl);
                        break block18;
                    }
                    catch (UnapprochableSurlException e) {
                        log.info("Unable to build a stori for surl " + surl + " UnapprochableSurlException: " + e.getMessage());
                        continue;
                    }
                }
                try {
                    stori = NamespaceDirector.getNamespace().resolveStoRIbySURL(surl, user);
                }
                catch (IllegalArgumentException e) {
                    log.error("PutDone: unable to build STORI from surl=" + surl + " user=" + user);
                    continue;
                }
                catch (UnapprochableSurlException e) {
                    log.info("Unable to build a stori for surl " + surl + " for user " + user + " UnapprochableSurlException: " + e.getMessage());
                    continue;
                }
            }
            if (VolatileAndJiTCatalog.getInstance().exists(stori.getPFN())) {
                try {
                    VolatileAndJiTCatalog.getInstance().setStartTime(stori.getPFN(), Calendar.getInstance());
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (stori.hasJustInTimeACLs()) {
                log.debug("PutDone: JiT case, removing ACEs on SURL: " + surl.toString());
                List<StoRI> storiParentsList = stori.getParents();
                ArrayList<PFN> pfnParentsList = new ArrayList<PFN>(storiParentsList.size());
                for (StoRI parentStoRI : storiParentsList) {
                    pfnParentsList.add(parentStoRI.getPFN());
                }
                LocalUser localUser = null;
                try {
                    if (user != null) {
                        localUser = user.getLocalUser();
                    }
                }
                catch (CannotMapUserException e) {
                    log.warn("PutDone: Unable to get the local user for user " + user + ". CannotMapUserException: " + e.getMessage());
                }
                if (localUser != null) {
                    VolatileAndJiTCatalog.getInstance().expirePutJiTs(stori.getPFN(), localUser);
                } else {
                    VolatileAndJiTCatalog.getInstance().removeAllJiTsOn(stori.getPFN());
                }
            }
            LocalFile localFile = stori.getLocalFile();
            if (stori.getVirtualFileSystem().getStorageClassType().isTapeEnabled()) {
                String fileAbosolutePath = localFile.getAbsolutePath();
                StormEA.removePinned(fileAbosolutePath);
                StormEA.setPremigrate(fileAbosolutePath);
            }
            if ((fs = stori.getVirtualFileSystem()) == null || !fs.getProperties().isOnlineSpaceLimited()) continue;
            SpaceHelper sh = new SpaceHelper();
            sh.decreaseFreeSpaceForSA(log, funcName, user, surl);
        }
    }

    public static void executeImplicitPutDone(List<TSURL> spaceAvailableSURLs) {
        for (TSURL surl : spaceAvailableSURLs) {
            if (surl == null || !PutDoneCommand.lockSurl(surl)) continue;
            ArrayList<TSURL> elementList = new ArrayList<TSURL>(1);
            elementList.add(surl);
            PutDoneCommand.executePutDone(elementList, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean lockSurl(TSURL surl) {
        Object object = lock;
        synchronized (object) {
            return lockedSurls.add(surl.getSURLString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void unlockSurl(TSURL surl) {
        Object object = lock;
        synchronized (object) {
            lockedSurls.remove(surl.getSURLString());
        }
    }
}

