/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.synchcall.command.datatransfer;

import it.grid.storm.catalogs.AnonymousPtPData;
import it.grid.storm.catalogs.PtPChunkCatalog;
import it.grid.storm.catalogs.PtPPersistentChunkData;
import it.grid.storm.catalogs.RequestSummaryCatalog;
import it.grid.storm.config.Configuration;
import it.grid.storm.filesystem.LocalFile;
import it.grid.storm.namespace.NamespaceDirector;
import it.grid.storm.namespace.NamespaceInterface;
import it.grid.storm.namespace.StoRI;
import it.grid.storm.namespace.UnapprochableSurlException;
import it.grid.storm.srm.types.ArrayOfSURLs;
import it.grid.storm.srm.types.ArrayOfTSURLReturnStatus;
import it.grid.storm.srm.types.InvalidTReturnStatusAttributeException;
import it.grid.storm.srm.types.TRequestToken;
import it.grid.storm.srm.types.TRequestType;
import it.grid.storm.srm.types.TReturnStatus;
import it.grid.storm.srm.types.TSURL;
import it.grid.storm.srm.types.TSURLReturnStatus;
import it.grid.storm.srm.types.TSpaceToken;
import it.grid.storm.srm.types.TStatusCode;
import it.grid.storm.synchcall.command.datatransfer.AbortExecutorInterface;
import it.grid.storm.synchcall.command.space.ReserveSpaceCommand;
import it.grid.storm.synchcall.data.DataHelper;
import it.grid.storm.synchcall.data.IdentityInputData;
import it.grid.storm.synchcall.data.datatransfer.AbortFilesInputData;
import it.grid.storm.synchcall.data.datatransfer.AbortGeneralOutputData;
import it.grid.storm.synchcall.data.datatransfer.AbortInputData;
import it.grid.storm.synchcall.surl.ExpiredTokenException;
import it.grid.storm.synchcall.surl.SurlStatusManager;
import it.grid.storm.synchcall.surl.UnknownSurlException;
import it.grid.storm.synchcall.surl.UnknownTokenException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PtPAbortExecutor
implements AbortExecutorInterface {
    private static final Logger log = LoggerFactory.getLogger(PtPAbortExecutor.class);
    static Configuration config = Configuration.getInstance();
    private static int maxLoopTimes = config.getMaxLoop();
    private NamespaceInterface namespace;

    @Override
    public AbortGeneralOutputData doIt(AbortInputData inputData) {
        Map<TSURL, TReturnStatus> surlStatusMap;
        this.namespace = NamespaceDirector.getNamespace();
        AbortGeneralOutputData outputData = new AbortGeneralOutputData();
        ArrayOfTSURLReturnStatus arrayOfTSurlRetStatus = new ArrayOfTSURLReturnStatus();
        TReturnStatus globalStatus = null;
        log.debug("srmAbortRequest: Start PtPAbortExecutor...");
        try {
            surlStatusMap = SurlStatusManager.getSurlsStatus(inputData.getRequestToken());
        }
        catch (IllegalArgumentException e) {
            log.error("Unexpected IllegalArgumentException during SurlStatusManager.getSurlsStatus: " + e);
            throw new IllegalStateException("Unexpected IllegalArgumentException: " + e.getMessage());
        }
        catch (UnknownTokenException e) {
            log.debug("PtPAbortExecutor: Request - Invalid request token");
            globalStatus = this.manageStatus(TStatusCode.SRM_INVALID_REQUEST, "Invalid request token");
            outputData.setReturnStatus(globalStatus);
            outputData.setArrayOfFileStatuses(null);
            log.info("srmAbortRequest: <" + DataHelper.getRequestor(inputData) + "> Request for [token:" + inputData.getRequestToken() + "] failed with [status: " + globalStatus + "]");
            return outputData;
        }
        catch (ExpiredTokenException e) {
            log.info("The request is expired: ExpiredTokenException: " + e.getMessage());
            globalStatus = this.manageStatus(TStatusCode.SRM_REQUEST_TIMED_OUT, "Request expired");
            outputData.setReturnStatus(globalStatus);
            outputData.setArrayOfFileStatuses(null);
            log.info("srmAbortRequest: <" + DataHelper.getRequestor(inputData) + "> Request for [token:" + inputData.getRequestToken() + "] failed with [status: " + globalStatus + "]");
            return outputData;
        }
        if (surlStatusMap.isEmpty()) {
            log.debug("PtPAbortExecutor: Request - Invalid request token");
            globalStatus = this.manageStatus(TStatusCode.SRM_INVALID_REQUEST, "Invalid request token");
            outputData.setReturnStatus(globalStatus);
            outputData.setArrayOfFileStatuses(null);
            log.info("srmAbortRequest: <" + DataHelper.getRequestor(inputData) + "> Request for [token:" + inputData.getRequestToken() + "] failed with [status: " + globalStatus + "]");
            return outputData;
        }
        if (inputData.getType().equals((Object)AbortInputData.AbortType.ABORT_FILES)) {
            log.debug("srmAbortFiles: PtPAbortExecutor: Case of AbortFile request. Purge Chunks with SurlArray.");
            ArrayList<TSURL> surlList = this.extractSurlArray(inputData).getArrayList();
            surlStatusMap.keySet().retainAll(surlList);
            if (!surlStatusMap.keySet().containsAll(surlList)) {
                for (TSURL surl : surlList) {
                    if (surlStatusMap.containsKey(surl)) continue;
                    log.debug("srmAbortFiles: Abort: SURL NOT found, invalid Chunk!Set TSURLReturnStatus");
                    TSURLReturnStatus surlReturnStatus = new TSURLReturnStatus();
                    surlReturnStatus.setSurl(surl);
                    surlReturnStatus.setStatus(this.manageStatus(TStatusCode.SRM_INVALID_PATH, "SURL specified does not referes to this request token."));
                    log.info("srmAbortFiles: <" + DataHelper.getRequestor(inputData) + "> Request for [token:" + inputData.getRequestToken() + "] for [SURL:" + surl + "] failed  with [status: " + surlReturnStatus.getStatus() + "]");
                    arrayOfTSurlRetStatus.addTSurlReturnStatus(surlReturnStatus);
                }
            }
        }
        if (surlStatusMap.isEmpty()) {
            log.debug("Abort Request - No surl specified associated to request token");
            globalStatus = this.manageStatus(TStatusCode.SRM_FAILURE, "All surl specified does not referes to the request token.");
            outputData.setReturnStatus(globalStatus);
            outputData.setArrayOfFileStatuses(arrayOfTSurlRetStatus);
            log.info("srmAbortRequest: <" + DataHelper.getRequestor(inputData) + "> Request for [token:" + inputData.getRequestToken() + "] failed with [status: " + globalStatus + "]");
            return outputData;
        }
        int chunkAborted = 0;
        int counter = 0;
        int errorCount = 0;
        int totalSize = surlStatusMap.size();
        while (chunkAborted < totalSize && counter < maxLoopTimes) {
            ++counter;
            Iterator<Map.Entry<TSURL, TReturnStatus>> iterator = surlStatusMap.entrySet().iterator();
            int numOfSurl = 0;
            while (iterator.hasNext()) {
                Map.Entry<TSURL, TReturnStatus> surlStatus = iterator.next();
                ++numOfSurl;
                if (surlStatus.getValue().getStatusCode().equals((Object)TStatusCode.SRM_REQUEST_INPROGRESS)) continue;
                log.debug("PtPAbortExecutor: PtPChunk not in IN_PROGRESS state. Ready for Abort.");
                TSURLReturnStatus surlReturnStatus = new TSURLReturnStatus();
                log.debug("PtPAbortExecutor: start Phase(3)");
                if (surlStatus.getValue().getStatusCode().equals((Object)TStatusCode.SRM_ABORTED)) {
                    log.debug("PtPAbortExecutor: CHUNK already aborted!");
                    surlReturnStatus.setSurl(surlStatus.getKey());
                    surlReturnStatus.setStatus(this.manageStatus(TStatusCode.SRM_SUCCESS, "File request successfully aborted."));
                } else {
                    log.debug("PtPAbortExecutor:CHUNK to abort.");
                    surlReturnStatus = this.manageAuthorizedAbort(inputData.getRequestToken(), surlStatus.getKey(), surlStatus.getValue(), inputData);
                }
                iterator.remove();
                if (surlReturnStatus.getStatus().getStatusCode().equals((Object)TStatusCode.SRM_SUCCESS)) {
                    log.info("srmAbortFiles: <" + DataHelper.getRequestor(inputData) + "> Request for [token:" + inputData.getRequestToken() + "] for SURL " + numOfSurl + " of " + totalSize + " [SURL:" + surlStatus.getKey() + "] successfully done  with [status: " + surlReturnStatus.getStatus() + "]");
                } else {
                    log.info("srmAbortFiles: <" + DataHelper.getRequestor(inputData) + "> Request for [token:" + inputData.getRequestToken() + "] for SURL " + numOfSurl + " of " + totalSize + " [SURL:" + surlStatus.getKey() + "] failed with [status: " + surlReturnStatus.getStatus() + "]");
                    ++errorCount;
                }
                arrayOfTSurlRetStatus.addTSurlReturnStatus(surlReturnStatus);
                ++chunkAborted;
            }
            if (chunkAborted >= totalSize) continue;
            log.debug("PtPAbortExecutor: Wait for some time...");
            log.debug("Abort: I'm waiting...");
            try {
                long numMillisecondsToSleep = 100L;
                Thread.sleep(numMillisecondsToSleep);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            log.debug("PtPAbortExecutor: Wake up! It's time to work...");
            log.debug("srmAbortRequest: PtPAbortExecutor: refresh surl status");
            try {
                surlStatusMap = SurlStatusManager.getSurlsStatus(inputData.getRequestToken(), surlStatusMap.keySet());
            }
            catch (IllegalArgumentException e) {
                log.error("Unexpected IllegalArgumentException during SurlStatusManager.getSurlsStatus: " + e);
                throw new IllegalStateException("Unexpected IllegalArgumentException: " + e.getMessage());
            }
            catch (UnknownTokenException e) {
                log.debug("PtPAbortExecutor: Request - Invalid request token, probably it is expired");
                globalStatus = this.manageStatus(TStatusCode.SRM_INVALID_REQUEST, "Expired request token");
                outputData.setReturnStatus(globalStatus);
                outputData.setArrayOfFileStatuses(null);
                log.info("srmAbortRequest: <" + DataHelper.getRequestor(inputData) + "> Request for [token:" + inputData.getRequestToken() + "] failed with [status: " + globalStatus + "]");
                return outputData;
            }
            catch (ExpiredTokenException e) {
                log.info("The request is expired: ExpiredTokenException: " + e.getMessage());
                globalStatus = this.manageStatus(TStatusCode.SRM_REQUEST_TIMED_OUT, "Request expired");
                outputData.setReturnStatus(globalStatus);
                outputData.setArrayOfFileStatuses(null);
                log.info("srmAbortRequest: <" + DataHelper.getRequestor(inputData) + "> Request for [token:" + inputData.getRequestToken() + "] failed with [status: " + globalStatus + "]");
                return outputData;
            }
            log.debug("srmAbortRequest: PtPAbortExecutor: refresh done.");
        }
        if (chunkAborted < totalSize) {
            log.debug("Abort: Timeout exceeded.");
            globalStatus = this.manageStatus(TStatusCode.SRM_INTERNAL_ERROR, "TimeOut for abort execution exceeded.");
            outputData.setReturnStatus(globalStatus);
            outputData.setArrayOfFileStatuses(arrayOfTSurlRetStatus);
            log.error("srmAbortFiles: <" + DataHelper.getRequestor(inputData) + "> Request for [token:" + inputData.getRequestToken() + "]" + (inputData.getType().equals((Object)AbortInputData.AbortType.ABORT_FILES) ? " for [SURL:" + this.extractSurlArray(inputData) + "]" : "") + " completed with [status: " + globalStatus + "]");
            return outputData;
        }
        if (errorCount == totalSize) {
            globalStatus = this.manageStatus(TStatusCode.SRM_FAILURE, "Abort failed.");
        } else if (errorCount > 0) {
            globalStatus = inputData.getType().equals((Object)AbortInputData.AbortType.ABORT_REQUEST) ? this.manageStatus(TStatusCode.SRM_FAILURE, "Some chunks failed.") : this.manageStatus(TStatusCode.SRM_PARTIAL_SUCCESS, "Some chunks failed.");
        } else {
            globalStatus = this.manageStatus(TStatusCode.SRM_SUCCESS, "Abort request completed.");
            if (inputData.getType().equals((Object)AbortInputData.AbortType.ABORT_REQUEST)) {
                TReturnStatus requestStatus = this.manageStatus(TStatusCode.SRM_ABORTED, "Request Aborted.");
                RequestSummaryCatalog.getInstance().updateGlobalStatus(inputData.getRequestToken(), requestStatus);
            }
        }
        outputData.setArrayOfFileStatuses(arrayOfTSurlRetStatus);
        outputData.setReturnStatus(globalStatus);
        log.info("srmAbortFiles: <" + DataHelper.getRequestor(inputData) + "> Request for [token:" + inputData.getRequestToken() + "]" + (inputData.getType().equals((Object)AbortInputData.AbortType.ABORT_FILES) ? " for [SURL:" + this.extractSurlArray(inputData) + "]" : "") + " completed with [status: " + globalStatus + "]");
        return outputData;
    }

    private ArrayOfSURLs extractSurlArray(AbortInputData inputData) {
        switch (inputData.getType()) {
            case ABORT_REQUEST: {
                throw new IllegalStateException("Unable to get SurlArray from an ABORT_REQUEST input data");
            }
            case ABORT_FILES: {
                return ((AbortFilesInputData)inputData).getArrayOfSURLs();
            }
        }
        throw new IllegalStateException("Received an unknown AbortType: " + (Object)((Object)inputData.getType()));
    }

    private TReturnStatus manageStatus(TStatusCode statusCode, String explanation) {
        TReturnStatus returnStatus = null;
        try {
            returnStatus = new TReturnStatus(statusCode, explanation);
        }
        catch (InvalidTReturnStatusAttributeException ex1) {
            log.debug("AbortExecutor : Error creating returnStatus " + ex1);
        }
        return returnStatus;
    }

    private TSURLReturnStatus manageAuthorizedAbort(TRequestToken token, TSURL surl, TReturnStatus status, AbortInputData inputData) {
        boolean failure = false;
        this.namespace = NamespaceDirector.getNamespace();
        log.debug("PtPAbortExecutor: Phase(3) RollBack start.");
        TSURLReturnStatus surlReturnStatus = new TSURLReturnStatus();
        StoRI stori = null;
        boolean res = false;
        if (TStatusCode.SRM_SPACE_AVAILABLE.equals((Object)status.getStatusCode()) || TStatusCode.SRM_REQUEST_QUEUED.equals((Object)status.getStatusCode())) {
            LocalFile fileToRemove;
            block33: {
                log.debug("PtPAbortExecutor: The Chunk is in a VALID state for the RollBack action!");
                if (!SurlStatusManager.isPersisted(token).isEmpty()) {
                    Collection<PtPPersistentChunkData> chunksData = PtPChunkCatalog.getInstance().lookup(token);
                    AnonymousPtPData chunkData = null;
                    for (PtPPersistentChunkData surlChunkData : chunksData) {
                        if (!surlChunkData.getSURL().equals(surl)) continue;
                        chunkData = surlChunkData;
                        break;
                    }
                    if (chunkData == null) {
                        throw new IllegalStateException("Unexpected condition. token " + token + " stored on the db but no associated surl " + surl + " found");
                    }
                    if (!chunkData.getSpaceToken().isEmpty()) {
                        TReturnStatus reserveSpaceStatus;
                        TSpaceToken sToken = chunkData.getSpaceToken();
                        ReserveSpaceCommand rexec = new ReserveSpaceCommand();
                        log.debug("PtPAbortExecutor: Space token found.");
                        if (chunkData.expectedFileSize().isEmpty()) {
                            reserveSpaceStatus = rexec.resetReservation(sToken);
                            if (!reserveSpaceStatus.getStatusCode().equals((Object)TStatusCode.SRM_SUCCESS)) {
                                failure = true;
                            }
                        } else {
                            reserveSpaceStatus = rexec.updateReservation(chunkData.getSpaceToken(), chunkData.expectedFileSize(), chunkData.getSURL());
                            if (!reserveSpaceStatus.getStatusCode().equals((Object)TStatusCode.SRM_SUCCESS)) {
                                failure = true;
                            }
                        }
                    }
                }
                log.debug("PtPAbortExecutor: No space token found.");
                log.debug("PtPAbortExecutor: Start removing file from the file system...");
                fileToRemove = null;
                if (!surl.isEmpty()) {
                    try {
                        if (inputData instanceof IdentityInputData) {
                            try {
                                stori = this.namespace.resolveStoRIbySURL(surl, ((IdentityInputData)((Object)inputData)).getUser());
                                break block33;
                            }
                            catch (UnapprochableSurlException e) {
                                failure = true;
                                log.info("Unable to build a stori for surl " + surl + " for user " + DataHelper.getRequestor(inputData) + " UnapprochableSurlException: " + e.getMessage());
                                try {
                                    SurlStatusManager.updateStatus(TRequestType.PREPARE_TO_PUT, surl, TStatusCode.SRM_INVALID_PATH, "Invalid SURL path specified");
                                }
                                catch (UnknownSurlException e1) {
                                    log.error("Unexpected UnknownSurlException in SurlStatusManager.updateStatus: ", (Throwable)e1);
                                }
                                surlReturnStatus.setSurl(surl);
                                surlReturnStatus.setStatus(this.manageStatus(TStatusCode.SRM_INVALID_PATH, "Invalid SURL path specified"));
                                return surlReturnStatus;
                            }
                        }
                        try {
                            stori = this.namespace.resolveStoRIbySURL(surl);
                        }
                        catch (UnapprochableSurlException e) {
                            failure = true;
                            log.info("Unable to build a stori for surl " + surl + " UnapprochableSurlException: " + e.getMessage());
                            try {
                                SurlStatusManager.updateStatus(TRequestType.PREPARE_TO_PUT, surl, TStatusCode.SRM_INVALID_PATH, "Invalid SURL path specified");
                            }
                            catch (UnknownSurlException e1) {
                                log.error("Unexpected UnknownSurlException in SurlStatusManager.updateStatus: ", (Throwable)e1);
                            }
                            surlReturnStatus.setSurl(surl);
                            surlReturnStatus.setStatus(this.manageStatus(TStatusCode.SRM_INVALID_PATH, "Invalid SURL path specified"));
                            return surlReturnStatus;
                        }
                    }
                    catch (IllegalArgumentException e) {
                        log.error("Unable to build StoRI by SURL and user", (Throwable)e);
                        try {
                            SurlStatusManager.updateStatus(TRequestType.PREPARE_TO_PUT, surl, TStatusCode.SRM_INTERNAL_ERROR, "Unable to build StoRI by SURL and user");
                        }
                        catch (UnknownSurlException e1) {
                            log.error("Unexpected UnknownSurlException in SurlStatusManager.updateStatus: ", (Throwable)e);
                        }
                        surlReturnStatus.setSurl(surl);
                        surlReturnStatus.setStatus(this.manageStatus(TStatusCode.SRM_INTERNAL_ERROR, "Unable to build StoRI by SURL and user"));
                        return surlReturnStatus;
                    }
                }
            }
            fileToRemove = stori.getLocalFile();
            res = fileToRemove.delete();
            res = true;
            log.debug("PtPAbortExecutor: File removed.");
            if (failure) {
                try {
                    SurlStatusManager.updateStatus(TRequestType.PREPARE_TO_PUT, surl, TStatusCode.SRM_ABORTED, "Request aborted.");
                }
                catch (UnknownSurlException e) {
                    log.error("Unexpected UnknownSurlException in SurlStatusManager.updateStatus: ", (Throwable)e);
                }
                surlReturnStatus.setSurl(surl);
                surlReturnStatus.setStatus(this.manageStatus(TStatusCode.SRM_INTERNAL_ERROR, "Database Not Updated."));
                return surlReturnStatus;
            }
            if (res) {
                try {
                    SurlStatusManager.updateStatus(TRequestType.PREPARE_TO_PUT, surl, TStatusCode.SRM_ABORTED, "Request aborted.");
                }
                catch (UnknownSurlException e) {
                    log.error("Unexpected UnknownSurlException in SurlStatusManager.updateStatus: ", (Throwable)e);
                }
                surlReturnStatus.setSurl(surl);
                surlReturnStatus.setStatus(this.manageStatus(TStatusCode.SRM_SUCCESS, "File request successfully aborted."));
                return surlReturnStatus;
            }
            try {
                SurlStatusManager.updateStatus(TRequestType.PREPARE_TO_PUT, surl, TStatusCode.SRM_ABORTED, "Request aborted.");
            }
            catch (UnknownSurlException e) {
                log.error("Unexpected UnknownSurlException in SurlStatusManager.updateStatus: ", (Throwable)e);
            }
            surlReturnStatus.setSurl(surl);
            surlReturnStatus.setStatus(this.manageStatus(TStatusCode.SRM_INTERNAL_ERROR, "File not removed."));
            return surlReturnStatus;
        }
        surlReturnStatus.setSurl(surl);
        if (status.getStatusCode().equals((Object)TStatusCode.SRM_SUCCESS)) {
            surlReturnStatus.setStatus(this.manageStatus(TStatusCode.SRM_FAILURE, "Request is in a final status. Abort not allowed."));
        } else {
            surlReturnStatus.setStatus(this.manageStatus(TStatusCode.SRM_FAILURE, "Abort request not executed."));
        }
        return surlReturnStatus;
    }
}

