/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.synchcall.command.datatransfer;

import it.grid.storm.catalogs.RequestSummaryCatalog;
import it.grid.storm.config.Configuration;
import it.grid.storm.srm.types.ArrayOfSURLs;
import it.grid.storm.srm.types.ArrayOfTSURLReturnStatus;
import it.grid.storm.srm.types.InvalidTReturnStatusAttributeException;
import it.grid.storm.srm.types.TRequestToken;
import it.grid.storm.srm.types.TReturnStatus;
import it.grid.storm.srm.types.TSURL;
import it.grid.storm.srm.types.TSURLReturnStatus;
import it.grid.storm.srm.types.TStatusCode;
import it.grid.storm.synchcall.command.datatransfer.AbortExecutorInterface;
import it.grid.storm.synchcall.data.DataHelper;
import it.grid.storm.synchcall.data.datatransfer.AbortFilesInputData;
import it.grid.storm.synchcall.data.datatransfer.AbortGeneralOutputData;
import it.grid.storm.synchcall.data.datatransfer.AbortInputData;
import it.grid.storm.synchcall.surl.ExpiredTokenException;
import it.grid.storm.synchcall.surl.SurlStatusManager;
import it.grid.storm.synchcall.surl.UnknownSurlException;
import it.grid.storm.synchcall.surl.UnknownTokenException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PtGAbortExecutor
implements AbortExecutorInterface {
    static Configuration config = Configuration.getInstance();
    private static int maxLoopTimes = config.getMaxLoop();
    private static final Logger log = LoggerFactory.getLogger(PtGAbortExecutor.class);

    @Override
    public AbortGeneralOutputData doIt(AbortInputData inputData) {
        Map<TSURL, TReturnStatus> surlStatusMap;
        log.debug("srmAbortRequest: Started PtGAbortExecutor");
        AbortGeneralOutputData outputData = new AbortGeneralOutputData();
        ArrayOfTSURLReturnStatus arrayOfTSurlRetStatus = new ArrayOfTSURLReturnStatus();
        TReturnStatus globalStatus = null;
        try {
            surlStatusMap = SurlStatusManager.getSurlsStatus(inputData.getRequestToken());
        }
        catch (IllegalArgumentException e) {
            log.error("Unexpected IllegalArgumentException during SurlStatusManager.getSurlsStatus: " + e);
            throw new IllegalStateException("Unexpected IllegalArgumentException: " + e.getMessage());
        }
        catch (UnknownTokenException e) {
            log.debug("PtGAbortExecutor: Request - Invalid request token");
            globalStatus = this.manageStatus(TStatusCode.SRM_INVALID_REQUEST, "Invalid request token");
            outputData.setReturnStatus(globalStatus);
            outputData.setArrayOfFileStatuses(null);
            log.info("srmAbortRequest: <" + DataHelper.getRequestor(inputData) + "> Request for [token:" + inputData.getRequestToken() + "] successfully done with [status: " + globalStatus + "]");
            return outputData;
        }
        catch (ExpiredTokenException e) {
            log.info("The request is expired: ExpiredTokenException: " + e.getMessage());
            globalStatus = this.manageStatus(TStatusCode.SRM_REQUEST_TIMED_OUT, "Request expired");
            outputData.setReturnStatus(globalStatus);
            outputData.setArrayOfFileStatuses(null);
            log.info("srmAbortRequest: <" + DataHelper.getRequestor(inputData) + "> Request for [token:" + inputData.getRequestToken() + "] failed with [status: " + globalStatus + "]");
            return outputData;
        }
        if (surlStatusMap.isEmpty()) {
            log.debug("PtGAbortExecutor: Request - Invalid request token");
            globalStatus = this.manageStatus(TStatusCode.SRM_INVALID_REQUEST, "Invalid request token");
            outputData.setReturnStatus(globalStatus);
            outputData.setArrayOfFileStatuses(null);
            log.info("srmAbortRequest: <" + DataHelper.getRequestor(inputData) + "> Request for [token:" + inputData.getRequestToken() + "] successfully done with [status: " + globalStatus + "]");
            return outputData;
        }
        if (inputData.getType().equals((Object)AbortInputData.AbortType.ABORT_FILES)) {
            log.debug("PtGAbortExecutor: Case of AbortFile request. Purge Chunks with SurlArray.");
            ArrayList<TSURL> surlList = this.extractSurlArray(inputData).getArrayList();
            surlStatusMap.keySet().retainAll(surlList);
            if (!surlStatusMap.keySet().containsAll(surlList)) {
                for (TSURL surl : surlList) {
                    if (surlStatusMap.containsKey(surl)) continue;
                    log.debug("PtGAbortExecutor: requested SURL NOT found, invalid file request");
                    TSURLReturnStatus surlReturnStatus = new TSURLReturnStatus();
                    surlReturnStatus.setSurl(surl);
                    surlReturnStatus.setStatus(this.manageStatus(TStatusCode.SRM_INVALID_PATH, "SURL specified does not referes to this request token."));
                    log.info("srmAbortFiles: <" + DataHelper.getRequestor(inputData) + "> Request for [token:" + inputData.getRequestToken() + "] for [SURL:" + surl + "] failed  with [status: " + surlReturnStatus.getStatus() + "]");
                    arrayOfTSurlRetStatus.addTSurlReturnStatus(surlReturnStatus);
                }
            }
        }
        if (surlStatusMap.isEmpty()) {
            log.debug("Abort Request - No surl specified associated to request token");
            globalStatus = this.manageStatus(TStatusCode.SRM_FAILURE, "All surl specified does not referes to the request token.");
            outputData.setReturnStatus(globalStatus);
            outputData.setArrayOfFileStatuses(arrayOfTSurlRetStatus);
            log.info("srmAbortRequest: <" + DataHelper.getRequestor(inputData) + "> Request for [token:" + inputData.getRequestToken() + "] failed with [status: " + globalStatus + "]");
            return outputData;
        }
        int chunkAborted = 0;
        int counter = 0;
        int errorCount = 0;
        int totalSize = surlStatusMap.size();
        while (chunkAborted < totalSize && counter < maxLoopTimes) {
            ++counter;
            int numOfSurl = 0;
            Iterator<Map.Entry<TSURL, TReturnStatus>> iterator = surlStatusMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<TSURL, TReturnStatus> surlStatus = iterator.next();
                ++numOfSurl;
                if (surlStatus.getValue().getStatusCode().equals((Object)TStatusCode.SRM_REQUEST_INPROGRESS)) continue;
                log.debug("srmAbortRequest: PtGAbortExecutor: PtGChunk not in IN_PROGRESS state. Ready for ABORT.");
                TSURLReturnStatus surlReturnStatus = new TSURLReturnStatus();
                log.debug("srmAbortRequest: PtGAbortExecutor: start Phase(3)");
                if (surlStatus.getValue().getStatusCode().equals((Object)TStatusCode.SRM_ABORTED)) {
                    log.debug("PtGAbortExecutor: CHUNK already aborted!");
                    surlReturnStatus.setSurl(surlStatus.getKey());
                    surlReturnStatus.setStatus(this.manageStatus(TStatusCode.SRM_SUCCESS, "File request successfully aborted."));
                } else {
                    log.debug("PtPAbortExecutor: CHUNK to abort!");
                    try {
                        surlReturnStatus = this.manageAuthorizedAbort(inputData.getRequestToken(), surlStatus.getKey(), surlStatus.getValue());
                    }
                    catch (ExpiredTokenException e) {
                        log.info("The request is expired: ExpiredTokenException: " + e.getMessage());
                        globalStatus = this.manageStatus(TStatusCode.SRM_REQUEST_TIMED_OUT, "Request expired");
                        outputData.setReturnStatus(globalStatus);
                        outputData.setArrayOfFileStatuses(null);
                        log.info("srmAbortRequest: <" + DataHelper.getRequestor(inputData) + "> Request for [token:" + inputData.getRequestToken() + "] failed with [status: " + globalStatus + "]");
                        return outputData;
                    }
                }
                iterator.remove();
                if (surlReturnStatus.getStatus().getStatusCode().equals((Object)TStatusCode.SRM_SUCCESS)) {
                    log.info("srmAbortFiles: <" + DataHelper.getRequestor(inputData) + "> Request for [token:" + inputData.getRequestToken() + "] for SURL " + numOfSurl + " of " + totalSize + " [SURL:" + surlStatus.getKey() + "] successfully done  with [status: " + surlReturnStatus.getStatus() + "]");
                } else {
                    log.info("srmAbortFiles: <" + DataHelper.getRequestor(inputData) + "> Request for [token:" + inputData.getRequestToken() + "] for SURL " + numOfSurl + " of " + totalSize + " [SURL:" + surlStatus.getKey() + "] failed with [status: " + surlReturnStatus.getStatus() + "]");
                    ++errorCount;
                }
                arrayOfTSurlRetStatus.addTSurlReturnStatus(surlReturnStatus);
                ++chunkAborted;
            }
            if (chunkAborted >= totalSize) continue;
            log.debug("PtGAbortExecutor: I'm waiting...");
            try {
                long numMillisecondsToSleep = 300L;
                Thread.sleep(numMillisecondsToSleep);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            log.debug("PtGAbortExecutor: Wake up! It's time to work...");
            log.debug("srmAbortRequest: PtGAbortExecutor: refresh surl status");
            try {
                surlStatusMap = SurlStatusManager.getSurlsStatus(inputData.getRequestToken(), surlStatusMap.keySet());
            }
            catch (IllegalArgumentException e) {
                log.error("Unexpected IllegalArgumentException during SurlStatusManager.getSurlsStatus: " + e);
                throw new IllegalStateException("Unexpected IllegalArgumentException: " + e.getMessage());
            }
            catch (UnknownTokenException e) {
                log.warn("PtGAbortExecutor: Request - Invalid request token, probably it is expired");
                globalStatus = this.manageStatus(TStatusCode.SRM_INVALID_REQUEST, "Expired request token");
                outputData.setReturnStatus(globalStatus);
                outputData.setArrayOfFileStatuses(null);
                log.info("srmAbortRequest: <" + DataHelper.getRequestor(inputData) + "> Request for [token:" + inputData.getRequestToken() + "] successfully done with [status: " + globalStatus + "]");
                return outputData;
            }
            catch (ExpiredTokenException e) {
                log.info("The request is expired: ExpiredTokenException: " + e.getMessage());
                globalStatus = this.manageStatus(TStatusCode.SRM_REQUEST_TIMED_OUT, "Request expired");
                outputData.setReturnStatus(globalStatus);
                outputData.setArrayOfFileStatuses(null);
                log.info("srmAbortRequest: <" + DataHelper.getRequestor(inputData) + "> Request for [token:" + inputData.getRequestToken() + "] failed with [status: " + globalStatus + "]");
                return outputData;
            }
            log.debug("srmAbortRequest: PtGAbortExecutor: refresh done.");
        }
        log.debug("PtGAbortExecutor: Cycles done.");
        if (chunkAborted < totalSize) {
            log.warn("Abort: Timeout exceeded.");
            globalStatus = this.manageStatus(TStatusCode.SRM_INTERNAL_ERROR, "TimeOut for abort execution exceeded.");
            outputData.setReturnStatus(globalStatus);
            outputData.setArrayOfFileStatuses(arrayOfTSurlRetStatus);
            log.warn("srmAbortRequest: <" + DataHelper.getRequestor(inputData) + "> Request for [token:" + inputData.getRequestToken() + "] failed with [status: " + globalStatus + "]");
            return outputData;
        }
        if (errorCount == totalSize) {
            globalStatus = this.manageStatus(TStatusCode.SRM_FAILURE, "Abort failed.");
        } else if (errorCount > 0) {
            globalStatus = inputData.getType().equals((Object)AbortInputData.AbortType.ABORT_REQUEST) ? this.manageStatus(TStatusCode.SRM_FAILURE, "Some chunks failed.") : this.manageStatus(TStatusCode.SRM_PARTIAL_SUCCESS, "Some chunks failed.");
        } else {
            globalStatus = this.manageStatus(TStatusCode.SRM_SUCCESS, "Abort request completed.");
            if (inputData.getType().equals((Object)AbortInputData.AbortType.ABORT_FILES)) {
                TReturnStatus requestStatus = this.manageStatus(TStatusCode.SRM_ABORTED, "Request Aborted.");
                RequestSummaryCatalog.getInstance().updateGlobalStatus(inputData.getRequestToken(), requestStatus);
            }
        }
        outputData.setArrayOfFileStatuses(arrayOfTSurlRetStatus);
        outputData.setReturnStatus(globalStatus);
        log.info("srmAbortRequest: <" + DataHelper.getRequestor(inputData) + "> Request for [token:" + inputData.getRequestToken() + "] failed with [status: " + globalStatus + "]");
        return outputData;
    }

    private ArrayOfSURLs extractSurlArray(AbortInputData inputData) {
        switch (inputData.getType()) {
            case ABORT_REQUEST: {
                throw new IllegalStateException("Unable to get SurlArray from an ABORT_REQUEST input data");
            }
            case ABORT_FILES: {
                return ((AbortFilesInputData)inputData).getArrayOfSURLs();
            }
        }
        throw new IllegalStateException("Received an unknown AbortType: " + (Object)((Object)inputData.getType()));
    }

    private TReturnStatus manageStatus(TStatusCode statusCode, String explanation) {
        TReturnStatus returnStatus = null;
        try {
            returnStatus = new TReturnStatus(statusCode, explanation);
        }
        catch (InvalidTReturnStatusAttributeException ex1) {
            log.debug("AbortExecutor : Error creating returnStatus " + ex1);
        }
        return returnStatus;
    }

    private TSURLReturnStatus manageAuthorizedAbort(TRequestToken token, TSURL surl, TReturnStatus status) throws ExpiredTokenException {
        TSURLReturnStatus surlReturnStatus = new TSURLReturnStatus();
        surlReturnStatus.setSurl(surl);
        if (TStatusCode.SRM_FILE_PINNED.equals((Object)status.getStatusCode()) || TStatusCode.SRM_REQUEST_QUEUED.equals((Object)status.getStatusCode())) {
            try {
                SurlStatusManager.updateStatus(token, surl, TStatusCode.SRM_ABORTED, "Request aborted.");
            }
            catch (IllegalArgumentException e) {
                log.error("Unexpected IllegalArgumentException during surl statuses update: " + e);
                throw new IllegalStateException("Unexpected IllegalArgumentException: " + e.getMessage());
            }
            catch (UnknownTokenException e) {
                log.error("Unexpected UnknownTokenException during surl statuses update: " + e);
                throw new IllegalStateException("Unexpected UnknownTokenException: " + e.getMessage());
            }
            catch (UnknownSurlException e) {
                log.error("Unexpected UnknownSurlException during surl statuses update: " + e);
                throw new IllegalStateException("Unexpected UnknownSurlException: " + e.getMessage());
            }
            surlReturnStatus.setStatus(this.manageStatus(TStatusCode.SRM_SUCCESS, "File request successfully aborted."));
        } else if (TStatusCode.SRM_FILE_LIFETIME_EXPIRED.equals((Object)status.getStatusCode())) {
            surlReturnStatus.setStatus(this.manageStatus(TStatusCode.SRM_FAILURE, "Request is in a final status. Abort not allowed."));
        } else if (TStatusCode.SRM_RELEASED.equals((Object)status.getStatusCode())) {
            surlReturnStatus.setStatus(this.manageStatus(TStatusCode.SRM_FAILURE, "Request is in a final status. Abort not allowed."));
        } else {
            surlReturnStatus.setStatus(this.manageStatus(TStatusCode.SRM_FAILURE, "Abort request not executed."));
        }
        return surlReturnStatus;
    }
}

