/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.synchcall.command.datatransfer;

import it.grid.storm.catalogs.VolatileAndJiTCatalog;
import it.grid.storm.filesystem.LocalFile;
import it.grid.storm.griduser.GridUserInterface;
import it.grid.storm.namespace.NamespaceDirector;
import it.grid.storm.namespace.NamespaceInterface;
import it.grid.storm.namespace.StoRI;
import it.grid.storm.namespace.UnapprochableSurlException;
import it.grid.storm.srm.types.ArrayOfSURLs;
import it.grid.storm.srm.types.ArrayOfTSURLLifetimeReturnStatus;
import it.grid.storm.srm.types.InvalidTReturnStatusAttributeException;
import it.grid.storm.srm.types.InvalidTSURLLifetimeReturnStatusAttributeException;
import it.grid.storm.srm.types.TLifeTimeInSeconds;
import it.grid.storm.srm.types.TRequestToken;
import it.grid.storm.srm.types.TReturnStatus;
import it.grid.storm.srm.types.TSURL;
import it.grid.storm.srm.types.TSURLLifetimeReturnStatus;
import it.grid.storm.srm.types.TStatusCode;
import it.grid.storm.synchcall.command.Command;
import it.grid.storm.synchcall.command.CommandHelper;
import it.grid.storm.synchcall.command.DataTransferCommand;
import it.grid.storm.synchcall.data.IdentityInputData;
import it.grid.storm.synchcall.data.InputData;
import it.grid.storm.synchcall.data.OutputData;
import it.grid.storm.synchcall.data.datatransfer.ExtendFileLifeTimeInputData;
import it.grid.storm.synchcall.data.datatransfer.ExtendFileLifeTimeOutputData;
import it.grid.storm.synchcall.data.datatransfer.IdentityExtendFileLifeTimeInputData;
import it.grid.storm.synchcall.surl.ExpiredTokenException;
import it.grid.storm.synchcall.surl.SurlStatusManager;
import it.grid.storm.synchcall.surl.UnknownSurlException;
import it.grid.storm.synchcall.surl.UnknownTokenException;
import java.util.Calendar;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtendFileLifeTimeCommand
extends DataTransferCommand
implements Command {
    private static final Logger log = LoggerFactory.getLogger(ExtendFileLifeTimeCommand.class);
    private static final String SRM_COMMAND = "srmExtendFileLifeTime";

    @Override
    public OutputData execute(InputData data) {
        String funcName = "ExtendFileLifeTime: ";
        ExtendFileLifeTimeOutputData outputData = new ExtendFileLifeTimeOutputData();
        if (!(data instanceof IdentityInputData)) {
            outputData.setReturnStatus(CommandHelper.buildStatus(TStatusCode.SRM_NOT_SUPPORTED, "Anonymous user can not performsrmExtendFileLifeTime"));
            outputData.setArrayOfFileStatuses(null);
            this.printRequestOutcome(outputData.getReturnStatus(), (ExtendFileLifeTimeInputData)data);
            return outputData;
        }
        IdentityExtendFileLifeTimeInputData inputData = (IdentityExtendFileLifeTimeInputData)data;
        TReturnStatus globalStatus = null;
        log.debug("ExtendFileLifeTime: Started.");
        try {
            if (inputData.getArrayOfSURLs() == null) {
                globalStatus = new TReturnStatus(TStatusCode.SRM_INVALID_REQUEST, "Missing mandatory parameter 'arrayOfSURLs'");
            } else if (inputData.getArrayOfSURLs().size() < 1) {
                globalStatus = new TReturnStatus(TStatusCode.SRM_INVALID_REQUEST, "Parameter 'arrayOfSURLs': invalid size");
            } else if (!inputData.getNewPinLifetime().isEmpty() && !inputData.getNewFileLifetime().isEmpty() && inputData.getRequestToken() != null) {
                globalStatus = new TReturnStatus(TStatusCode.SRM_INVALID_REQUEST, "Cannot update both FileLifetime and PinLifetime");
            } else if (inputData.getNewPinLifetime().isEmpty() && !inputData.getNewFileLifetime().isEmpty() && inputData.getRequestToken() != null) {
                globalStatus = new TReturnStatus(TStatusCode.SRM_INVALID_REQUEST, "Do not specify the request token to update the FileLifetime");
            } else if (!inputData.getNewPinLifetime().isEmpty() && !inputData.getNewFileLifetime().isEmpty() && inputData.getRequestToken() == null) {
                globalStatus = new TReturnStatus(TStatusCode.SRM_INVALID_REQUEST, "Attempt to extend PinLifetime without request token");
            } else if (!inputData.getNewPinLifetime().isEmpty() && inputData.getNewFileLifetime().isEmpty() && inputData.getRequestToken() == null) {
                globalStatus = new TReturnStatus(TStatusCode.SRM_INVALID_REQUEST, "Attempt to extend PinLifetime without request token");
            }
        }
        catch (InvalidTReturnStatusAttributeException e) {
            log.warn("dataTransferManger: Error creating returnStatus " + e);
        }
        if (globalStatus != null) {
            log.debug("ExtendFileLifeTime: " + globalStatus.getExplanation());
            outputData.setReturnStatus(globalStatus);
            outputData.setArrayOfFileStatuses(null);
            this.printRequestOutcome(outputData.getReturnStatus(), inputData);
            return outputData;
        }
        GridUserInterface user = inputData.getUser();
        if (user == null) {
            log.debug("ExtendFileLifeTime: The user field is NULL");
            outputData.setReturnStatus(CommandHelper.buildStatus(TStatusCode.SRM_AUTHENTICATION_FAILURE, "Unable to get user credential!"));
            this.printRequestOutcome(outputData.getReturnStatus(), inputData);
            outputData.setArrayOfFileStatuses(null);
            return outputData;
        }
        ArrayOfTSURLLifetimeReturnStatus arrayOfFileStatus = new ArrayOfTSURLLifetimeReturnStatus();
        if (inputData.getRequestToken() == null && inputData.getNewPinLifetime().isEmpty()) {
            log.debug("ExtendFileLifeTime: Extending SURL lifetime...");
            globalStatus = this.manageExtendSURLLifetime(inputData.getNewFileLifetime(), inputData.getArrayOfSURLs(), user, arrayOfFileStatus, inputData.getRequestToken());
        } else {
            log.debug("ExtendFileLifeTime: Extending PIN lifetime...");
            try {
                globalStatus = this.manageExtendPinLifetime(inputData.getRequestToken(), inputData.getNewPinLifetime(), inputData.getArrayOfSURLs(), user, arrayOfFileStatus);
            }
            catch (IllegalArgumentException e) {
                log.error("ExtendFileLifeTime: Unexpected IllegalArgumentException: " + e.getMessage());
                globalStatus = CommandHelper.buildStatus(TStatusCode.SRM_INTERNAL_ERROR, "Request Failed, retry.");
                outputData.setReturnStatus(globalStatus);
                outputData.setArrayOfFileStatuses(null);
                this.printRequestOutcome(outputData.getReturnStatus(), inputData);
                return outputData;
            }
        }
        outputData.setReturnStatus(globalStatus);
        outputData.setArrayOfFileStatuses(arrayOfFileStatus);
        this.printRequestOutcome(outputData.getReturnStatus(), inputData);
        log.debug("ExtendFileLifeTime: Finished.");
        return outputData;
    }

    private TReturnStatus manageExtendSURLLifetime(TLifeTimeInSeconds newLifetime, ArrayOfSURLs arrayOfSURLS, GridUserInterface guser, ArrayOfTSURLLifetimeReturnStatus details, TRequestToken requestToken) {
        if (details == null) {
            log.debug("Function manageExtendSURLLifetime, class ExtendFileLifeTimeExecutor: parameter details is NULL");
        }
        NamespaceInterface namespace = NamespaceDirector.getNamespace();
        VolatileAndJiTCatalog catalog = VolatileAndJiTCatalog.getInstance();
        boolean requestSuccess = true;
        boolean requestFailure = true;
        for (int i = 0; i < arrayOfSURLS.size(); ++i) {
            TSURL surl = arrayOfSURLS.getTSURL(i);
            StoRI stori = null;
            try {
                String fileStatusExplanation;
                TStatusCode fileStatusCode;
                try {
                    stori = namespace.resolveStoRIbySURL(surl, guser);
                }
                catch (IllegalArgumentException e) {
                    log.error("Unable to build StoRI by SURL and user", (Throwable)e);
                    fileStatusCode = TStatusCode.SRM_INTERNAL_ERROR;
                    fileStatusExplanation = "Unable to build StoRI by SURL and user";
                }
                catch (UnapprochableSurlException e) {
                    log.info("Unable to build a stori for surl " + surl + " for user " + guser + " UnapprochableSurlException: " + e.getMessage());
                    fileStatusCode = TStatusCode.SRM_INVALID_PATH;
                    fileStatusExplanation = "Invalid SURL path specified";
                }
                if (stori == null) continue;
                LocalFile localFile = stori.getLocalFile();
                if (localFile.exists()) {
                    log.debug(stori.getPFN().toString());
                    List volatileInfo = catalog.volatileInfoOn(stori.getPFN());
                    if (volatileInfo.isEmpty()) {
                        fileStatusCode = TStatusCode.SRM_SUCCESS;
                        fileStatusExplanation = "Nothing to do, SURL is permanent";
                        newLifetime = TLifeTimeInSeconds.makeInfinite();
                        requestFailure = false;
                    } else if (volatileInfo.size() > 2) {
                        fileStatusCode = TStatusCode.SRM_INTERNAL_ERROR;
                        fileStatusExplanation = "Found more than one entry.... that's a BUG.";
                        newLifetime = TLifeTimeInSeconds.makeInfinite();
                        requestSuccess = false;
                    } else if (this.isStoRISURLBusy(stori)) {
                        fileStatusCode = TStatusCode.SRM_FILE_BUSY;
                        fileStatusExplanation = "File status is SRM_SPACE_AVAILABLE. SURL lifetime cannot be extend (try with PIN lifetime)";
                        newLifetime = TLifeTimeInSeconds.makeInfinite();
                        requestSuccess = false;
                    } else {
                        catalog.trackVolatile(stori.getPFN(), (Calendar)volatileInfo.get(0), newLifetime);
                        fileStatusCode = TStatusCode.SRM_SUCCESS;
                        fileStatusExplanation = "Lifetime extended";
                        requestFailure = false;
                    }
                } else {
                    fileStatusCode = TStatusCode.SRM_INVALID_PATH;
                    fileStatusExplanation = "File does not exist";
                    requestSuccess = false;
                }
                TReturnStatus fileStatus = new TReturnStatus(fileStatusCode, fileStatusExplanation);
                if (fileStatus.getStatusCode().equals((Object)TStatusCode.SRM_SUCCESS)) {
                    log.info("srmExtendFileLifeTime: <" + guser + "> Request for [token:" + requestToken + "] for [SURL:" + surl + "] with [lifetime:" + newLifetime + " ] successfully done with: [status:" + fileStatus + "]");
                } else {
                    log.error("srmExtendFileLifeTime: <" + guser + "> Request for [token:" + requestToken + "] for [SURL:" + surl + "] with [lifetime:" + newLifetime + "] failed with: [status:" + fileStatus + "]");
                }
                TSURLLifetimeReturnStatus lifetimeReturnStatus = new TSURLLifetimeReturnStatus(surl, fileStatus, newLifetime, null);
                details.addTSurlReturnStatus(lifetimeReturnStatus);
                continue;
            }
            catch (InvalidTReturnStatusAttributeException e2) {
                log.debug("Thrown InvalidTReturnStatusAttributeException");
                continue;
            }
            catch (InvalidTSURLLifetimeReturnStatusAttributeException e3) {
                log.debug("Thrown InvalidTSURLLifetimeReturnStatusAttributeException");
            }
        }
        TReturnStatus globalStatus = null;
        try {
            globalStatus = requestFailure ? new TReturnStatus(TStatusCode.SRM_FAILURE, "All file requests are failed") : (requestSuccess ? new TReturnStatus(TStatusCode.SRM_SUCCESS, "All file requests are successfully completed") : new TReturnStatus(TStatusCode.SRM_PARTIAL_SUCCESS, "Details are on the file statuses"));
        }
        catch (InvalidTReturnStatusAttributeException e) {
            log.error("Unable to build Return Status in Extend Lifetime." + e);
        }
        return globalStatus;
    }

    private boolean isStoRISURLBusy(StoRI element) {
        try {
            return TStatusCode.SRM_SPACE_AVAILABLE.equals(SurlStatusManager.getSurlStatus(element.getSURL()));
        }
        catch (IllegalArgumentException e) {
            throw new IllegalStateException("unexpected IllegalArgumentException in SurlStatusManager.getSurlsStatus: " + e);
        }
        catch (UnknownSurlException e) {
            log.debug("Surl " + element.getSURL() + " not stored, surl is not busy");
            return false;
        }
    }

    private TReturnStatus manageExtendPinLifetime(TRequestToken requestToken, TLifeTimeInSeconds newPINLifetime, ArrayOfSURLs arrayOfSURLS, GridUserInterface guser, ArrayOfTSURLLifetimeReturnStatus details) throws IllegalArgumentException {
        List<SURLData> requestSURLsList;
        if (details == null) {
            log.debug("Function manageExtendSURLLifetime, class ExtendFileLifeTimeExecutor: parameter details is NULL");
        }
        TReturnStatus globalStatus = null;
        try {
            requestSURLsList = this.getListOfSURLsInTheRequest(requestToken);
        }
        catch (UnknownTokenException e4) {
            return CommandHelper.buildStatus(TStatusCode.SRM_INVALID_REQUEST, "Invalid request token");
        }
        catch (ExpiredTokenException e) {
            return CommandHelper.buildStatus(TStatusCode.SRM_REQUEST_TIMED_OUT, "Request expired");
        }
        if (requestSURLsList.isEmpty()) {
            return CommandHelper.buildStatus(TStatusCode.SRM_INVALID_REQUEST, "Invalid request token");
        }
        boolean requestSuccess = true;
        boolean requestFailure = true;
        TLifeTimeInSeconds dbLifetime = null;
        for (int i = 0; i < arrayOfSURLS.size(); ++i) {
            TSURL surl = arrayOfSURLS.getTSURL(i);
            TStatusCode statusOfTheSURL = null;
            boolean surlFound = false;
            for (int j = 0; j < requestSURLsList.size(); ++j) {
                SURLData surlData = requestSURLsList.get(j);
                if (!surl.equals(surlData.surl)) continue;
                statusOfTheSURL = surlData.statusCode;
                requestSURLsList.remove(j);
                surlFound = true;
                break;
            }
            try {
                TLifeTimeInSeconds PINLifetime;
                String fileStatusExplanation;
                TStatusCode fileStatusCode;
                if (surlFound) {
                    log.debug("Found SURL: " + surl.getSURLString() + " (status: " + statusOfTheSURL.toString() + ")");
                    NamespaceInterface namespace = NamespaceDirector.getNamespace();
                    StoRI stori = null;
                    try {
                        stori = namespace.resolveStoRIbySURL(surl, guser);
                    }
                    catch (IllegalArgumentException e) {
                        log.error("Unable to build StoRI by SURL and user", (Throwable)e);
                    }
                    catch (UnapprochableSurlException e) {
                        log.info("Unable to build a stori for surl " + surl + " for user " + guser + " UnapprochableSurlException: " + e.getMessage());
                    }
                    if (stori != null) {
                        LocalFile localFile = stori.getLocalFile();
                        if (localFile.exists()) {
                            VolatileAndJiTCatalog catalog = VolatileAndJiTCatalog.getInstance();
                            List volatileInfo = catalog.volatileInfoOn(stori.getPFN());
                            if (statusOfTheSURL != TStatusCode.SRM_FILE_PINNED && statusOfTheSURL != TStatusCode.SRM_SPACE_AVAILABLE && statusOfTheSURL != TStatusCode.SRM_SUCCESS) {
                                fileStatusCode = TStatusCode.SRM_INVALID_REQUEST;
                                fileStatusExplanation = "No TURL available";
                                PINLifetime = null;
                                requestSuccess = false;
                            } else if (volatileInfo.size() > 2) {
                                fileStatusCode = TStatusCode.SRM_INTERNAL_ERROR;
                                fileStatusExplanation = "Found more than one entry.... that's a BUG.";
                                PINLifetime = TLifeTimeInSeconds.makeInfinite();
                                requestSuccess = false;
                            } else if (statusOfTheSURL == TStatusCode.SRM_SUCCESS && !newPINLifetime.isEmpty()) {
                                fileStatusCode = TStatusCode.SRM_INVALID_REQUEST;
                                fileStatusExplanation = "No TURL available";
                                PINLifetime = null;
                                requestSuccess = false;
                            } else {
                                fileStatusCode = TStatusCode.SRM_SUCCESS;
                                dbLifetime = volatileInfo.isEmpty() ? TLifeTimeInSeconds.makeInfinite() : (TLifeTimeInSeconds)volatileInfo.get(1);
                                if (!dbLifetime.isInfinite() && newPINLifetime.value() > dbLifetime.value()) {
                                    PINLifetime = dbLifetime;
                                    fileStatusExplanation = "The requested PIN lifetime is greater than the lifetime of the SURL. PIN lifetime is now equal to the lifetime of the SURL.";
                                } else {
                                    PINLifetime = newPINLifetime;
                                    fileStatusExplanation = "Lifetime extended";
                                }
                                log.debug("New PIN lifetime is: " + PINLifetime.value() + "(SURL: " + surl.getSURLString() + ")");
                                requestFailure = false;
                            }
                        } else {
                            fileStatusCode = TStatusCode.SRM_INVALID_PATH;
                            fileStatusExplanation = "Invalid path";
                            PINLifetime = null;
                            requestSuccess = false;
                        }
                    } else {
                        log.error("Unable to build StoRI by SURL and user");
                        fileStatusCode = TStatusCode.SRM_INTERNAL_ERROR;
                        fileStatusExplanation = "Unable to build StoRI by SURL and user";
                        PINLifetime = null;
                        requestSuccess = false;
                    }
                } else {
                    log.debug("SURL: " + surl.getSURLString() + " NOT FOUND!");
                    fileStatusCode = TStatusCode.SRM_INVALID_PATH;
                    fileStatusExplanation = "SURL not found in the request";
                    PINLifetime = null;
                    requestSuccess = false;
                }
                TReturnStatus fileStatus = new TReturnStatus(fileStatusCode, fileStatusExplanation);
                if (fileStatus.getStatusCode().equals((Object)TStatusCode.SRM_SUCCESS)) {
                    log.info("srmExtendFileLifeTime: <" + guser + "> Request for [token:" + requestToken + "] for [SURL:" + surl + "] with [pinlifetime: " + newPINLifetime + "] successfully done with: [status:" + fileStatus.toString() + "]");
                } else {
                    log.error("srmExtendFileLifeTime: <" + guser + "> Request for [token:" + requestToken + "] for [SURL:" + surl + "] with [pinlifetime: " + newPINLifetime + "] failed with: [status:" + fileStatus.toString() + "]");
                }
                TSURLLifetimeReturnStatus lifetimeReturnStatus = new TSURLLifetimeReturnStatus(surl, fileStatus, dbLifetime, PINLifetime);
                details.addTSurlReturnStatus(lifetimeReturnStatus);
                continue;
            }
            catch (InvalidTReturnStatusAttributeException e2) {
                log.debug("Thrown InvalidTReturnStatusAttributeException");
                continue;
            }
            catch (InvalidTSURLLifetimeReturnStatusAttributeException e3) {
                log.debug("Thrown InvalidTSURLLifetimeReturnStatusAttributeException");
            }
        }
        try {
            globalStatus = requestFailure ? new TReturnStatus(TStatusCode.SRM_FAILURE, "All file requests are failed") : (requestSuccess ? new TReturnStatus(TStatusCode.SRM_SUCCESS, "All file requests are successfully completed") : new TReturnStatus(TStatusCode.SRM_PARTIAL_SUCCESS, "Details are on the file statuses"));
        }
        catch (InvalidTReturnStatusAttributeException e) {
            log.debug("BUG: Unexpected TReturnStatus exception" + e);
        }
        return globalStatus;
    }

    private List<SURLData> getListOfSURLsInTheRequest(TRequestToken requestToken) throws IllegalArgumentException, UnknownTokenException, ExpiredTokenException {
        LinkedList<SURLData> listOfSURLsInfo = new LinkedList<SURLData>();
        Map<TSURL, TReturnStatus> surlStatusMap = SurlStatusManager.getSurlsStatus(requestToken);
        if (surlStatusMap != null && !surlStatusMap.isEmpty()) {
            for (Map.Entry<TSURL, TReturnStatus> surlStatus : surlStatusMap.entrySet()) {
                listOfSURLsInfo.add(new SURLData(surlStatus.getKey(), surlStatus.getValue().getStatusCode()));
            }
        }
        return listOfSURLsInfo;
    }

    private void printRequestOutcome(TReturnStatus status, ExtendFileLifeTimeInputData inputData) {
        if (inputData != null) {
            if (inputData.getArrayOfSURLs() != null) {
                if (inputData.getRequestToken() != null) {
                    CommandHelper.printRequestOutcome(SRM_COMMAND, log, status, inputData, inputData.getRequestToken(), inputData.getArrayOfSURLs().asStringList());
                } else {
                    CommandHelper.printRequestOutcome(SRM_COMMAND, log, status, (InputData)inputData, inputData.getArrayOfSURLs().asStringList());
                }
            } else if (inputData.getRequestToken() != null) {
                CommandHelper.printRequestOutcome(SRM_COMMAND, log, status, (InputData)inputData, inputData.getRequestToken());
            } else {
                CommandHelper.printRequestOutcome(SRM_COMMAND, log, status, inputData);
            }
        } else {
            CommandHelper.printRequestOutcome(SRM_COMMAND, log, status);
        }
    }

    private class SURLData {
        public TSURL surl;
        public TStatusCode statusCode;

        public SURLData(TSURL surl, TStatusCode statusCode) {
            this.surl = surl;
            this.statusCode = statusCode;
        }
    }
}

