/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.synchcall.command.datatransfer;

import it.grid.storm.asynch.AdvancedPicker;
import it.grid.storm.catalogs.RequestSummaryCatalog;
import it.grid.storm.srm.types.ArrayOfSURLs;
import it.grid.storm.srm.types.ArrayOfTSURLReturnStatus;
import it.grid.storm.srm.types.InvalidTReturnStatusAttributeException;
import it.grid.storm.srm.types.TRequestToken;
import it.grid.storm.srm.types.TRequestType;
import it.grid.storm.srm.types.TReturnStatus;
import it.grid.storm.srm.types.TSURLReturnStatus;
import it.grid.storm.srm.types.TStatusCode;
import it.grid.storm.synchcall.command.Command;
import it.grid.storm.synchcall.command.DataTransferCommand;
import it.grid.storm.synchcall.command.datatransfer.AbortExecutorInterface;
import it.grid.storm.synchcall.command.datatransfer.CopyAbortExecutor;
import it.grid.storm.synchcall.command.datatransfer.PtGAbortExecutor;
import it.grid.storm.synchcall.command.datatransfer.PtPAbortExecutor;
import it.grid.storm.synchcall.data.DataHelper;
import it.grid.storm.synchcall.data.InputData;
import it.grid.storm.synchcall.data.OutputData;
import it.grid.storm.synchcall.data.datatransfer.AbortFilesInputData;
import it.grid.storm.synchcall.data.datatransfer.AbortFilesOutputData;
import it.grid.storm.synchcall.data.datatransfer.AbortInputData;
import it.grid.storm.synchcall.surl.ExpiredTokenException;
import it.grid.storm.synchcall.surl.SurlStatusManager;
import it.grid.storm.synchcall.surl.UnknownTokenException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbortFilesCommand
extends DataTransferCommand
implements Command {
    private static final Logger log = LoggerFactory.getLogger(AbortFilesCommand.class);
    private AdvancedPicker advancedPicker = null;
    private AbortExecutorInterface executor = null;

    @Override
    public OutputData execute(InputData data) {
        this.advancedPicker = new AdvancedPicker();
        AbortFilesOutputData outputData = new AbortFilesOutputData();
        AbortFilesInputData inputData = (AbortFilesInputData)data;
        boolean res = false;
        TReturnStatus globalStatus = null;
        ArrayOfTSURLReturnStatus arrayOfTSURLReturnStatus = null;
        log.debug("Started AbortRequest function.");
        if (inputData == null || inputData.getRequestToken() == null || inputData.getType().equals((Object)AbortInputData.AbortType.ABORT_FILES) && inputData.getArrayOfSURLs() == null) {
            log.debug("srmAbortFiles: Invalid input parameter specified");
            globalStatus = this.manageStatus(TStatusCode.SRM_INVALID_REQUEST, "Missing mandatory parameters");
            outputData.setReturnStatus(globalStatus);
            outputData.setArrayOfFileStatuses(null);
            log.error("srmAbortFiles: <> Request for [token:] [SURL:] failed with [status: " + globalStatus + "]");
            return outputData;
        }
        TRequestToken requestToken = inputData.getRequestToken();
        ArrayOfSURLs surlArray = inputData.getArrayOfSURLs();
        log.debug("srmAbortFiles: requestToken=" + requestToken.toString());
        if (inputData.getType().equals((Object)AbortInputData.AbortType.ABORT_REQUEST)) {
            log.debug("Phase (1.A) AbortRequest: SurlArray Not specified.");
            try {
                SurlStatusManager.checkAndUpdateStatus(requestToken, TStatusCode.SRM_REQUEST_QUEUED, TStatusCode.SRM_ABORTED, "User aborted request!");
            }
            catch (UnknownTokenException e) {
                log.info("Unable to update surls status on token " + requestToken + " .UnknownTokenException: " + e.getMessage());
                globalStatus = this.manageStatus(TStatusCode.SRM_INVALID_REQUEST, "Invalid request token");
                outputData.setArrayOfFileStatuses(null);
                log.info("srmAbortFiles: <" + DataHelper.getRequestor(inputData) + "> Request for [token:" + inputData.getRequestToken() + "] failed with [status: " + globalStatus + "]");
                return outputData;
            }
            catch (ExpiredTokenException e) {
                log.info("Unable to update surls status on token " + requestToken + " .ExpiredTokenException: " + e.getMessage());
                globalStatus = this.manageStatus(TStatusCode.SRM_REQUEST_TIMED_OUT, "Request expired");
                outputData.setArrayOfFileStatuses(null);
                log.info("srmAbortFiles: <" + DataHelper.getRequestor(inputData) + "> Request for [token:" + inputData.getRequestToken() + "] failed with [status: " + globalStatus + "]");
                return outputData;
            }
            RequestSummaryCatalog.getInstance().updateFromPreviousGlobalStatus(requestToken, TStatusCode.SRM_REQUEST_QUEUED, TStatusCode.SRM_ABORTED, "User aborted request!");
            res = false;
        } else if (inputData.getType().equals((Object)AbortInputData.AbortType.ABORT_FILES)) {
            log.debug("Phase (1.A) AbortRequest: SurlArray Specified.");
            res = false;
        }
        if (res) {
            arrayOfTSURLReturnStatus = new ArrayOfTSURLReturnStatus();
            globalStatus = this.manageStatus(TStatusCode.SRM_SUCCESS, "Abort sucessfully completed.");
            outputData.setReturnStatus(globalStatus);
            if (inputData.getType().equals((Object)AbortInputData.AbortType.ABORT_FILES)) {
                for (int i = 0; i < surlArray.size(); ++i) {
                    TSURLReturnStatus surlRetStatus = new TSURLReturnStatus();
                    surlRetStatus.setSurl(surlArray.getTSURL(i));
                    surlRetStatus.setStatus(this.manageStatus(TStatusCode.SRM_SUCCESS, "File request aborted."));
                    log.info("srmAbortFiles: <" + DataHelper.getRequestor(inputData) + "> Request for [token:" + inputData.getRequestToken() + "] for SURL " + (i + 1) + " of " + surlArray.size() + " [SURL:" + surlArray.getTSURL(i) + "] successfully done with [status: " + surlRetStatus.getStatus() + "]");
                    arrayOfTSURLReturnStatus.addTSurlReturnStatus(surlRetStatus);
                }
                log.info("srmAbortFiles: <" + DataHelper.getRequestor(inputData) + "> Request for [token:" + inputData.getRequestToken() + "] for [SURL:" + surlArray + "] successfully done with [status: " + globalStatus + "]");
            } else {
                outputData.setArrayOfFileStatuses(null);
                log.info("srmAbortFiles: <" + DataHelper.getRequestor(inputData) + "> Request for [token:" + inputData.getRequestToken() + "] successfully done with [status: " + globalStatus + "]");
            }
            return outputData;
        }
        log.debug("Phase (1.A) AbortRequest: Token not found.");
        if (inputData.getType().equals((Object)AbortInputData.AbortType.ABORT_REQUEST)) {
            log.debug("Phase (1.B) AbortRequest: SurlArray Not specified.");
            this.advancedPicker.abortRequest(inputData.getRequestToken());
            res = false;
        } else if (inputData.getType().equals((Object)AbortInputData.AbortType.ABORT_FILES)) {
            log.debug("Phase (1.B) AbortRequest: SurlArray Specified.");
            res = false;
        }
        if (res) {
            arrayOfTSURLReturnStatus = new ArrayOfTSURLReturnStatus();
            globalStatus = this.manageStatus(TStatusCode.SRM_SUCCESS, "Abort sucessfully completed.");
            outputData.setReturnStatus(globalStatus);
            if (inputData.getType().equals((Object)AbortInputData.AbortType.ABORT_FILES)) {
                for (int i = 0; i < surlArray.size(); ++i) {
                    TSURLReturnStatus surlRetStatus = new TSURLReturnStatus();
                    surlRetStatus.setSurl(surlArray.getTSURL(i));
                    surlRetStatus.setStatus(this.manageStatus(TStatusCode.SRM_SUCCESS, "File request aborted."));
                    log.info("srmAbortFiles: <" + DataHelper.getRequestor(inputData) + "> Request for [token:" + inputData.getRequestToken() + "] for SURL " + (i + 1) + " of " + surlArray.size() + " [SURL:" + surlArray.getTSURL(i) + "] successfully done with [status: " + surlRetStatus.getStatus() + "]");
                    arrayOfTSURLReturnStatus.addTSurlReturnStatus(surlRetStatus);
                }
                log.info("srmAbortFiles: <" + DataHelper.getRequestor(inputData) + "> Request for [token:" + inputData.getRequestToken() + "] for [SURL:" + surlArray + "] successfully done with [status: " + globalStatus + "]");
            } else {
                outputData.setArrayOfFileStatuses(null);
                log.info("srmAbortFiles: <" + DataHelper.getRequestor(inputData) + "> Request for [token:" + inputData.getRequestToken() + "] successfully done with [status: " + globalStatus + "]");
            }
            return outputData;
        }
        log.debug("Phase (1.B) AbortRequest: Token not found.");
        TRequestType rtype = SurlStatusManager.isPersisted(requestToken);
        if (rtype == TRequestType.PREPARE_TO_GET) {
            this.executor = new PtGAbortExecutor();
            return this.executor.doIt(inputData);
        }
        if (rtype == TRequestType.PREPARE_TO_PUT) {
            this.executor = new PtPAbortExecutor();
            return this.executor.doIt(inputData);
        }
        if (rtype == TRequestType.COPY) {
            this.executor = new CopyAbortExecutor();
            return this.executor.doIt(inputData);
        }
        log.debug("This case is really possibile?");
        log.debug("srmAbortFiles : Invalid input parameter specified");
        globalStatus = this.manageStatus(TStatusCode.SRM_INVALID_REQUEST, "Invalid request token. Abort only works for PtG, PtP and Copy.");
        log.error("srmAbortFiles: <" + DataHelper.getRequestor(inputData) + "> Request for [token:" + inputData.getRequestToken() + "] failed with [status: " + globalStatus + "]");
        outputData.setReturnStatus(globalStatus);
        outputData.setArrayOfFileStatuses(null);
        return outputData;
    }

    private TReturnStatus manageStatus(TStatusCode statusCode, String explanation) {
        TReturnStatus returnStatus = null;
        try {
            returnStatus = new TReturnStatus(statusCode, explanation);
        }
        catch (InvalidTReturnStatusAttributeException ex1) {
            log.debug("AbortExecutor : Error creating returnStatus " + ex1);
        }
        return returnStatus;
    }
}

