/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.srm.types;

import it.grid.storm.srm.types.TAccessPattern;
import it.grid.storm.srm.types.TConnectionType;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TTransferParameters
implements Serializable {
    private static final long serialVersionUID = 7309411351545907539L;
    private static final Logger log = LoggerFactory.getLogger(TTransferParameters.class);
    public static final String PNAME_transferParameters = "transferParameters";
    private TAccessPattern accessPattern = null;
    private TConnectionType connectionType = null;
    private String[] arrayOfClientNetworks;
    private String[] arrayOfTransferProtocols;

    public TTransferParameters() {
    }

    public TTransferParameters(TAccessPattern accessPattern, TConnectionType connectionType, String[] arrayOfClientNetworks, String[] arrayOfTransferProtocols) {
        this.accessPattern = accessPattern;
        this.connectionType = connectionType;
        this.arrayOfClientNetworks = arrayOfClientNetworks;
        this.arrayOfTransferProtocols = arrayOfTransferProtocols;
    }

    public static TTransferParameters decode(Map inputParam, String fieldName) {
        Map param = (Map)inputParam.get(fieldName);
        if (param == null) {
            return null;
        }
        return TTransferParameters.decode(param);
    }

    public static TTransferParameters decode(Map param) {
        int i;
        String[] clientNetworks = null;
        String[] transferProtocols = null;
        List<Object> vector = null;
        TAccessPattern accPatt = TAccessPattern.decode(param, TAccessPattern.PNAME_accessPattern);
        TConnectionType connType = TConnectionType.decode(param, TConnectionType.PNAME_connectionType);
        String memberName = new String("arrayOfClientNetworks");
        try {
            vector = Arrays.asList((Object[])param.get(memberName));
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        if (vector != null) {
            int arraySize = vector.size();
            clientNetworks = new String[arraySize];
            for (i = 0; i < arraySize; ++i) {
                clientNetworks[i] = (String)vector.get(i);
            }
        }
        memberName = new String("arrayOfTransferProtocols");
        try {
            vector = Arrays.asList((Object[])param.get(memberName));
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        if (vector != null) {
            int arraySize = vector.size();
            transferProtocols = new String[arraySize];
            for (i = 0; i < arraySize; ++i) {
                transferProtocols[i] = (String)vector.get(i);
            }
        }
        return new TTransferParameters(accPatt, connType, clientNetworks, transferProtocols);
    }

    public TAccessPattern getAccessPattern() {
        return this.accessPattern;
    }

    public TConnectionType getConnectionType() {
        return this.connectionType;
    }

    public String[] getArrayOfClientNetworks() {
        return this.arrayOfClientNetworks;
    }

    public String[] getArrayOfTransferProtocols() {
        return this.arrayOfTransferProtocols;
    }
}

