/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.srm.types;

import it.grid.storm.srm.types.TReturnStatus;
import java.util.Collection;
import java.util.LinkedList;

public enum TStatusCode {
    EMPTY,
    SRM_SUCCESS,
    SRM_FAILURE,
    SRM_AUTHENTICATION_FAILURE,
    SRM_AUTHORIZATION_FAILURE,
    SRM_INVALID_REQUEST,
    SRM_INVALID_PATH,
    SRM_FILE_LIFETIME_EXPIRED,
    SRM_SPACE_LIFETIME_EXPIRED,
    SRM_EXCEED_ALLOCATION,
    SRM_NO_USER_SPACE,
    SRM_NO_FREE_SPACE,
    SRM_DUPLICATION_ERROR,
    SRM_NON_EMPTY_DIRECTORY,
    SRM_TOO_MANY_RESULTS,
    SRM_INTERNAL_ERROR,
    SRM_FATAL_INTERNAL_ERROR,
    SRM_NOT_SUPPORTED,
    SRM_REQUEST_QUEUED(false),
    SRM_REQUEST_INPROGRESS(false),
    SRM_REQUEST_SUSPENDED(false),
    SRM_ABORTED,
    SRM_RELEASED,
    SRM_FILE_PINNED(false),
    SRM_FILE_IN_CACHE(false),
    SRM_FILE_BUSY,
    SRM_SPACE_AVAILABLE(false),
    SRM_LOWER_SPACE_GRANTED,
    SRM_DONE,
    SRM_PARTIAL_SUCCESS,
    SRM_REQUEST_TIMED_OUT,
    SRM_LAST_COPY,
    SRM_FILE_LOST,
    SRM_FILE_UNAVAILABLE,
    SRM_CUSTOM_STATUS(false);

    private final boolean finalStatus;
    private final LinkedList<TStatusCode> incompatibleStatuses = new LinkedList();

    private TStatusCode(boolean isFinal) {
        this.finalStatus = isFinal;
    }

    private void addIncompatibleStatus(TStatusCode incompatibleStatus) {
        this.incompatibleStatuses.add(incompatibleStatus);
    }

    private TStatusCode() {
        this(true);
    }

    public String getValue() {
        return this.name();
    }

    public boolean isFinalStatus() throws IllegalArgumentException {
        return this.finalStatus;
    }

    public boolean isCompatibleWith(Collection<TReturnStatus> statuses) {
        for (TReturnStatus status : statuses) {
            if (this.isCompatibleWith(status.getStatusCode())) continue;
            return false;
        }
        return true;
    }

    public boolean isCompatibleWith(TStatusCode statusCode) {
        if (statusCode.finalStatus) {
            return !this.finalStatus;
        }
        return !this.equals((Object)statusCode) && !this.incompatibleStatuses.contains((Object)statusCode);
    }

    static {
        SRM_FILE_PINNED.addIncompatibleStatus(SRM_REQUEST_SUSPENDED);
        SRM_FILE_PINNED.addIncompatibleStatus(SRM_SPACE_AVAILABLE);
        SRM_FILE_PINNED.addIncompatibleStatus(SRM_FILE_BUSY);
        SRM_SPACE_AVAILABLE.addIncompatibleStatus(SRM_REQUEST_SUSPENDED);
        SRM_SPACE_AVAILABLE.addIncompatibleStatus(SRM_FILE_PINNED);
        SRM_SPACE_AVAILABLE.addIncompatibleStatus(SRM_FILE_BUSY);
    }
}

