/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.srm.types;

import it.grid.storm.srm.types.InvalidTSpaceTokenAttributesException;
import java.io.Serializable;
import java.util.List;
import java.util.Map;

public class TSpaceToken
implements Serializable {
    public static String PNAME_SPACETOKEN = "spaceToken";
    private String token = "";
    private boolean empty = true;
    private static TSpaceToken emptyToken;

    private TSpaceToken(String token, boolean empty) {
        this.token = token;
        this.empty = empty;
    }

    public static TSpaceToken make(String s) throws InvalidTSpaceTokenAttributesException {
        if (s == null) {
            throw new InvalidTSpaceTokenAttributesException();
        }
        return new TSpaceToken(s, false);
    }

    public static TSpaceToken makeEmpty() {
        if (emptyToken != null) {
            return emptyToken;
        }
        emptyToken = new TSpaceToken("", true);
        return emptyToken;
    }

    public String getValue() {
        return this.token;
    }

    public boolean isEmpty() {
        return this.empty;
    }

    public String toString() {
        if (this.empty) {
            return "Empty";
        }
        return this.token;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TSpaceToken)) {
            return false;
        }
        TSpaceToken st = (TSpaceToken)o;
        if (this.empty && st.empty) {
            return true;
        }
        return !this.empty && !st.empty && this.token.equals(st.token);
    }

    public int hashCode() {
        if (this.empty) {
            return 0;
        }
        int hash = 17;
        return 37 * hash + this.token.hashCode();
    }

    public static final TSpaceToken decode(Map param, String name) {
        String tokenString = (String)param.get(name);
        TSpaceToken spaceToken = TSpaceToken.makeEmpty();
        if (tokenString != null) {
            try {
                spaceToken = TSpaceToken.make(tokenString);
            }
            catch (InvalidTSpaceTokenAttributesException e) {
                // empty catch block
            }
        }
        return spaceToken;
    }

    public void encode(List list) {
        list.add(this.toString());
    }

    public void encode(Map outputParam, String fieldName) {
        outputParam.put(fieldName, this.token);
    }
}

