/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.srm.types;

import it.grid.storm.common.types.SizeUnit;
import it.grid.storm.srm.types.InvalidTSizeAttributesException;
import java.io.Serializable;
import java.util.Map;

public class TSizeInBytes
implements Serializable {
    public static String PNAME_SIZE = "size";
    public static String PNAME_DESIREDSIZEOFTOTALSPACE = "desiredSizeOfTotalSpace";
    public static String PNAME_DESIREDSIZEOFGUARANTEEDSPACE = "desiredSizeOfGuaranteedSpace";
    public static String PNAME_SIZEOFTOTALRESERVEDSPACE = "sizeOfTotalReservedSpace";
    public static String PNAME_SIZEOFGUARANTEEDRESERVEDSPACE = "sizeOfGuaranteedReservedSpace";
    public static String PNAME_TOTALSIZE = "totalSize";
    public static String PNAME_GUARANTEEDSIZE = "guaranteedSize";
    public static String PNAME_UNUSEDSIZE = "unusedSize";
    private long size = -1L;
    private SizeUnit unit = SizeUnit.EMPTY;
    private boolean empty = true;
    private static TSizeInBytes emptySize = null;

    private TSizeInBytes(long size, SizeUnit unit, boolean empty) {
        this.size = size;
        this.unit = unit;
        this.empty = empty;
    }

    public static TSizeInBytes make(long size, SizeUnit unit) throws InvalidTSizeAttributesException {
        if (unit == null || size < 0L) {
            throw new InvalidTSizeAttributesException(size, unit);
        }
        return new TSizeInBytes(size, unit, false);
    }

    public static TSizeInBytes makeEmpty() {
        if (emptySize != null) {
            return emptySize;
        }
        emptySize = new TSizeInBytes(-1L, SizeUnit.EMPTY, true);
        return emptySize;
    }

    public static TSizeInBytes decode(Map inputParam, String fieldName) {
        String size = (String)inputParam.get(fieldName);
        if (size == null) {
            return TSizeInBytes.makeEmpty();
        }
        long sizeLong = Long.parseLong(size);
        TSizeInBytes decodedSize = null;
        try {
            decodedSize = TSizeInBytes.make(sizeLong, SizeUnit.BYTES);
        }
        catch (InvalidTSizeAttributesException e) {
            return TSizeInBytes.makeEmpty();
        }
        return decodedSize;
    }

    public double getSizeIn(SizeUnit unit) {
        if (unit != null && !this.empty) {
            Long l_size = new Long(this.size);
            double result = l_size.doubleValue() * (this.unit.conversionFactor() / unit.conversionFactor());
            return result;
        }
        return -1.0;
    }

    public long value() {
        if (this.empty) {
            return -1L;
        }
        return this.size;
    }

    public SizeUnit unit() {
        if (this.empty) {
            return SizeUnit.EMPTY;
        }
        return this.unit;
    }

    public boolean isEmpty() {
        return this.empty;
    }

    public void encode(Map param, String fieldName) {
        if (this.empty) {
            return;
        }
        Long sizeInBytes = new Long(this.value());
        long size_out = sizeInBytes != null ? sizeInBytes : -1L;
        param.put(fieldName, String.valueOf(size_out));
    }

    public String toString() {
        if (this.empty) {
            return "Empty";
        }
        return this.size + " " + this.unit;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TSizeInBytes)) {
            return false;
        }
        TSizeInBytes fs = (TSizeInBytes)o;
        if (this.empty && fs.empty) {
            return true;
        }
        return !this.empty && !fs.empty && this.size == fs.size && this.unit == fs.unit;
    }

    public int hashCode() {
        if (this.empty) {
            return 0;
        }
        int hash = 17;
        hash = 37 * hash + new Long(this.size).hashCode();
        hash = 37 * hash + this.unit.hashCode();
        return hash;
    }
}

