/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.srm.types;

import it.grid.storm.space.SpaceHelper;
import it.grid.storm.space.StorageSpaceData;
import it.grid.storm.srm.types.InvalidTMetaDataSpaceAttributeException;
import it.grid.storm.srm.types.InvalidTReturnStatusAttributeException;
import it.grid.storm.srm.types.InvalidTSizeAttributesException;
import it.grid.storm.srm.types.TLifeTimeInSeconds;
import it.grid.storm.srm.types.TRetentionPolicyInfo;
import it.grid.storm.srm.types.TReturnStatus;
import it.grid.storm.srm.types.TSizeInBytes;
import it.grid.storm.srm.types.TSpaceToken;
import it.grid.storm.srm.types.TSpaceType;
import it.grid.storm.srm.types.TStatusCode;
import it.grid.storm.srm.types.TUserID;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TMetaDataSpace
implements Serializable {
    private TSpaceType spaceType;
    private TReturnStatus status = null;
    private TSpaceToken spaceToken;
    private TRetentionPolicyInfo retentionPolicyInfo;
    private TUserID owner;
    private TSizeInBytes totalSize;
    private TSizeInBytes guaranteedSize;
    private TSizeInBytes unusedSize;
    private TLifeTimeInSeconds lifetimeAssigned = null;
    private TLifeTimeInSeconds lifetimeLeft = null;
    private static final Logger log = LoggerFactory.getLogger(TMetaDataSpace.class);

    public TMetaDataSpace() {
        this.spaceType = TSpaceType.EMPTY;
        this.status = null;
        this.spaceToken = TSpaceToken.makeEmpty();
        this.retentionPolicyInfo = null;
        this.owner = TUserID.makeEmpty();
        this.totalSize = TSizeInBytes.makeEmpty();
        this.guaranteedSize = TSizeInBytes.makeEmpty();
        this.unusedSize = TSizeInBytes.makeEmpty();
        this.lifetimeAssigned = TLifeTimeInSeconds.makeEmpty();
        this.lifetimeLeft = TLifeTimeInSeconds.makeEmpty();
    }

    public TMetaDataSpace(TSpaceType spaceType, TSpaceToken spaceToken, TReturnStatus status, TUserID user, TSizeInBytes totalSize, TSizeInBytes guaranteedSize, TSizeInBytes unusedSize, TLifeTimeInSeconds lifetimeAssigned, TLifeTimeInSeconds lifetimeLeft) throws InvalidTMetaDataSpaceAttributeException {
        boolean ok;
        boolean bl = ok = spaceToken != null;
        if (!ok) {
            throw new InvalidTMetaDataSpaceAttributeException(spaceToken);
        }
        this.spaceType = spaceType;
        this.spaceToken = spaceToken;
        this.status = status;
        this.owner = user;
        this.totalSize = totalSize;
        this.guaranteedSize = guaranteedSize;
        this.unusedSize = unusedSize;
        this.lifetimeAssigned = lifetimeAssigned;
        this.lifetimeLeft = lifetimeLeft;
    }

    public TMetaDataSpace(StorageSpaceData spaceData) throws InvalidTMetaDataSpaceAttributeException, InvalidTSizeAttributesException {
        if (spaceData == null) {
            log.warn("TMetaDataSpace built without SPACEDATA detail.");
            this.spaceType = TSpaceType.EMPTY;
            this.spaceToken = TSpaceToken.makeEmpty();
            try {
                this.status = new TReturnStatus(TStatusCode.SRM_INVALID_REQUEST, "Invalid space token");
            }
            catch (InvalidTReturnStatusAttributeException e) {
                this.status = null;
            }
            this.owner = TUserID.makeEmpty();
            this.totalSize = TSizeInBytes.makeEmpty();
            this.guaranteedSize = TSizeInBytes.makeEmpty();
            this.unusedSize = TSizeInBytes.makeEmpty();
            this.lifetimeAssigned = TLifeTimeInSeconds.makeEmpty();
            this.lifetimeLeft = TLifeTimeInSeconds.makeEmpty();
        } else {
            boolean ok;
            boolean bl = ok = spaceData.getSpaceToken() != null;
            if (!ok) {
                log.warn("TMetaDataSpace built with SpaceData without Token.. !?");
                throw new InvalidTMetaDataSpaceAttributeException(this.spaceToken);
            }
            this.spaceType = spaceData.getSpaceType();
            this.spaceToken = spaceData.getSpaceToken();
            this.owner = spaceData.getUserID();
            this.totalSize = spaceData.getTotalSpaceSize();
            this.guaranteedSize = spaceData.getTotalGuaranteedSize();
            try {
                this.guaranteedSize = SpaceHelper.isStorageArea(spaceData) ? spaceData.getTotalGuaranteedSize() : spaceData.getReservedSpaceSize();
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
            this.unusedSize = spaceData.getFreeSpaceSize();
            this.lifetimeAssigned = spaceData.getLifeTime();
            this.lifetimeLeft = this.lifetimeAssigned.isInfinite() ? TLifeTimeInSeconds.makeInfinite() : this.lifetimeAssigned.timeLeft(spaceData.getCreationDate());
            try {
                this.status = this.lifetimeLeft.value() == 0L && this.spaceType != TSpaceType.VOSPACE ? new TReturnStatus(TStatusCode.SRM_SPACE_LIFETIME_EXPIRED, "Expired space lifetime") : new TReturnStatus(TStatusCode.SRM_SUCCESS, "Valid space token");
            }
            catch (InvalidTReturnStatusAttributeException e) {
                this.status = null;
            }
        }
    }

    public static TMetaDataSpace makeEmpty() {
        return new TMetaDataSpace();
    }

    public TSpaceType getSpaceType() {
        return this.spaceType;
    }

    public TReturnStatus getStatus() {
        return this.status;
    }

    public void setStatus(TReturnStatus status) {
        this.status = status;
    }

    public TSpaceToken getSpaceToken() {
        return this.spaceToken;
    }

    public void setSpaceToken(TSpaceToken token) {
        this.spaceToken = token;
    }

    public void setSpaceType(TSpaceType type) {
        this.spaceType = type;
    }

    public void setOwner(TUserID uid) {
        this.owner = uid;
    }

    public void setTotalSize(TSizeInBytes tsize) {
        this.totalSize = tsize;
    }

    public void setGuarSize(TSizeInBytes gsize) {
        this.guaranteedSize = gsize;
    }

    public void setUnSize(TSizeInBytes usize) {
        this.unusedSize = usize;
    }

    public void setLifeTime(TLifeTimeInSeconds time) {
        this.lifetimeAssigned = time;
    }

    public void setLifeTimeLeft(TLifeTimeInSeconds time) {
        this.lifetimeLeft = time;
    }

    public TRetentionPolicyInfo getRetentionPolicyInfo() {
        return this.retentionPolicyInfo;
    }

    public void setRetentionPolicyInfo(TRetentionPolicyInfo retentionPolicyInfo) {
        this.retentionPolicyInfo = retentionPolicyInfo;
    }

    public TUserID getUserID() {
        return this.owner;
    }

    public TSizeInBytes getTotalSize() {
        return this.totalSize;
    }

    public TSizeInBytes getGuaranteedSize() {
        return this.guaranteedSize;
    }

    public TSizeInBytes getUnusedSize() {
        return this.unusedSize;
    }

    public TLifeTimeInSeconds getLifeTimeAssigned() {
        return this.lifetimeAssigned;
    }

    public TLifeTimeInSeconds getLifeTimeLeft() {
        return this.lifetimeLeft;
    }

    public void encode(Map outputParam, String fieldName) {
        HashMap metaDataSpace = new HashMap();
        this.encode(metaDataSpace);
        outputParam.put(fieldName, metaDataSpace);
    }

    public void encode(Map metaDataSpace) {
        this.spaceToken.encode(metaDataSpace, TSpaceToken.PNAME_SPACETOKEN);
        if (this.status != null) {
            this.status.encode(metaDataSpace, "status");
        }
        if (this.retentionPolicyInfo != null) {
            this.retentionPolicyInfo.encode(metaDataSpace, TRetentionPolicyInfo.PNAME_retentionPolicyInfo);
        }
        this.owner.encode(metaDataSpace, TUserID.PNAME_OWNER);
        this.totalSize.encode(metaDataSpace, TSizeInBytes.PNAME_TOTALSIZE);
        this.guaranteedSize.encode(metaDataSpace, TSizeInBytes.PNAME_GUARANTEEDSIZE);
        this.unusedSize.encode(metaDataSpace, TSizeInBytes.PNAME_UNUSEDSIZE);
        this.lifetimeAssigned.encode(metaDataSpace, TLifeTimeInSeconds.PNAME_LIFETIMEASSIGNED);
        this.lifetimeLeft.encode(metaDataSpace, TLifeTimeInSeconds.PNAME_LIFETIMELEFT);
    }
}

