/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.srm.types;

import java.util.Map;

public class TFileLocality {
    public static String PNAME_FILELOCALITY = "fileLocality";
    public static final TFileLocality ONLINE = new TFileLocality("ONLINE");
    public static final TFileLocality NEARLINE = new TFileLocality("NEARLINE");
    public static final TFileLocality ONLINE_AND_NEARLINE = new TFileLocality("ONLINE_AND_NEARLINE");
    public static final TFileLocality LOST = new TFileLocality("LOST");
    public static final TFileLocality NONE = new TFileLocality("NONE");
    public static final TFileLocality UNAVAILABLE = new TFileLocality("UNAVAILABLE");
    public static final TFileLocality EMPTY = new TFileLocality("");
    private String fileLocality = null;

    private TFileLocality(String fileLoc) {
        this.fileLocality = fileLoc;
    }

    public String toString() {
        return this.fileLocality;
    }

    public String getValue() {
        return this.fileLocality;
    }

    public static TFileLocality getTFileLocality(String loc) {
        if (loc.toLowerCase().replaceAll(" ", "").equals(ONLINE.getValue().toLowerCase())) {
            return ONLINE;
        }
        if (loc.toLowerCase().replaceAll(" ", "").equals(NEARLINE.getValue().toLowerCase())) {
            return NEARLINE;
        }
        if (loc.toLowerCase().replaceAll(" ", "").equals(ONLINE_AND_NEARLINE.getValue().toLowerCase())) {
            return ONLINE_AND_NEARLINE;
        }
        if (loc.toLowerCase().replaceAll(" ", "").equals(LOST.getValue().toLowerCase())) {
            return LOST;
        }
        if (loc.toLowerCase().replaceAll(" ", "").equals(NONE.getValue().toLowerCase())) {
            return NONE;
        }
        if (loc.toLowerCase().replaceAll(" ", "").equals(UNAVAILABLE.getValue().toLowerCase())) {
            return UNAVAILABLE;
        }
        return EMPTY;
    }

    public static TFileLocality getTFileLocality(int loc) {
        switch (loc) {
            case 0: {
                return ONLINE;
            }
            case 1: {
                return NEARLINE;
            }
            case 2: {
                return ONLINE_AND_NEARLINE;
            }
            case 3: {
                return LOST;
            }
            case 4: {
                return NONE;
            }
            case 5: {
                return UNAVAILABLE;
            }
        }
        return EMPTY;
    }

    public static TFileLocality decode(Map inputParam, String name) {
        Integer fileLoc = (Integer)inputParam.get(name);
        if (fileLoc != null) {
            return TFileLocality.getTFileLocality(fileLoc);
        }
        return EMPTY;
    }

    public void encode(Map param, String name) {
        Integer value = null;
        if (this.equals(ONLINE)) {
            value = new Integer(0);
        }
        if (this.equals(NEARLINE)) {
            value = new Integer(1);
        }
        if (this.equals(ONLINE_AND_NEARLINE)) {
            value = new Integer(2);
        }
        if (this.equals(LOST)) {
            value = new Integer(3);
        }
        if (this.equals(NONE)) {
            value = new Integer(4);
        }
        if (this.equals(UNAVAILABLE)) {
            value = new Integer(5);
        }
        param.put(name, value);
    }
}

