/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.srm.types;

import it.grid.storm.srm.types.InvalidTDirOptionAttributesException;

public class TDirOption {
    private boolean isASourceDirectory;
    private boolean allLevelRecursive;
    private int numOfLevels = 0;

    public TDirOption(boolean isDirectory, boolean allLevel) throws InvalidTDirOptionAttributesException {
        this.allLevelRecursive = allLevel;
        this.isASourceDirectory = isDirectory;
        if (!this.allLevelRecursive) {
            throw new InvalidTDirOptionAttributesException(allLevel, -1);
        }
    }

    private TDirOption(boolean isDirectory) {
        this.isASourceDirectory = isDirectory;
        this.allLevelRecursive = false;
    }

    public static TDirOption makeNotDirectory() {
        TDirOption builtInstance = new TDirOption(false);
        return builtInstance;
    }

    public TDirOption(boolean isDirectory, boolean allLevel, int numLevel) throws InvalidTDirOptionAttributesException {
        if (allLevel && numLevel > 0) {
            throw new InvalidTDirOptionAttributesException(allLevel, numLevel);
        }
        this.allLevelRecursive = allLevel;
        this.numOfLevels = numLevel;
        this.isASourceDirectory = isDirectory;
    }

    public boolean isDirectory() {
        return this.isASourceDirectory;
    }

    public boolean isAllLevelRecursive() {
        return this.allLevelRecursive;
    }

    public int getNumLevel() {
        if (!this.allLevelRecursive) {
            return this.numOfLevels;
        }
        return 0;
    }

    public String toString() {
        return "isASourceDirectory=" + this.isASourceDirectory + " allLevelRecursive=" + this.allLevelRecursive + " numOfLevels=" + this.numOfLevels;
    }
}

