/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.srm.types;

import it.grid.storm.srm.types.InvalidArrayOfTSpaceTokenAttributeException;
import it.grid.storm.srm.types.InvalidTSpaceTokenAttributesException;
import it.grid.storm.srm.types.TSpaceToken;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArrayOfTSpaceToken
implements Serializable {
    private static Logger log = LoggerFactory.getLogger(ArrayOfTSpaceToken.class);
    public static final String PNAME_ARRAYOFSPACETOKENS = "arrayOfSpaceTokens";
    ArrayList<TSpaceToken> tokenList;

    public ArrayOfTSpaceToken(TSpaceToken[] tokenArray) throws InvalidArrayOfTSpaceTokenAttributeException {
        if (tokenArray == null) {
            throw new InvalidArrayOfTSpaceTokenAttributeException(tokenArray);
        }
    }

    public ArrayOfTSpaceToken() {
        this.tokenList = new ArrayList();
    }

    public static ArrayOfTSpaceToken decode(Map inputParam, String fieldName) throws InvalidArrayOfTSpaceTokenAttributeException {
        List<Object> tokensList = null;
        try {
            tokensList = Arrays.asList((Object[])inputParam.get(fieldName));
        }
        catch (NullPointerException e) {
            log.warn("");
        }
        if (tokensList == null) {
            throw new InvalidArrayOfTSpaceTokenAttributeException(null);
        }
        ArrayOfTSpaceToken arrayOfTSpaceTokens = new ArrayOfTSpaceToken();
        for (int i = 0; i < tokensList.size(); ++i) {
            TSpaceToken token = null;
            try {
                token = TSpaceToken.make((String)tokensList.get(i));
            }
            catch (InvalidTSpaceTokenAttributesException e) {
                token = TSpaceToken.makeEmpty();
            }
            arrayOfTSpaceTokens.addTSpaceToken(token);
        }
        return arrayOfTSpaceTokens;
    }

    public TSpaceToken getTSpaceToken(int i) {
        return this.tokenList.get(i);
    }

    public TSpaceToken[] getTSpaceTokenArray() {
        TSpaceToken[] array = new TSpaceToken[]{};
        return this.tokenList.toArray(array);
    }

    public void addTSpaceToken(TSpaceToken token) {
        this.tokenList.add(token);
    }

    public int size() {
        return this.tokenList.size();
    }

    public void encode(Map outputParam, String name) {
        Vector vector = new Vector();
        for (int i = 0; i < this.tokenList.size(); ++i) {
            this.tokenList.get(i).encode(vector);
        }
        outputParam.put(name, vector);
    }
}

