/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.srm.types;

import it.grid.storm.srm.types.InvalidArrayOfTSURLReturnStatusAttributeException;
import it.grid.storm.srm.types.TReturnStatus;
import it.grid.storm.srm.types.TSURLReturnStatus;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;

public class ArrayOfTSURLReturnStatus {
    public static String PNAME_ARRAYOFFILESTATUSES = "arrayOfFileStatuses";
    ArrayList<TSURLReturnStatus> surlRetList;

    public ArrayOfTSURLReturnStatus(int numItems) {
        this.surlRetList = new ArrayList(numItems);
    }

    public ArrayOfTSURLReturnStatus(TSURLReturnStatus[] surlArray) throws InvalidArrayOfTSURLReturnStatusAttributeException {
        if (surlArray == null) {
            throw new InvalidArrayOfTSURLReturnStatusAttributeException(surlArray);
        }
        this.surlRetList = new ArrayList<TSURLReturnStatus>(Arrays.asList(surlArray));
    }

    public ArrayOfTSURLReturnStatus() {
        this.surlRetList = new ArrayList();
    }

    public ArrayList<TSURLReturnStatus> getArray() {
        return this.surlRetList;
    }

    public TSURLReturnStatus getTSURLReturnStatus(int i) {
        return this.surlRetList.get(i);
    }

    public void setTSURLReturnStatus(int index, TSURLReturnStatus surl) {
        this.surlRetList.set(index, surl);
    }

    public void addTSurlReturnStatus(TSURLReturnStatus surl) {
        this.surlRetList.add(surl);
    }

    public int size() {
        return this.surlRetList.size();
    }

    public void updateStatus(TSURLReturnStatus surlStatus, TReturnStatus newStatus) throws IllegalArgumentException {
        if (surlStatus == null || newStatus == null) {
            throw new IllegalArgumentException("Unable to update the status,null arguments: surlStatus=" + surlStatus + " newStatus=" + newStatus);
        }
        int index = this.surlRetList.indexOf(surlStatus);
        if (index < 0) {
            throw new IllegalArgumentException("Unable to update the status,unknown TSURLReturnStatus" + surlStatus);
        }
        this.surlRetList.get(index).setStatus(newStatus);
    }

    public void encode(Map outputParam, String name) {
        ArrayList list = new ArrayList();
        for (int i = 0; i < this.surlRetList.size(); ++i) {
            this.surlRetList.get(i).encode(list);
        }
        outputParam.put(name, list);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ArrayOfTSURLReturnStatus [surlRetList=");
        builder.append(this.surlRetList);
        builder.append("]");
        return builder.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.surlRetList == null ? 0 : this.surlRetList.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ArrayOfTSURLReturnStatus other = (ArrayOfTSURLReturnStatus)obj;
        return !(this.surlRetList == null ? other.surlRetList != null : !this.surlRetList.equals(other.surlRetList));
    }
}

