/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.srm.types;

import it.grid.storm.srm.types.InvalidArrayOfTExtraInfoAttributeException;
import it.grid.storm.srm.types.InvalidTExtraInfoAttributeException;
import it.grid.storm.srm.types.TExtraInfo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class ArrayOfTExtraInfo
implements Serializable {
    public static String PNAME_STORAGESYSTEMINFO = "storageSystemInfo";
    private ArrayList<TExtraInfo> extraInfoList;

    public ArrayOfTExtraInfo(TExtraInfo[] infoArray) throws InvalidArrayOfTExtraInfoAttributeException {
        if (infoArray == null) {
            throw new InvalidArrayOfTExtraInfoAttributeException(infoArray);
        }
    }

    public ArrayOfTExtraInfo() {
        this.extraInfoList = new ArrayList();
    }

    public Object[] getArray() {
        return this.extraInfoList.toArray();
    }

    public TExtraInfo getTSpaceToken(int i) {
        return this.extraInfoList.get(i);
    }

    public void setTExtraInfo(int index, TExtraInfo info) {
        this.extraInfoList.set(index, info);
    }

    public void addTExtraInfo(TExtraInfo info) {
        this.extraInfoList.add(info);
    }

    public int size() {
        return this.extraInfoList.size();
    }

    public static ArrayOfTExtraInfo decode(Map inputParam, String fieldName) throws InvalidArrayOfTExtraInfoAttributeException {
        List<Object> list = null;
        try {
            list = Arrays.asList((Object[])inputParam.get(fieldName));
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        if (list == null) {
            throw new InvalidArrayOfTExtraInfoAttributeException(null);
        }
        ArrayOfTExtraInfo extraInfoArray = new ArrayOfTExtraInfo();
        for (int i = 0; i < list.size(); ++i) {
            Hashtable extraInfo = (Hashtable)list.get(i);
            try {
                extraInfoArray.addTExtraInfo(TExtraInfo.decode(extraInfo));
                continue;
            }
            catch (InvalidTExtraInfoAttributeException e) {
                throw new InvalidArrayOfTExtraInfoAttributeException(null);
            }
        }
        return extraInfoArray;
    }

    public void encode(Map outputParam, String name) {
        Vector vector = new Vector();
        for (TExtraInfo extraInfo : this.extraInfoList) {
            Hashtable extraInfoMap = new Hashtable();
            extraInfo.encode(extraInfoMap);
            vector.add(extraInfoMap);
        }
        outputParam.put(name, vector);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.extraInfoList != null) {
            sb.append("[");
            for (TExtraInfo element : this.extraInfoList) {
                sb.append(element.toString());
            }
            sb.append("]");
        } else {
            sb.append("EMPTY LIST");
        }
        return sb.toString();
    }
}

