/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.srm.types;

import it.grid.storm.srm.types.InvalidArrayOfSURLsAttributeException;
import it.grid.storm.srm.types.InvalidTSURLAttributesException;
import it.grid.storm.srm.types.TSURL;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class ArrayOfSURLs
implements Serializable {
    private static final long serialVersionUID = -6162739978949956886L;
    public static final String ARRAYOFSURLS = "arrayOfSURLs";
    ArrayList<TSURL> surlList;

    public ArrayOfSURLs(TSURL[] surlArray) throws IllegalArgumentException {
        if (surlArray == null) {
            throw new IllegalArgumentException("Unable to create the object, null arguments: surlArray=" + surlArray);
        }
        this.surlList = new ArrayList<TSURL>(Arrays.asList(surlArray));
    }

    public ArrayOfSURLs() {
        this.surlList = new ArrayList();
    }

    public ArrayList<TSURL> getArrayList() {
        return this.surlList;
    }

    public TSURL getTSURL(int i) {
        return this.surlList.get(i);
    }

    public void setTSURL(int index, TSURL surl) {
        this.surlList.set(index, surl);
    }

    public void addTSURL(TSURL surl) {
        this.surlList.add(surl);
    }

    public int size() {
        return this.surlList.size();
    }

    public static ArrayOfSURLs decode(Map inputParam, String name) throws InvalidArrayOfSURLsAttributeException {
        List<Object> list = null;
        ArrayOfSURLs surlArray = new ArrayOfSURLs();
        try {
            list = Arrays.asList((Object[])inputParam.get(name));
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        if (list == null) {
            throw new InvalidArrayOfSURLsAttributeException(list);
        }
        for (Object e : list) {
            TSURL surl = null;
            try {
                surl = TSURL.makeFromStringValidate((String)e);
            }
            catch (InvalidTSURLAttributesException e2) {
                throw new InvalidArrayOfSURLsAttributeException(null);
            }
            surlArray.addTSURL(surl);
        }
        return surlArray;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("");
        if (this.surlList != null) {
            for (int i = 0; i < this.surlList.size(); ++i) {
                buf.append("'" + this.surlList.get(i) + "'");
                if (i + 1 >= this.surlList.size()) continue;
                buf.append(",");
            }
        } else {
            return buf.toString();
        }
        return buf.toString();
    }

    public List<String> asStringList() {
        ArrayList<String> stringList = new ArrayList<String>(this.surlList.size());
        if (this.surlList != null) {
            for (TSURL surl : this.surlList) {
                stringList.add(surl.toString());
            }
        }
        return stringList;
    }
}

