/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.space.quota;

import it.grid.storm.common.types.SizeUnit;
import it.grid.storm.common.types.TimeUnit;
import it.grid.storm.namespace.model.QuotaType;
import it.grid.storm.space.quota.QuotaInfoInterface;

public abstract class QuotaInfoAbstract
implements QuotaInfoInterface {
    private String filesystemName = null;
    private QuotaType quotaType = null;
    private long blockUsage = -1L;
    private long blockHardLimit = -1L;
    private long blockSoftLimit = -1L;
    private long blockGraceTime = -1L;
    private long iNodeUsage = -1L;
    private long iNodeHardLimit = -1L;
    private long iNodeSoftLimit = -1L;
    private long iNodeGraceTime = -1L;
    private SizeUnit sizeUnit = SizeUnit.KILOBYTES;
    private TimeUnit iNodeTimeUnit = TimeUnit.DAYS;
    private TimeUnit sizeTimeUnit = TimeUnit.DAYS;

    @Override
    public long getBlockGraceTime() {
        return this.blockGraceTime;
    }

    @Override
    public long getBlockHardLimit() {
        return this.blockHardLimit;
    }

    @Override
    public long getBlockSoftLimit() {
        return this.blockSoftLimit;
    }

    @Override
    public long getBlockUsage() {
        return this.blockUsage;
    }

    @Override
    public String getFilesystemName() {
        return this.filesystemName;
    }

    @Override
    public long getINodeGraceTime() {
        return this.iNodeGraceTime;
    }

    @Override
    public long getINodeHardLimit() {
        return this.iNodeHardLimit;
    }

    @Override
    public long getINodeSoftLimit() {
        return this.iNodeSoftLimit;
    }

    @Override
    public long getINodeUsage() {
        return this.iNodeUsage;
    }

    @Override
    public QuotaType getQuotaType() {
        return this.quotaType;
    }

    @Override
    public SizeUnit getSizeUnit() {
        return this.sizeUnit;
    }

    @Override
    public TimeUnit getINodeTimeUnit() {
        return this.iNodeTimeUnit;
    }

    @Override
    public TimeUnit getSizeTimeUnit() {
        return this.sizeTimeUnit;
    }

    @Override
    public void setBlockGraceTime(String blockGraceTime) {
        long graceTime = -1L;
        try {
            graceTime = Long.parseLong(blockGraceTime);
        }
        catch (NumberFormatException nfe) {
            graceTime = 0L;
            this.sizeTimeUnit = TimeUnit.EMPTY;
        }
        this.blockGraceTime = graceTime;
    }

    @Override
    public void setBlockHardLimit(long blockHardLimit) {
        this.blockHardLimit = blockHardLimit;
    }

    @Override
    public void setBlockSoftLimit(long blockSoftLimit) {
        this.blockSoftLimit = blockSoftLimit;
    }

    @Override
    public void setBlockUsage(long blockUsage) {
        this.blockUsage = blockUsage;
    }

    @Override
    public void setFilesystemName(String fileSystemName) {
        this.filesystemName = fileSystemName;
    }

    @Override
    public void setINodeGraceTime(String iNodeGraceTime) {
        long graceTime = -1L;
        try {
            graceTime = Long.parseLong(iNodeGraceTime);
        }
        catch (NumberFormatException nfe) {
            graceTime = 0L;
            this.iNodeTimeUnit = TimeUnit.EMPTY;
        }
        this.iNodeGraceTime = graceTime;
    }

    @Override
    public void setINodeHardLimit(long iNodeHardLimit) {
        this.iNodeHardLimit = iNodeHardLimit;
    }

    @Override
    public void setINodeSoftLimit(long iNodeSoftLimit) {
        this.iNodeSoftLimit = iNodeSoftLimit;
    }

    @Override
    public void setINodeUsage(long iNodeUsage) {
        this.iNodeUsage = iNodeUsage;
    }

    @Override
    public void setQuotaType(QuotaType quotaType) {
        this.quotaType = quotaType;
    }

    @Override
    public void setSizeUnit(String sizeUnit) {
        this.sizeUnit = SizeUnit.createSizeUnit(sizeUnit);
    }

    @Override
    public void setINodeTimeUnit(String timeUnit) {
        this.iNodeTimeUnit = TimeUnit.createTimeUnit(timeUnit);
    }

    @Override
    public void setSizeTimeUnit(String timeUnit) {
        this.sizeTimeUnit = TimeUnit.createTimeUnit(timeUnit);
    }
}

