/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.space.quota;

import it.grid.storm.namespace.model.Quota;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GPFSQuotaInfo {
    private static final Logger log = LoggerFactory.getLogger(GPFSQuotaInfo.class);
    private boolean initializated = false;
    private boolean failure = false;
    private String deviceName;
    private static int deviceNameIndex = 0;
    private String quotaEntryName;
    private static int quotaEntryNameIndex = 1;
    private QuotaType quotaType;
    private static int quotaTypeIndex = 2;
    private long currentBlocksUsage = -1L;
    private static int currentBlocksUsageIndex = 3;
    private long softBlocksLimit = -1L;
    private static int softBlocksLimitIndex = 4;
    private long hardBlocksLimit = -1L;
    private static int hardBlocksLimitIndex = 5;
    private long spaceInDoubt = -1L;
    private static int spaceInDoubtIndex = 6;
    private String blockGracePeriod;
    private static int blockGracePeriodIndex = 7;
    private long currentNumberOfFiles = -1L;
    private static int currentNumberOfFilesIndex = 9;
    private long softFilesLimit = -1L;
    private static int softFilesLimitIndex = 10;
    private long hardFilesLimit = -1L;
    private static int hardFilesLimitIndex = 11;
    private long filesInDoubt = -1L;
    private static int filesInDoubtIndex = 12;
    private String fileGracePeriod;
    private static int fileGracePeriodIndex = 13;
    private EntryType entryType;
    private static int entryTypeIndex = 14;

    public final boolean isFailure() {
        return this.failure;
    }

    public final void setFailure(boolean failure) {
        this.failure = failure;
    }

    public final String getDeviceName() {
        return this.deviceName;
    }

    public final String getQuotaEntryName() {
        return this.quotaEntryName;
    }

    public final QuotaType getQuotaType() {
        return this.quotaType;
    }

    public final long getCurrentBlocksUsage() {
        return this.currentBlocksUsage;
    }

    public final long getSoftBlocksLimit() {
        return this.softBlocksLimit;
    }

    public final long getHardBlocksLimit() {
        return this.hardBlocksLimit;
    }

    public final long getSpaceInDoubt() {
        return this.spaceInDoubt;
    }

    public final String getBlockGracePeriod() {
        return this.blockGracePeriod;
    }

    public final long getCurrentNumebrOfFiles() {
        return this.currentNumberOfFiles;
    }

    public final long getSoftFilesLimit() {
        return this.softFilesLimit;
    }

    public final long getHardFilesLimit() {
        return this.hardFilesLimit;
    }

    public final long getFilesInDoubt() {
        return this.filesInDoubt;
    }

    public final String getFileGracePeriod() {
        return this.fileGracePeriod;
    }

    public final EntryType getEntryType() {
        return this.entryType;
    }

    public static List<String> splitTokens(String outputLine) {
        ArrayList<String> outputList = new ArrayList<String>();
        if (outputLine != null) {
            StringTokenizer st = new StringTokenizer(outputLine);
            int cont = 0;
            while (st.hasMoreTokens()) {
                String element = st.nextToken();
                outputList.add(element);
                log.trace(element);
                ++cont;
            }
        }
        return outputList;
    }

    public static final boolean meaningfullLine(String outputLine) {
        boolean result = true;
        List<String> tokens = GPFSQuotaInfo.splitTokens(outputLine);
        if (tokens.size() != 15) {
            result = false;
        } else if (tokens.get(0) != null && tokens.get(0).equals("Name")) {
            result = false;
        }
        return result;
    }

    public void build(String outputLine) {
        this.initializated = true;
        List<String> outputList = GPFSQuotaInfo.splitTokens(outputLine);
        this.deviceName = outputList.get(deviceNameIndex);
        this.quotaEntryName = outputList.get(quotaEntryNameIndex);
        this.quotaType = QuotaType.getQuotaType(outputList.get(quotaTypeIndex));
        try {
            this.currentBlocksUsage = Long.parseLong(outputList.get(currentBlocksUsageIndex));
        }
        catch (NumberFormatException nfe) {
            log.warn("Unable to parse Long '" + outputList.get(currentBlocksUsageIndex) + "'");
            this.currentBlocksUsage = 0L;
        }
        try {
            this.softBlocksLimit = Long.parseLong(outputList.get(softBlocksLimitIndex));
        }
        catch (NumberFormatException nfe) {
            log.warn("Unable to parse Long '" + outputList.get(softBlocksLimitIndex) + "'");
            this.softBlocksLimit = 0L;
        }
        try {
            this.hardBlocksLimit = Long.parseLong(outputList.get(hardBlocksLimitIndex));
        }
        catch (NumberFormatException nfe) {
            log.warn("Unable to parse Long '" + outputList.get(hardBlocksLimitIndex) + "'");
            this.hardBlocksLimit = 0L;
        }
        try {
            this.spaceInDoubt = Long.parseLong(outputList.get(spaceInDoubtIndex));
        }
        catch (NumberFormatException nfe) {
            log.warn("Unable to parse Long '" + outputList.get(spaceInDoubtIndex) + "'");
            this.spaceInDoubt = 0L;
        }
        this.blockGracePeriod = outputList.get(blockGracePeriodIndex);
        try {
            this.currentNumberOfFiles = Long.parseLong(outputList.get(currentNumberOfFilesIndex));
        }
        catch (NumberFormatException nfe) {
            log.warn("Unable to parse Long '" + outputList.get(currentNumberOfFilesIndex) + "'");
            this.currentNumberOfFiles = 0L;
        }
        try {
            this.softFilesLimit = Long.parseLong(outputList.get(softFilesLimitIndex));
        }
        catch (NumberFormatException nfe) {
            log.warn("Unable to parse Long '" + outputList.get(softFilesLimitIndex) + "'");
            this.softFilesLimit = 0L;
        }
        try {
            this.hardFilesLimit = Long.parseLong(outputList.get(hardFilesLimitIndex));
        }
        catch (NumberFormatException nfe) {
            log.warn("Unable to parse Long '" + outputList.get(hardFilesLimitIndex) + "'");
            this.hardFilesLimit = 0L;
        }
        try {
            this.filesInDoubt = Long.parseLong(outputList.get(filesInDoubtIndex));
        }
        catch (NumberFormatException nfe) {
            log.warn("Unable to parse Long '" + outputList.get(filesInDoubtIndex) + "'");
            this.filesInDoubt = 0L;
        }
        this.fileGracePeriod = outputList.get(fileGracePeriodIndex);
        this.entryType = EntryType.getEntryType(outputList.get(entryTypeIndex));
    }

    public boolean isInitializated() {
        return this.initializated;
    }

    public void buildLs(String line, Quota quotaElement) {
        this.initializated = true;
        List<String> outputList = GPFSQuotaInfo.splitTokens(line);
        this.deviceName = outputList.get(0);
        this.quotaEntryName = quotaElement.getQuotaElementName();
        log.debug("QuotaEntryName : " + this.quotaEntryName);
        this.quotaType = QuotaType.getQuotaType(outputList.get(1));
        try {
            this.currentBlocksUsage = Long.parseLong(outputList.get(2));
        }
        catch (NumberFormatException nfe) {
            log.warn("Unable to parse Long '" + outputList.get(2) + "'");
            this.currentBlocksUsage = 0L;
        }
        try {
            this.softBlocksLimit = Long.parseLong(outputList.get(3));
        }
        catch (NumberFormatException nfe) {
            log.warn("Unable to parse Long '" + outputList.get(3) + "'");
            this.softBlocksLimit = 0L;
        }
        try {
            this.hardBlocksLimit = Long.parseLong(outputList.get(4));
        }
        catch (NumberFormatException nfe) {
            log.warn("Unable to parse Long '" + outputList.get(4) + "'");
            this.hardBlocksLimit = 0L;
        }
        try {
            this.spaceInDoubt = Long.parseLong(outputList.get(5));
        }
        catch (NumberFormatException nfe) {
            log.warn("Unable to parse Long '" + outputList.get(5) + "'");
            this.spaceInDoubt = 0L;
        }
        this.blockGracePeriod = outputList.get(6);
        try {
            this.currentNumberOfFiles = Long.parseLong(outputList.get(8));
        }
        catch (NumberFormatException nfe) {
            log.warn("Unable to parse Long '" + outputList.get(8) + "'");
            this.currentNumberOfFiles = 0L;
        }
        try {
            this.softFilesLimit = Long.parseLong(outputList.get(9));
        }
        catch (NumberFormatException nfe) {
            log.warn("Unable to parse Long '" + outputList.get(9) + "'");
            this.softFilesLimit = 0L;
        }
        try {
            this.hardFilesLimit = Long.parseLong(outputList.get(10));
        }
        catch (NumberFormatException nfe) {
            log.warn("Unable to parse Long '" + outputList.get(10) + "'");
            this.hardFilesLimit = 0L;
        }
        try {
            this.filesInDoubt = Long.parseLong(outputList.get(11));
        }
        catch (NumberFormatException nfe) {
            log.warn("Unable to parse Long '" + outputList.get(11) + "'");
            this.filesInDoubt = 0L;
        }
        this.fileGracePeriod = outputList.get(12);
        this.entryType = EntryType.UNDEFINED;
    }

    public static boolean meaningfullLineForLS(String line) {
        boolean result = true;
        List<String> tokens = GPFSQuotaInfo.splitTokens(line);
        int size = tokens.size();
        if (size != 13 && size != 14) {
            result = false;
        } else if (tokens.get(0) != null && tokens.get(0).equals("Filesystem")) {
            result = false;
        }
        return result;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("GPFSQuotaInfo [deviceName=");
        builder.append(this.deviceName);
        builder.append(", quotaEntryName=");
        builder.append(this.quotaEntryName);
        builder.append(", quotaType=");
        builder.append((Object)this.quotaType);
        builder.append(", currentBlocksUsage=");
        builder.append(this.currentBlocksUsage);
        builder.append(", softBlocksLimit=");
        builder.append(this.softBlocksLimit);
        builder.append(", hardBlocksLimit=");
        builder.append(this.hardBlocksLimit);
        builder.append(", spaceInDoubt=");
        builder.append(this.spaceInDoubt);
        builder.append(", blockGracePeriod=");
        builder.append(this.blockGracePeriod);
        builder.append(", currentNumberOfFiles=");
        builder.append(this.currentNumberOfFiles);
        builder.append(", softFilesLimit=");
        builder.append(this.softFilesLimit);
        builder.append(", hardFilesLimit=");
        builder.append(this.hardFilesLimit);
        builder.append(", filesInDoubt=");
        builder.append(this.filesInDoubt);
        builder.append(", fileGracePeriod=");
        builder.append(this.fileGracePeriod);
        builder.append(", entryType=");
        builder.append((Object)this.entryType);
        builder.append("]");
        return builder.toString();
    }

    public static enum EntryType {
        DEFAULT_ON(0, "default on"),
        DEFAULT_OFF(1, "default off"),
        EXPLICIT_QUOTA(2, "e"),
        DEFAULT_QUOTA(3, "d"),
        INITIAL_QUOTA(4, "i"),
        UNDEFINED(-1, "?");

        private int code;
        private String printOut;

        private EntryType(int c, String printOut) {
            this.code = c;
            this.printOut = printOut;
        }

        public int getCode() {
            return this.code;
        }

        public String getPrintOut() {
            return this.printOut;
        }

        static EntryType getEntryType(String printOut) {
            EntryType result = UNDEFINED;
            for (EntryType et : EntryType.values()) {
                if (!et.getPrintOut().equals(printOut)) continue;
                result = et;
                break;
            }
            return result;
        }
    }

    public static enum QuotaType {
        USR(0, "USR"),
        GRP(1, "GRP"),
        FILESET(2, "FILESET"),
        UNDEFINED(-1, "UNDEFINED");

        private int code;
        private String printOut;

        private QuotaType(int c, String printOut) {
            this.code = c;
            this.printOut = printOut;
        }

        public int getCode() {
            return this.code;
        }

        public String getPrintOut() {
            return this.printOut;
        }

        static QuotaType getQuotaType(int code) {
            QuotaType result = UNDEFINED;
            for (QuotaType qt : QuotaType.values()) {
                if (qt.getCode() != code) continue;
                result = qt;
                break;
            }
            return result;
        }

        static QuotaType getQuotaType(String printOut) {
            QuotaType result = UNDEFINED;
            for (QuotaType qt : QuotaType.values()) {
                if (!qt.getPrintOut().equals(printOut)) continue;
                result = qt;
                break;
            }
            return result;
        }
    }
}

